/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkaccesscontrol;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.bulkaccesscontrol.BulkAccessControlScriptConfiguration;
import org.dspace.app.bulkaccesscontrol.exception.BulkAccessControlException;
import org.dspace.app.bulkaccesscontrol.model.AccessCondition;
import org.dspace.app.bulkaccesscontrol.model.AccessConditionBitstream;
import org.dspace.app.bulkaccesscontrol.model.AccessConditionItem;
import org.dspace.app.bulkaccesscontrol.model.BulkAccessConditionConfiguration;
import org.dspace.app.bulkaccesscontrol.model.BulkAccessControlInput;
import org.dspace.app.bulkaccesscontrol.service.BulkAccessConditionConfigurationService;
import org.dspace.app.mediafilter.factory.MediaFilterServiceFactory;
import org.dspace.app.mediafilter.service.MediaFilterService;
import org.dspace.app.util.DSpaceObjectUtilsImpl;
import org.dspace.app.util.service.DSpaceObjectUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.submit.model.AccessConditionOption;
import org.dspace.utils.DSpace;

public class BulkAccessControl
extends DSpaceRunnable<BulkAccessControlScriptConfiguration<BulkAccessControl>> {
    private DSpaceObjectUtils dSpaceObjectUtils;
    private SearchService searchService;
    private ItemService itemService;
    private String filename;
    private List<String> uuids;
    private Context context;
    private BulkAccessConditionConfigurationService bulkAccessConditionConfigurationService;
    private ResourcePolicyService resourcePolicyService;
    protected EPersonService epersonService;
    private ConfigurationService configurationService;
    private MediaFilterService mediaFilterService;
    private Map<String, AccessConditionOption> itemAccessConditions;
    private Map<String, AccessConditionOption> uploadAccessConditions;
    private final String ADD_MODE = "add";
    private final String REPLACE_MODE = "replace";
    private boolean help = false;
    protected String eperson = null;

    @Override
    public void setup() throws ParseException {
        this.searchService = SearchUtils.getSearchService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
        this.epersonService = EPersonServiceFactory.getInstance().getEPersonService();
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.mediaFilterService = MediaFilterServiceFactory.getInstance().getMediaFilterService();
        this.mediaFilterService.setLogHandler(this.handler);
        this.bulkAccessConditionConfigurationService = (BulkAccessConditionConfigurationService)new DSpace().getServiceManager().getServiceByName("bulkAccessConditionConfigurationService", BulkAccessConditionConfigurationService.class);
        this.dSpaceObjectUtils = (DSpaceObjectUtils)new DSpace().getServiceManager().getServiceByName(DSpaceObjectUtilsImpl.class.getName(), DSpaceObjectUtilsImpl.class);
        BulkAccessConditionConfiguration bulkAccessConditionConfiguration = this.bulkAccessConditionConfigurationService.getBulkAccessConditionConfiguration("default");
        this.itemAccessConditions = bulkAccessConditionConfiguration.getItemAccessConditionOptions().stream().collect(Collectors.toMap(AccessConditionOption::getName, Function.identity()));
        this.uploadAccessConditions = bulkAccessConditionConfiguration.getBitstreamAccessConditionOptions().stream().collect(Collectors.toMap(AccessConditionOption::getName, Function.identity()));
        this.help = this.commandLine.hasOption('h');
        this.filename = this.commandLine.getOptionValue('f');
        this.uuids = this.commandLine.hasOption('u') ? Arrays.asList(this.commandLine.getOptionValues('u')) : null;
    }

    @Override
    public void internalRun() throws Exception {
        BulkAccessControlInput accessControl;
        if (this.help) {
            this.printHelp();
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.context = new Context(Context.Mode.BATCH_EDIT);
        this.setEPerson(this.context);
        if (!this.isAuthorized(this.context)) {
            this.handler.logError("Current user is not eligible to execute script bulk-access-control");
            throw new AuthorizeException("Current user is not eligible to execute script bulk-access-control");
        }
        if (this.uuids == null || this.uuids.size() == 0) {
            this.handler.logError("A target uuid must be provided with at least on uuid (run with -h flag for details)");
            throw new IllegalArgumentException("At least one target uuid must be provided");
        }
        InputStream inputStream = this.handler.getFileStream(this.context, this.filename).orElseThrow(() -> new IllegalArgumentException("Error reading file, the file couldn't be found for filename: " + this.filename));
        try {
            accessControl = (BulkAccessControlInput)mapper.readValue(inputStream, BulkAccessControlInput.class);
        }
        catch (IOException e) {
            this.handler.logError("Error parsing json file " + e.getMessage());
            throw new IllegalArgumentException("Error parsing json file", e);
        }
        try {
            this.validate(accessControl);
            this.updateItemsAndBitstreamsPolices(accessControl);
            this.context.complete();
        }
        catch (Exception e) {
            this.handler.handleException(e);
            this.context.abort();
        }
    }

    private void validate(BulkAccessControlInput accessControl) throws SQLException {
        AccessConditionItem item = accessControl.getItem();
        AccessConditionBitstream bitstream = accessControl.getBitstream();
        if (Objects.isNull(item) && Objects.isNull(bitstream)) {
            this.handler.logError("item or bitstream node must be provided");
            throw new BulkAccessControlException("item or bitstream node must be provided");
        }
        if (Objects.nonNull(item)) {
            this.validateItemNode(item);
        }
        if (Objects.nonNull(bitstream)) {
            this.validateBitstreamNode(bitstream);
        }
    }

    private void validateItemNode(AccessConditionItem item) {
        String mode = item.getMode();
        List<AccessCondition> accessConditions = item.getAccessConditions();
        if (StringUtils.isEmpty((CharSequence)mode)) {
            this.handler.logError("item mode node must be provided");
            throw new BulkAccessControlException("item mode node must be provided");
        }
        if (!StringUtils.equalsAny((CharSequence)mode, (CharSequence[])new CharSequence[]{"add", "replace"})) {
            this.handler.logError("wrong value for item mode<" + mode + ">");
            throw new BulkAccessControlException("wrong value for item mode<" + mode + ">");
        }
        if ("add".equals(mode) && CollectionUtils.isEmpty(accessConditions)) {
            this.handler.logError("accessConditions of item must be provided with mode<add>");
            throw new BulkAccessControlException("accessConditions of item must be provided with mode<add>");
        }
        for (AccessCondition accessCondition : accessConditions) {
            this.validateAccessCondition(accessCondition);
        }
    }

    private void validateBitstreamNode(AccessConditionBitstream bitstream) throws SQLException {
        String mode = bitstream.getMode();
        List<AccessCondition> accessConditions = bitstream.getAccessConditions();
        if (StringUtils.isEmpty((CharSequence)mode)) {
            this.handler.logError("bitstream mode node must be provided");
            throw new BulkAccessControlException("bitstream mode node must be provided");
        }
        if (!StringUtils.equalsAny((CharSequence)mode, (CharSequence[])new CharSequence[]{"add", "replace"})) {
            this.handler.logError("wrong value for bitstream mode<" + mode + ">");
            throw new BulkAccessControlException("wrong value for bitstream mode<" + mode + ">");
        }
        if ("add".equals(mode) && CollectionUtils.isEmpty(accessConditions)) {
            this.handler.logError("accessConditions of bitstream must be provided with mode<add>");
            throw new BulkAccessControlException("accessConditions of bitstream must be provided with mode<add>");
        }
        this.validateConstraint(bitstream);
        for (AccessCondition accessCondition : bitstream.getAccessConditions()) {
            this.validateAccessCondition(accessCondition);
        }
    }

    private void validateConstraint(AccessConditionBitstream bitstream) throws SQLException {
        DSpaceObject dso;
        if (this.uuids.size() > 1 && this.containsConstraints(bitstream)) {
            this.handler.logError("constraint isn't supported when multiple uuids are provided");
            throw new BulkAccessControlException("constraint isn't supported when multiple uuids are provided");
        }
        if (this.uuids.size() == 1 && this.containsConstraints(bitstream) && Objects.nonNull(dso = this.dSpaceObjectUtils.findDSpaceObject(this.context, UUID.fromString(this.uuids.get(0)))) && dso.getType() != 2) {
            this.handler.logError("constraint is not supported when uuid isn't an Item");
            throw new BulkAccessControlException("constraint is not supported when uuid isn't an Item");
        }
    }

    private void validateAccessCondition(AccessCondition accessCondition) {
        if (!this.itemAccessConditions.containsKey(accessCondition.getName())) {
            this.handler.logError("wrong access condition <" + accessCondition.getName() + ">");
            throw new BulkAccessControlException("wrong access condition <" + accessCondition.getName() + ">");
        }
        try {
            this.itemAccessConditions.get(accessCondition.getName()).validateResourcePolicy(this.context, accessCondition.getName(), accessCondition.getStartDate(), accessCondition.getEndDate());
        }
        catch (Exception e) {
            this.handler.logError("invalid access condition, " + e.getMessage());
            this.handler.handleException(e);
        }
    }

    private void updateItemsAndBitstreamsPolices(BulkAccessControlInput accessControl) throws SQLException, SearchServiceException, AuthorizeException {
        int counter = 0;
        int start = 0;
        int limit = 20;
        String query = this.buildSolrQuery(this.uuids);
        Iterator<Item> itemIterator = this.findItems(query, start, limit);
        while (itemIterator.hasNext()) {
            Item item = this.context.reloadEntity(itemIterator.next());
            if (Objects.nonNull(accessControl.getItem())) {
                this.updateItemPolicies(item, accessControl);
            }
            if (Objects.nonNull(accessControl.getBitstream())) {
                this.updateBitstreamsPolicies(item, accessControl);
            }
            this.context.commit();
            this.context.uncacheEntity(item);
            if (++counter != limit) continue;
            counter = 0;
            itemIterator = this.findItems(query, start += limit, limit);
        }
    }

    private String buildSolrQuery(List<String> uuids) throws SQLException {
        Object[] query = new String[uuids.size()];
        for (int i = 0; i < query.length; ++i) {
            DSpaceObject dso = this.dSpaceObjectUtils.findDSpaceObject(this.context, UUID.fromString(uuids.get(i)));
            if (dso.getType() == 4) {
                query[i] = "location.comm:" + dso.getID();
                continue;
            }
            if (dso.getType() == 3) {
                query[i] = "location.coll:" + dso.getID();
                continue;
            }
            if (dso.getType() != 2) continue;
            query[i] = "search.resourceid:" + dso.getID();
        }
        return StringUtils.joinWith((String)" OR ", (Object[])query);
    }

    private Iterator<Item> findItems(String query, int start, int limit) throws SearchServiceException {
        DiscoverQuery discoverQuery = this.buildDiscoveryQuery(query, start, limit);
        return this.searchService.search(this.context, discoverQuery).getIndexableObjects().stream().map(indexableObject -> (Item)((IndexableItem)indexableObject).getIndexedObject()).collect(Collectors.toList()).iterator();
    }

    private DiscoverQuery buildDiscoveryQuery(String query, int start, int limit) {
        DiscoverQuery discoverQuery = new DiscoverQuery();
        discoverQuery.setDSpaceObjectFilter(IndexableItem.TYPE);
        discoverQuery.setQuery(query);
        discoverQuery.setStart(start);
        discoverQuery.setMaxResults(limit);
        discoverQuery.setSortField("search.resourceid", DiscoverQuery.SORT_ORDER.asc);
        return discoverQuery;
    }

    private void updateItemPolicies(Item item, BulkAccessControlInput accessControl) throws SQLException, AuthorizeException {
        AccessConditionItem acItem = accessControl.getItem();
        if ("replace".equals(acItem.getMode())) {
            this.removeReadPolicies(item, ResourcePolicy.TYPE_CUSTOM);
            this.removeReadPolicies(item, ResourcePolicy.TYPE_INHERITED);
        }
        this.setItemPolicies(item, accessControl);
        this.logInfo(acItem.getAccessConditions(), acItem.getMode(), item);
    }

    private void setItemPolicies(Item item, BulkAccessControlInput accessControl) throws SQLException, AuthorizeException {
        accessControl.getItem().getAccessConditions().forEach(accessCondition -> this.createResourcePolicy(item, (AccessCondition)accessCondition, this.itemAccessConditions.get(accessCondition.getName())));
        this.itemService.adjustItemPolicies(this.context, item, item.getOwningCollection(), false);
    }

    private void updateBitstreamsPolicies(Item item, BulkAccessControlInput accessControl) {
        AccessConditionBitstream.Constraint constraints = accessControl.getBitstream().getConstraints();
        long count = item.getBundles().stream().flatMap(bundle -> bundle.getBitstreams().stream()).count();
        item.getBundles("ORIGINAL").stream().flatMap(bundle -> bundle.getBitstreams().stream()).filter(bitstream -> constraints == null || constraints.getUuid() == null || constraints.getUuid().size() == 0 || constraints.getUuid().contains(bitstream.getID().toString())).forEach(bitstream -> this.updateBitstreamPolicies((Bitstream)bitstream, item, accessControl));
    }

    private boolean containsConstraints(AccessConditionBitstream bitstream) {
        return Objects.nonNull(bitstream) && Objects.nonNull(bitstream.getConstraints()) && CollectionUtils.isNotEmpty(bitstream.getConstraints().getUuid());
    }

    private void updateBitstreamPolicies(Bitstream bitstream, Item item, BulkAccessControlInput accessControl) {
        AccessConditionBitstream acBitstream = accessControl.getBitstream();
        if ("replace".equals(acBitstream.getMode())) {
            this.removeReadPolicies(bitstream, ResourcePolicy.TYPE_CUSTOM);
            this.removeReadPolicies(bitstream, ResourcePolicy.TYPE_INHERITED);
        }
        try {
            this.setBitstreamPolicies(bitstream, item, accessControl);
            this.logInfo(acBitstream.getAccessConditions(), acBitstream.getMode(), bitstream);
        }
        catch (SQLException | AuthorizeException e) {
            throw new RuntimeException(e);
        }
    }

    private void removeReadPolicies(DSpaceObject dso, String type) {
        try {
            this.resourcePolicyService.removePolicies(this.context, dso, type, 0);
        }
        catch (SQLException | AuthorizeException e) {
            throw new BulkAccessControlException(e);
        }
    }

    private void setBitstreamPolicies(Bitstream bitstream, Item item, BulkAccessControlInput accessControl) throws SQLException, AuthorizeException {
        accessControl.getBitstream().getAccessConditions().forEach(accessCondition -> this.createResourcePolicy(bitstream, (AccessCondition)accessCondition, this.uploadAccessConditions.get(accessCondition.getName())));
        this.itemService.adjustBitstreamPolicies(this.context, item, item.getOwningCollection(), bitstream);
        this.mediaFilterService.updatePoliciesOfDerivativeBitstreams(this.context, item, bitstream);
    }

    private void createResourcePolicy(DSpaceObject obj, AccessCondition accessCondition, AccessConditionOption accessConditionOption) {
        String name = accessCondition.getName();
        String description = accessCondition.getDescription();
        Date startDate = accessCondition.getStartDate();
        Date endDate = accessCondition.getEndDate();
        try {
            accessConditionOption.createResourcePolicy(this.context, obj, name, description, startDate, endDate);
        }
        catch (Exception e) {
            throw new BulkAccessControlException(e);
        }
    }

    protected void setEPerson(Context context) throws SQLException {
        EPerson myEPerson = (EPerson)this.epersonService.find(context, this.getEpersonIdentifier());
        if (myEPerson == null) {
            this.handler.logError("EPerson cannot be found: " + this.getEpersonIdentifier());
            throw new UnsupportedOperationException("EPerson cannot be found: " + this.getEpersonIdentifier());
        }
        context.setCurrentUser(myEPerson);
    }

    private void logInfo(List<AccessCondition> accessConditions, String mode, DSpaceObject dso) {
        String type = dso.getClass().getSimpleName();
        if ("replace".equals(mode) && CollectionUtils.isEmpty(accessConditions)) {
            this.handler.logInfo("Cleaning " + type + " {" + dso.getID() + "} policies");
            this.handler.logInfo("Inheriting policies from owning Collection in " + type + " {" + dso.getID() + "}");
            return;
        }
        StringBuilder message = new StringBuilder();
        message.append(mode.equals("add") ? "Adding " : "Replacing ").append(type).append(" {").append(dso.getID()).append("} policy").append(mode.equals("add") ? " with " : " to ").append("access conditions:");
        this.AppendAccessConditionsInfo(message, accessConditions);
        this.handler.logInfo(message.toString());
        if ("replace".equals(mode) && this.isAppendModeEnabled()) {
            this.handler.logInfo("Inheriting policies from owning Collection in " + type + " {" + dso.getID() + "}");
        }
    }

    private void AppendAccessConditionsInfo(StringBuilder message, List<AccessCondition> accessConditions) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        message.append("{");
        for (int i = 0; i < accessConditions.size(); ++i) {
            message.append(accessConditions.get(i).getName());
            Optional.ofNullable(accessConditions.get(i).getStartDate()).ifPresent(date -> message.append(", start_date=" + dateFormat.format((Date)date)));
            Optional.ofNullable(accessConditions.get(i).getEndDate()).ifPresent(date -> message.append(", end_date=" + dateFormat.format((Date)date)));
            if (i == accessConditions.size() - 1) continue;
            message.append(", ");
        }
        message.append("}");
    }

    private boolean isAppendModeEnabled() {
        return this.configurationService.getBooleanProperty("core.authorization.installitem.inheritance-read.append-mode");
    }

    protected boolean isAuthorized(Context context) {
        return true;
    }

    @Override
    public BulkAccessControlScriptConfiguration<BulkAccessControl> getScriptConfiguration() {
        return (BulkAccessControlScriptConfiguration)new DSpace().getServiceManager().getServiceByName("bulk-access-control", BulkAccessControlScriptConfiguration.class);
    }
}

