/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report.components;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.MessageType;
import org.drools.verifier.report.components.Severity;

public abstract class VerifierMessageBase
implements Serializable,
Comparable<VerifierMessageBase> {
    private static final long serialVersionUID = 510L;
    private static int index = 0;
    private Map<String, String> impactedRules = new HashMap<String, String>();
    protected final Severity severity;
    protected final MessageType messageType;
    protected final int id = index++;
    protected final Cause faulty;
    protected final String message;

    @Override
    public int compareTo(VerifierMessageBase o) {
        if (this.id == o.getId()) {
            return 0;
        }
        return this.id > o.getId() ? 1 : -1;
    }

    protected VerifierMessageBase(Map<String, String> impactedRules, Severity severity, MessageType messageType, Cause faulty, String message) {
        this.impactedRules = impactedRules;
        this.severity = severity;
        this.messageType = messageType;
        this.faulty = faulty;
        this.message = message;
    }

    public int getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public Cause getFaulty() {
        return this.faulty;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(this.severity.singular);
        str.append(" id = ");
        str.append(this.id);
        str.append(":\n");
        if (this.faulty != null) {
            str.append("faulty : ");
            str.append(this.faulty);
            str.append(", ");
        }
        str.append(this.message);
        str.append("\t]");
        return str.toString();
    }

    public void setImpactedRules(Map<String, String> impactedRules) {
        this.impactedRules = impactedRules;
    }

    public Map<String, String> getImpactedRules() {
        return this.impactedRules;
    }

    public abstract Collection<Cause> getCauses();
}

