/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.parser.impl;

import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.util.StringUtils;
import org.drools.impact.analysis.model.Rule;
import org.drools.impact.analysis.model.right.ConsequenceAction;
import org.drools.impact.analysis.model.right.ModifiedProperty;
import org.drools.impact.analysis.model.right.ModifyAction;
import org.drools.impact.analysis.parser.impl.ParserUtil;
import org.drools.modelcompiler.builder.generator.Consequence;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.RuleContext;

public class RhsParser {
    private final PackageRegistry pkgRegistry;

    public RhsParser(PackageRegistry pkgRegistry) {
        this.pkgRegistry = pkgRegistry;
    }

    public void parse(RuleDescr ruleDescr, RuleContext context, Rule rule) {
        BlockStmt ruleVariablesBlock = new BlockStmt();
        MethodCallExpr consequenceExpr = new Consequence(context).createCall(ruleDescr, ruleDescr.getConsequence().toString(), ruleVariablesBlock, false);
        consequenceExpr.findAll(MethodCallExpr.class).stream().filter(m -> m.getScope().map(s -> s.toString().equals("drools")).orElse(false)).map(m -> this.processStatement(context, consequenceExpr, (MethodCallExpr)m, ruleVariablesBlock)).filter(Objects::nonNull).forEach(a -> rule.getRhs().addAction(a));
    }

    private ConsequenceAction processStatement(RuleContext context, MethodCallExpr consequenceExpr, MethodCallExpr statement, BlockStmt ruleVariablesBlock) {
        ConsequenceAction.Type type = this.decodeAction(statement.getNameAsString());
        if (type == null) {
            return null;
        }
        if (type == ConsequenceAction.Type.MODIFY) {
            return this.processModify(context, consequenceExpr, statement, ruleVariablesBlock);
        }
        return this.processAction(context, consequenceExpr, statement, type);
    }

    private ConsequenceAction processAction(RuleContext context, MethodCallExpr consequenceExpr, MethodCallExpr statement, ConsequenceAction.Type type) {
        Expression actionArg = statement.getArgument(0);
        Class actionClass = null;
        if (actionArg.isNameExpr()) {
            actionClass = context.getDeclarationById(actionArg.toString()).map(DeclarationSpec::getDeclarationClass).orElseGet(() -> this.getClassFromAssignment(consequenceExpr, actionArg));
        } else if (actionArg.isLiteralExpr()) {
            actionClass = ParserUtil.literalType(actionArg.asLiteralExpr());
        } else if (actionArg.isObjectCreationExpr()) {
            try {
                actionClass = this.pkgRegistry.getTypeResolver().resolveType(actionArg.asObjectCreationExpr().getType().asString());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return new ConsequenceAction(type, actionClass);
    }

    private Class<?> getClassFromAssignment(MethodCallExpr consequenceExpr, Expression actionArg) {
        String className = this.getClassNameFromAssignment(consequenceExpr, actionArg).orElseGet(() -> this.getClassNameFromCreation(consequenceExpr, actionArg));
        try {
            return this.pkgRegistry.getTypeResolver().resolveType(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<String> getClassNameFromAssignment(MethodCallExpr consequenceExpr, Expression actionArg) {
        return consequenceExpr.findAll(AssignExpr.class).stream().filter(assign -> assign.getTarget().isVariableDeclarationExpr() && ((VariableDeclarationExpr)assign.getTarget()).getVariable(0).toString().equals(actionArg.toString())).findFirst().map(assignExpr -> assignExpr.getTarget().asVariableDeclarationExpr().getVariable(0).getType().asString());
    }

    private String getClassNameFromCreation(MethodCallExpr consequenceExpr, Expression actionArg) {
        return consequenceExpr.findAll(VariableDeclarator.class).stream().filter(varDecl -> {
            if (!varDecl.getName().toString().equals(actionArg.toString())) return false;
            if (!varDecl.getInitializer().filter(ObjectCreationExpr.class::isInstance).isPresent()) return false;
            return true;
        }).map(varDecl -> (ObjectCreationExpr)varDecl.getInitializer().get()).map(objCreat -> objCreat.getType().getNameAsString()).findFirst().orElseThrow(() -> new RuntimeException("Unknown variable: " + actionArg));
    }

    private ModifyAction processModify(RuleContext context, MethodCallExpr consequenceExpr, MethodCallExpr statement, BlockStmt ruleVariablesBlock) {
        String modifiedId = statement.getArgument(0).toString();
        Class modifiedClass = ((DeclarationSpec)context.getDeclarationById(modifiedId).orElseThrow(() -> new RuntimeException("Unknown declaration: " + modifiedId))).getDeclarationClass();
        ModifyAction action = new ModifyAction(modifiedClass);
        if (statement.getArguments().size() > 1) {
            String maskId = statement.getArgument(1).toString();
            AssignExpr maskAssignExpr = ruleVariablesBlock.findAll(AssignExpr.class).stream().filter(assign -> ((VariableDeclarationExpr)assign.getTarget()).getVariable(0).toString().equals(maskId)).findFirst().orElseThrow(() -> new RuntimeException("Unknown mask: " + maskId));
            MethodCallExpr maskMethod = (MethodCallExpr)maskAssignExpr.getValue();
            List modifyingExprs = consequenceExpr.findAll(MethodCallExpr.class).stream().filter(m -> m.getScope().map(s -> s.toString().equals(modifiedId) || s.toString().equals("(" + modifiedId + ")")).orElse(false)).collect(Collectors.toList());
            for (int i = 1; i < maskMethod.getArguments().size(); ++i) {
                String property = maskMethod.getArgument(i).asStringLiteralExpr().asString();
                String setter = "set" + StringUtils.ucFirst((String)property);
                MethodCallExpr setterExpr = modifyingExprs.stream().filter(m -> m.getNameAsString().equals(setter)).filter(m -> m.getArguments().size() == 1).findFirst().orElse(null);
                Object value = null;
                if (setterExpr != null && setterExpr.getArgument(0).isLiteralExpr()) {
                    value = ParserUtil.literalToValue(setterExpr.getArgument(0).asLiteralExpr());
                }
                action.addModifiedProperty(new ModifiedProperty(property, value));
            }
        }
        return action;
    }

    private ConsequenceAction.Type decodeAction(String name) {
        switch (name) {
            case "insert": {
                return ConsequenceAction.Type.INSERT;
            }
            case "delete": {
                return ConsequenceAction.Type.DELETE;
            }
            case "update": {
                return ConsequenceAction.Type.MODIFY;
            }
        }
        return null;
    }
}

