/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.spring.listener;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.util.ObjectUtils;

public abstract class OnceApplicationContextEventListener
implements ApplicationContextAware,
ApplicationListener<ApplicationEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OnceApplicationContextEventListener.class);
    private ApplicationContext applicationContext;

    protected OnceApplicationContextEventListener() {
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.isOriginalEventSource(event) && event instanceof ApplicationContextEvent) {
            if (event instanceof ContextRefreshedEvent) {
                this.onContextRefreshedEvent((ContextRefreshedEvent)event);
            } else if (event instanceof ContextStartedEvent) {
                this.onContextStartedEvent((ContextStartedEvent)event);
            } else if (event instanceof ContextStoppedEvent) {
                this.onContextStoppedEvent((ContextStoppedEvent)event);
            } else if (event instanceof ContextClosedEvent) {
                this.onContextClosedEvent((ContextClosedEvent)event);
            }
        }
    }

    protected void onContextRefreshedEvent(ContextRefreshedEvent event) {
    }

    protected void onContextStartedEvent(ContextStartedEvent event) {
    }

    protected void onContextStoppedEvent(ContextStoppedEvent event) {
    }

    protected void onContextClosedEvent(ContextClosedEvent event) {
    }

    private boolean isOriginalEventSource(ApplicationEvent event) {
        return ObjectUtils.nullSafeEquals((Object)this.applicationContext, (Object)event.getSource());
    }

    public final void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

