/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.logging;

import java.util.Objects;
import org.dromara.dynamictp.logging.AbstractDtpLogging;
import org.dromara.dynamictp.logging.log4j2.DtpLog4j2Logging;
import org.dromara.dynamictp.logging.logback.DtpLogbackLogging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtpLoggingInitializer {
    private static final Logger log = LoggerFactory.getLogger(DtpLoggingInitializer.class);
    private static AbstractDtpLogging dtpLogging;

    public static DtpLoggingInitializer getInstance() {
        return LoggingInstance.INSTANCE;
    }

    public void loadConfiguration() {
        if (Objects.isNull(dtpLogging)) {
            return;
        }
        dtpLogging.loadConfiguration();
        dtpLogging.initMonitorLogger();
    }

    static {
        try {
            Class.forName("ch.qos.logback.classic.Logger");
            dtpLogging = new DtpLogbackLogging();
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("org.apache.logging.log4j.LogManager");
                dtpLogging = new DtpLog4j2Logging();
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error("DynamicTp initialize logging failed, please check whether logback or log4j related dependencies exist.");
            }
        }
    }

    private static class LoggingInstance {
        private static final DtpLoggingInitializer INSTANCE = new DtpLoggingInitializer();

        private LoggingInstance() {
        }
    }
}

