/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.format;

import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.event.impl.CharEvent;
import com.topologi.diffx.event.impl.SpaceEvent;
import com.topologi.diffx.event.impl.WordEvent;
import com.topologi.diffx.format.XMLDiffXFormatter;
import com.topologi.diffx.sequence.PrefixMapping;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;

public final class StrictXMLFormatter
implements XMLDiffXFormatter {
    private final PrintWriter xml;
    private String openDel = "<del>";
    private String closeDel = "</del>";
    private String openIns = "<ins>";
    private String closeIns = "</ins>";
    private DiffXConfig config = new DiffXConfig();
    private transient boolean declareNamespace = true;
    private transient boolean isInserting = false;
    private transient boolean isDeleting = false;
    private transient boolean isElementNude = false;

    public StrictXMLFormatter() {
        this.xml = new PrintWriter(System.out);
        this.init();
    }

    public StrictXMLFormatter(Writer w) {
        this.xml = new PrintWriter(w);
        this.init();
    }

    private void init() {
        this.xml.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void format(DiffXEvent e) throws IOException {
        if (e instanceof OpenElementEvent) {
            if (this.isElementNude) {
                this.denudeElement();
            }
            if (this.isInserting) {
                this.closeIns();
            }
            if (this.isDeleting) {
                this.closeDel();
            }
            OpenElementEvent oee = (OpenElementEvent)e;
            this.xml.print("<" + oee.getName());
            if (this.declareNamespace) {
                this.xml.print(" xmlns:dfx=\"http://www.topologi.com/2005/Diff-X\"");
                this.declareNamespace = false;
            }
            this.isElementNude = true;
        } else if (e instanceof CloseElementEvent) {
            if (this.isElementNude) {
                this.denudeElement();
            }
            if (this.isInserting) {
                this.closeIns();
            }
            if (this.isDeleting) {
                this.closeDel();
            }
            this.xml.print(e.toXML());
        } else if (e instanceof AttributeEvent) {
            if (!this.isElementNude) throw new IllegalStateException("Cannot write an attribute once the element is closed");
            this.xml.print(e.toXML());
        } else {
            if (this.isElementNude) {
                this.denudeElement();
            }
            if (this.isInserting) {
                this.closeIns();
            }
            if (this.isDeleting) {
                this.closeDel();
            }
            if (e instanceof WordEvent || e instanceof SpaceEvent) {
                this.xml.print(e.toXML());
            } else if (e instanceof CharEvent) {
                this.xml.print(((CharEvent)e).c);
            }
        }
        this.xml.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void insert(DiffXEvent e) throws IOException {
        if (e instanceof OpenElementEvent) {
            if (this.isElementNude) {
                this.denudeElement();
            }
            if (this.isDeleting) {
                this.closeDel();
            }
            OpenElementEvent oee = (OpenElementEvent)e;
            this.xml.print("<" + oee.getName());
            if (this.declareNamespace) {
                this.xml.print(" xmlns:dfx=\"http://www.allette.com.au/diffex\"");
            }
            this.xml.print(" dfx:insert=\"true\"");
            this.isElementNude = true;
        } else if (e instanceof CloseElementEvent) {
            if (this.isElementNude) {
                this.denudeElement();
            }
            if (this.isDeleting) {
                this.closeDel();
            }
            this.xml.print("</");
            this.xml.print(((CloseElementEvent)e).getName());
            this.xml.print('>');
        } else if (e instanceof AttributeEvent) {
            if (!this.isElementNude) throw new IllegalStateException("Cannot insert an attribute once the element is closed");
            this.xml.print(" ");
            this.xml.print(((AttributeEvent)e).getName());
            this.xml.print("=\"");
            this.xml.print(((AttributeEvent)e).getValue());
            this.xml.print('\"');
        } else {
            if (this.isElementNude) {
                this.denudeElement();
            }
            if (this.isDeleting) {
                this.closeDel();
            }
            if (e instanceof WordEvent) {
                if (!this.isInserting) {
                    this.openIns();
                }
                this.xml.print(e.toXML());
            } else if (e instanceof SpaceEvent) {
                this.xml.print(e.toXML());
            } else if (e instanceof CharEvent) {
                this.xml.print(((CharEvent)e).c);
            }
        }
        this.xml.flush();
    }

    @Override
    public void delete(DiffXEvent e) throws IOException, IllegalStateException {
        if (this.isElementNude) {
            this.denudeElement();
        }
        if (this.isInserting) {
            this.closeIns();
        }
        if (e instanceof OpenElementEvent) {
            OpenElementEvent oee = (OpenElementEvent)e;
            this.xml.print("<" + oee.getName());
            if (this.declareNamespace) {
                this.xml.print(" xmlns:dfx=\"http://www.allette.com.au/diffex\"");
            }
            this.xml.print(" dfx:delete=\"true\"");
            this.xml.print('>');
        } else if (e instanceof CloseElementEvent) {
            this.xml.print("</");
            this.xml.print(((CloseElementEvent)e).getName());
            this.xml.print('>');
        } else if (e instanceof WordEvent) {
            if (!this.isDeleting) {
                this.openDel();
            }
            this.xml.print(e.toXML());
        } else if (e instanceof SpaceEvent) {
            this.xml.print(e.toXML());
        } else if (e instanceof CharEvent) {
            this.xml.print(((CharEvent)e).c);
        }
        this.xml.flush();
    }

    public void setInsertTags(String start, String end) throws NullPointerException {
        if (start == null) {
            throw new NullPointerException("The start element for inserted text must have a value");
        }
        if (end == null) {
            throw new NullPointerException("The start element for inserted text must have a value");
        }
        this.openIns = start;
        this.closeIns = end;
    }

    public void setDeleteTags(String start, String end) throws NullPointerException {
        if (start == null) {
            throw new NullPointerException("The start element for deleted text must have a value");
        }
        if (end == null) {
            throw new NullPointerException("The start element for deleted text must have a value");
        }
        this.openDel = start;
        this.closeDel = end;
    }

    @Override
    public void setConfig(DiffXConfig config) {
        this.config = config;
    }

    @Override
    public void setWriteXMLDeclaration(boolean show) {
    }

    @Override
    public void declarePrefixMapping(PrefixMapping mapping) {
        Enumeration<String> uris = mapping.getURIs();
        while (uris.hasMoreElements()) {
            String uri = uris.nextElement();
            mapping.getPrefix(uri);
        }
    }

    private void openIns() {
        this.xml.print(this.openIns);
        this.isInserting = true;
    }

    private void openDel() {
        this.xml.print(this.openDel);
        this.isDeleting = true;
    }

    private void closeIns() {
        this.xml.print(this.closeIns);
        this.isInserting = false;
    }

    private void closeDel() {
        this.xml.print(this.closeDel);
        this.isDeleting = false;
    }

    private void denudeElement() {
        this.xml.print(">");
        this.isElementNude = false;
    }
}

