/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.algorithm;

import com.topologi.diffx.algorithm.DiffXAlgorithm;
import com.topologi.diffx.algorithm.ElementState;
import com.topologi.diffx.algorithm.Matrix;
import com.topologi.diffx.algorithm.MatrixInt;
import com.topologi.diffx.algorithm.MatrixShort;
import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.format.DiffXFormatter;
import com.topologi.diffx.format.ShortStringFormatter;
import com.topologi.diffx.sequence.EventSequence;
import java.io.IOException;

public final class GuanoAlgorithm
implements DiffXAlgorithm {
    private static final boolean DEBUG = false;
    private final EventSequence sequence1;
    private final EventSequence sequence2;
    private final int length1;
    private final int length2;
    private transient Matrix matrix;
    private transient ElementState estate = new ElementState();
    private transient int length = -1;

    public GuanoAlgorithm(EventSequence seq0, EventSequence seq1) {
        this.sequence1 = seq0;
        this.sequence2 = seq1;
        this.length1 = seq0.size();
        this.length2 = seq1.size();
        this.matrix = GuanoAlgorithm.setupMatrix(seq0, seq1);
    }

    @Override
    public int length() {
        if (this.length1 == 0 || this.length2 == 0) {
            this.length = 0;
        }
        if (this.length < 0) {
            this.matrix.setup(this.length1 + 1, this.length2 + 1);
            for (int i = this.length1; i >= 0; --i) {
                for (int j = this.length2; j >= 0; --j) {
                    if (i >= this.length1 || j >= this.length2) {
                        this.matrix.set(i, j, 0);
                        continue;
                    }
                    if (this.sequence1.getEvent(i).equals(this.sequence2.getEvent(j))) {
                        this.matrix.incrementPathBy(i, j, 1);
                        continue;
                    }
                    this.matrix.incrementByMaxPath(i, j);
                }
            }
            this.length = this.matrix.get(0, 0);
        }
        return this.length;
    }

    @Override
    public void process(DiffXFormatter formatter) throws IOException {
        this.processEmpty(formatter);
        if (this.length1 == 0 || this.length2 == 0) {
            return;
        }
        this.length();
        int i = 0;
        int j = 0;
        DiffXEvent e1 = this.sequence1.getEvent(i);
        DiffXEvent e2 = this.sequence2.getEvent(j);
        while (i < this.length1 && j < this.length2) {
            e1 = this.sequence1.getEvent(i);
            e2 = this.sequence2.getEvent(j);
            if (this.matrix.isGreaterX(i, j)) {
                if (this.estate.okInsert(e1) && !this.estate.hasPriorityOver(e2, e1)) {
                    formatter.insert(e1);
                    this.estate.insert(e1);
                    ++i;
                    continue;
                }
                if (e1.equals(e2) && this.estate.okFormat(e1)) {
                    formatter.format(e1);
                    this.estate.format(e1);
                    ++i;
                    ++j;
                    continue;
                }
                if (!this.estate.okDelete(e2)) break;
                formatter.delete(e2);
                this.estate.delete(e2);
                ++j;
                continue;
            }
            if (this.matrix.isGreaterY(i, j)) {
                if (this.estate.okDelete(e2) && !this.estate.hasPriorityOver(e1, e2)) {
                    formatter.delete(e2);
                    this.estate.delete(e2);
                    ++j;
                    continue;
                }
                if (e1.equals(e2) && this.estate.okFormat(e1)) {
                    formatter.format(e1);
                    this.estate.format(e1);
                    ++i;
                    ++j;
                    continue;
                }
                if (!this.estate.okInsert(e1)) break;
                formatter.insert(e1);
                this.estate.insert(e1);
                ++i;
                continue;
            }
            if (!this.matrix.isSameXY(i, j)) break;
            if (e1.equals(e2) && this.estate.okFormat(e1)) {
                formatter.format(e1);
                this.estate.format(e1);
                ++i;
                ++j;
                continue;
            }
            if (this.estate.okInsert(e1) && (!(e2 instanceof AttributeEvent) || e1 instanceof AttributeEvent)) {
                this.estate.insert(e1);
                formatter.insert(e1);
                ++i;
                continue;
            }
            if (!this.estate.okDelete(e2) || e1 instanceof AttributeEvent && !(e2 instanceof AttributeEvent)) break;
            formatter.delete(e2);
            this.estate.delete(e2);
            ++j;
        }
        while (i < this.length1) {
            this.estate.insert(this.sequence1.getEvent(i));
            formatter.insert(this.sequence1.getEvent(i));
            ++i;
        }
        while (j < this.length2) {
            this.estate.delete(this.sequence2.getEvent(j));
            formatter.delete(this.sequence2.getEvent(j));
            ++j;
        }
    }

    @Override
    public final EventSequence getFirstSequence() {
        return this.sequence1;
    }

    @Override
    public final EventSequence getSecondSequence() {
        return this.sequence2;
    }

    private void processEmpty(DiffXFormatter formatter) throws IOException {
        int i;
        if (this.length1 == 0) {
            for (i = 0; i < this.length2; ++i) {
                formatter.delete(this.sequence2.getEvent(i));
            }
        }
        if (this.length2 == 0) {
            for (i = 0; i < this.length1; ++i) {
                formatter.insert(this.sequence1.getEvent(i));
            }
        }
    }

    private static Matrix setupMatrix(EventSequence s1, EventSequence s2) {
        int i;
        int max = 0;
        for (i = 0; i < s1.size(); ++i) {
            max += s1.getEvent(i).getWeight();
        }
        for (i = 0; i < s2.size(); ++i) {
            max += s2.getEvent(i).getWeight();
        }
        if (max > Short.MAX_VALUE) {
            return new MatrixInt();
        }
        return new MatrixShort();
    }

    private void printLost(int i, int j) {
        DiffXEvent e1 = this.sequence1.getEvent(i);
        DiffXEvent e2 = this.sequence2.getEvent(j);
        System.err.println("(!) Ambiguous choice in (" + i + "," + j + ")");
        System.err.println(" ? +" + ShortStringFormatter.toShortString(e1));
        System.err.println(" ? -" + ShortStringFormatter.toShortString(e2));
        System.err.println(" current=" + ShortStringFormatter.toShortString(this.estate.current()));
        System.err.println(" value in X+1=" + this.matrix.get(i + 1, j));
        System.err.println(" value in Y+1=" + this.matrix.get(i, j + 1));
        System.err.println(" equals=" + e1.equals(e2));
        System.err.println(" greaterX=" + this.matrix.isGreaterX(i, j));
        System.err.println(" greaterY=" + this.matrix.isGreaterY(i, j));
        System.err.println(" sameXY=" + this.matrix.isSameXY(i, j));
        System.err.println(" okFormat1=" + this.estate.okFormat(e1));
        System.err.println(" okFormat2=" + this.estate.okFormat(e2));
        System.err.println(" okInsert=" + this.estate.okInsert(e1));
        System.err.println(" okDelete=" + this.estate.okDelete(e2));
    }
}

