/*
 * Decompiled with CFR 0.152.
 */
package org.docstr.gwt;

import java.io.File;
import java.util.Set;
import org.docstr.gwt.GwtPluginExtension;
import org.docstr.gwt.options.GwtTestOptions;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.testing.Test;

public class GwtTestConfig
implements Action<Test> {
    private final Project project;
    private final GwtPluginExtension extension;

    public GwtTestConfig(Project project, GwtPluginExtension extension) {
        this.project = project;
        this.extension = extension;
    }

    public void execute(Test test) {
        test.testLogging(testLogging -> testLogging.setShowStandardStreams(((Boolean)this.extension.getGwtTest().getShowStandardStreams().getOrElse((Object)false)).booleanValue()));
        if (this.extension.getDevMode().getMinHeapSize().isPresent()) {
            test.setMinHeapSize((String)this.extension.getDevMode().getMinHeapSize().get());
        } else {
            test.setMinHeapSize((String)this.extension.getMinHeapSize().getOrElse((Object)"256M"));
        }
        if (this.extension.getDevMode().getMaxHeapSize().isPresent()) {
            test.setMaxHeapSize((String)this.extension.getDevMode().getMaxHeapSize().get());
        } else {
            test.setMaxHeapSize((String)this.extension.getMaxHeapSize().getOrElse((Object)"512M"));
        }
        GwtTestOptions testOptions = this.extension.getGwtTest();
        if (!testOptions.getWar().isPresent()) {
            testOptions.getWar().set((Object)((Directory)this.extension.getWar().getOrNull()));
        }
        if (!testOptions.getDeploy().isPresent()) {
            testOptions.getDeploy().set((Object)((Directory)this.extension.getDeploy().getOrNull()));
        }
        if (!testOptions.getExtra().isPresent()) {
            testOptions.getExtra().set((Object)((Directory)this.extension.getExtra().getOrNull()));
        }
        if (!testOptions.getCacheDir().isPresent()) {
            testOptions.getCacheDir().set((Object)((Directory)this.extension.getCacheDir().getOrNull()));
        }
        SourceSetContainer sourceSets = (SourceSetContainer)this.project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
        Set mainSourcePaths = mainSourceSet.getAllSource().getSrcDirs();
        FileCollection mainOutputClasspath = mainSourceSet.getOutput().getClassesDirs().plus((FileCollection)this.project.files(new Object[]{mainSourceSet.getOutput().getResourcesDir()}));
        SourceSet testSourceSet = (SourceSet)sourceSets.getByName("test");
        Set testSourcePaths = testSourceSet.getAllSource().getSrcDirs();
        FileCollection testOutputClasspath = testSourceSet.getOutput().getClassesDirs().plus((FileCollection)this.project.files(new Object[]{testSourceSet.getOutput().getResourcesDir()}));
        test.setClasspath(test.getClasspath().plus((FileCollection)this.project.files(new Object[]{mainSourcePaths, mainOutputClasspath, mainSourceSet.getRuntimeClasspath(), testSourcePaths, testOutputClasspath, testSourceSet.getRuntimeClasspath()})));
        String gwtArgs = testOptions.getParameterString();
        test.systemProperty("gwt.args", (Object)gwtArgs);
        Logger log = this.project.getLogger();
        log.info("Using gwt.args for test: {}", (Object)gwtArgs);
        DirectoryProperty cacheDirProperty = this.extension.getCacheDir();
        if (cacheDirProperty != null && cacheDirProperty.isPresent()) {
            File cacheDir = (File)cacheDirProperty.getAsFile().get();
            test.systemProperty("gwt.persistentunitcachedir", (Object)cacheDir);
            cacheDir.mkdirs();
            log.info("Using gwt.persistentunitcachedir for test: {0}", (Object)cacheDir);
        }
    }
}

