/*
 * Decompiled with CFR 0.152.
 */
package org.docstr.gwt;

import java.util.List;
import org.docstr.gwt.GwtCompileConfig;
import org.docstr.gwt.GwtCompileTask;
import org.docstr.gwt.GwtDevModeConfig;
import org.docstr.gwt.GwtDevModeTask;
import org.docstr.gwt.GwtPluginExtension;
import org.docstr.gwt.GwtSuperDevConfig;
import org.docstr.gwt.GwtSuperDevTask;
import org.docstr.gwt.GwtTestConfig;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;

public class GwtPlugin
implements Plugin<Project> {
    private static final String GWT_VERSION = "2.12.1";
    private Project project;

    public void apply(Project project) {
        this.project = project;
        if (!project.getPlugins().hasPlugin(JavaPlugin.class)) {
            project.getPlugins().apply(JavaPlugin.class);
        }
        GwtPluginExtension extension = this.createGwtExtension();
        this.configureGwtProject(extension);
        this.configureGwtTasks(extension);
    }

    private GwtPluginExtension createGwtExtension() {
        GwtPluginExtension extension = (GwtPluginExtension)this.project.getExtensions().create("gwt", GwtPluginExtension.class, new Object[0]);
        extension.getWar().convention(this.project.getLayout().getBuildDirectory().dir("gwt/war"));
        extension.getDeploy().convention(this.project.getLayout().getBuildDirectory().dir("gwt/deploy"));
        extension.getGen().convention(this.project.getLayout().getBuildDirectory().dir("gwt/gen"));
        extension.getExtra().convention(this.project.getLayout().getBuildDirectory().dir("gwt/extra"));
        extension.getCacheDir().convention(this.project.getLayout().getBuildDirectory().dir("gwt/gwt-unitCache"));
        extension.getGwtTest().getShowStandardStreams().convention((Object)false);
        return extension;
    }

    private void configureGwtProject(GwtPluginExtension extension) {
        this.project.afterEvaluate(p -> {
            String gwtVersion = (String)extension.getGwtVersion().getOrElse((Object)GWT_VERSION);
            this.project.getDependencies().add("implementation", (Object)("org.gwtproject:gwt-user:" + gwtVersion));
            this.project.getDependencies().add("implementation", (Object)("org.gwtproject:gwt-dev:" + gwtVersion));
            this.project.getDependencies().add("implementation", (Object)("org.gwtproject:gwt-codeserver:" + gwtVersion));
            SourceSetContainer sourceSets = (SourceSetContainer)this.project.getExtensions().getByType(SourceSetContainer.class);
            SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
            mainSourceSet.getResources().srcDir((Object)"src/main/java");
        });
    }

    private void configureGwtTasks(GwtPluginExtension extension) {
        TaskProvider gwtCompileTask = this.project.getTasks().register("gwtCompile", GwtCompileTask.class, (Action)new GwtCompileConfig(extension));
        this.project.getTasks().named("build").configure(buildTask -> buildTask.dependsOn(new Object[]{gwtCompileTask}));
        TaskProvider gwtDevModeTask = this.project.getTasks().register("gwtDevMode", GwtDevModeTask.class, (Action)new GwtDevModeConfig(extension));
        gwtDevModeTask.configure(task -> task.getOutputs().upToDateWhen(t -> false));
        TaskProvider gwtSuperDevTask = this.project.getTasks().register("gwtSuperDev", GwtSuperDevTask.class, (Action)new GwtSuperDevConfig(extension));
        gwtSuperDevTask.configure(task -> task.getOutputs().upToDateWhen(t -> false));
        this.project.afterEvaluate(p -> {
            ListProperty<String> testTasks = extension.getGwtTest().getTestTasks();
            if (testTasks.isPresent()) {
                List testTaskNames = (List)testTasks.get();
                this.project.getTasks().withType(Test.class).matching(t -> testTaskNames.isEmpty() || testTaskNames.contains(t.getName())).configureEach((Action)new GwtTestConfig(this.project, extension));
            }
        });
    }
}

