/*
 * Decompiled with CFR 0.152.
 */
package org.docstr.gwt;

import javax.inject.Inject;
import org.docstr.gwt.AbstractBaseTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class GwtDevModeTask
extends AbstractBaseTask {
    public static final String DEV_MODE_CLASS = "com.google.gwt.dev.DevMode";
    @Input
    @Optional
    private final Property<Boolean> startServer;
    @Input
    @Optional
    private final Property<Integer> port;
    @OutputDirectory
    @Optional
    private final DirectoryProperty logdir;
    @Input
    @Optional
    private final Property<String> bindAddress;
    @Input
    @Optional
    private final Property<Integer> codeServerPort;
    @Input
    @Optional
    private final Property<Boolean> superDevMode;
    @Input
    @Optional
    private final Property<String> server;
    @Input
    @Optional
    private final Property<String> startupUrl;
    @Input
    @Optional
    private final Property<String> modulePathPrefix;

    @Inject
    public GwtDevModeTask(ObjectFactory objects) {
        super(objects);
        this.startServer = objects.property(Boolean.class);
        this.port = objects.property(Integer.class);
        this.logdir = objects.directoryProperty();
        this.bindAddress = objects.property(String.class);
        this.codeServerPort = objects.property(Integer.class);
        this.superDevMode = objects.property(Boolean.class);
        this.server = objects.property(String.class);
        this.startupUrl = objects.property(String.class);
        this.modulePathPrefix = objects.property(String.class);
        this.getMainClass().set((Object)DEV_MODE_CLASS);
        this.dependsOn(new Object[]{this.getProject().getTasks().withType(JavaCompile.class)});
    }

    public Property<Boolean> getStartServer() {
        return this.startServer;
    }

    public Property<Integer> getPort() {
        return this.port;
    }

    public DirectoryProperty getLogdir() {
        return this.logdir;
    }

    public Property<String> getBindAddress() {
        return this.bindAddress;
    }

    public Property<Integer> getCodeServerPort() {
        return this.codeServerPort;
    }

    public Property<Boolean> getSuperDevMode() {
        return this.superDevMode;
    }

    public Property<String> getServer() {
        return this.server;
    }

    public Property<String> getStartupUrl() {
        return this.startupUrl;
    }

    public Property<String> getModulePathPrefix() {
        return this.modulePathPrefix;
    }

    @Override
    public void exec() {
        if (this.getStartServer().isPresent()) {
            if (((Boolean)this.getStartServer().get()).booleanValue()) {
                this.args(new Object[]{"-startServer"});
            } else {
                this.args(new Object[]{"-nostartServer"});
            }
        }
        if (this.getPort().isPresent()) {
            this.args(new Object[]{"-port", this.getPort().get()});
        }
        if (this.getLogdir().isPresent()) {
            this.args(new Object[]{"-logdir", ((Directory)this.getLogdir().get()).getAsFile().getPath()});
        }
        if (this.getBindAddress().isPresent()) {
            this.args(new Object[]{"-bindAddress", this.getBindAddress().get()});
        }
        if (this.getCodeServerPort().isPresent()) {
            this.args(new Object[]{"-codeServerPort", this.getCodeServerPort().get()});
        }
        if (this.getSuperDevMode().isPresent()) {
            if (((Boolean)this.getSuperDevMode().get()).booleanValue()) {
                this.args(new Object[]{"-superDevMode"});
            } else {
                this.args(new Object[]{"-nosuperDevMode"});
            }
        }
        if (this.getServer().isPresent()) {
            this.args(new Object[]{"-server", this.getServer().get()});
        }
        if (this.getStartupUrl().isPresent()) {
            this.args(new Object[]{"-startupUrl", this.getStartupUrl().get()});
        }
        if (this.getModulePathPrefix().isPresent()) {
            this.args(new Object[]{"-modulePathPrefix", this.getModulePathPrefix().get()});
        }
        super.exec();
    }
}

