/*
 * Decompiled with CFR 0.152.
 */
package org.docstr.gwt;

import java.io.File;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import lombok.Generated;
import org.docstr.gwt.GwtCompileTask;
import org.docstr.gwt.GwtPluginExtension;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GwtCompileConfig
implements Action<GwtCompileTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GwtCompileConfig.class);
    private final GwtPluginExtension extension;

    public GwtCompileConfig(GwtPluginExtension extension) {
        this.extension = extension;
    }

    File findModuleFile(Project project, String moduleName) {
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
        Set sourceFiles = mainSourceSet.getAllSource().getFiles();
        File file = GwtCompileConfig.findModuleFile(moduleName, sourceFiles);
        if (file != null) {
            return file;
        }
        return null;
    }

    static File findModuleFile(String moduleName, Set<File> sourceFiles) {
        String moduleFileName = moduleName.replace('.', '/') + ".gwt.xml";
        for (File file : sourceFiles) {
            log.info("findModuleFile - file: {}, module: {}", (Object)file.getAbsolutePath(), (Object)moduleName);
            if (!file.getAbsolutePath().replaceAll("\\\\", "/").endsWith(moduleFileName)) continue;
            return file;
        }
        return null;
    }

    TreeSet<File> extractSourcePaths(File moduleFile) {
        TreeSet<File> sourcePaths = new TreeSet<File>(Comparator.comparing(File::getName));
        sourcePaths.add(moduleFile);
        try {
            String path;
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(moduleFile);
            File moduleParent = moduleFile.getParentFile();
            int index = moduleParent.getAbsolutePath().replaceAll("\\\\", "/").indexOf("src/main/java");
            File sourceRoot = null;
            if (index > 0) {
                sourceRoot = new File(moduleParent.getAbsolutePath().substring(0, index), "src/main/java");
            }
            if (sourceRoot == null || !sourceRoot.exists()) {
                throw new GradleException("Source root 'src/main/java' cannot be found: " + sourceRoot);
            }
            NodeList entryPointNodes = doc.getElementsByTagName("entry-point");
            for (int i = 0; i < entryPointNodes.getLength(); ++i) {
                Element entryPointElement = (Element)entryPointNodes.item(i);
                path = entryPointElement.getAttribute("class");
                String packageName = path.substring(0, path.lastIndexOf(46));
                String packagePath = packageName.replace('.', '/');
                File packageDir = new File(sourceRoot, packagePath);
                sourcePaths.add(packageDir);
            }
            NodeList sourceNodes = doc.getElementsByTagName("source");
            if (sourceNodes.getLength() == 0) {
                File defaultClientDir = new File(moduleParent, "client");
                if (defaultClientDir.exists()) {
                    sourcePaths.add(defaultClientDir);
                }
            } else {
                for (int i = 0; i < sourceNodes.getLength(); ++i) {
                    path = sourceNodes.item(i).getAttributes().getNamedItem("path").getNodeValue();
                    File sourceDir = new File(moduleParent, path);
                    sourcePaths.add(sourceDir);
                }
            }
            NodeList publicNodes = doc.getElementsByTagName("public");
            if (publicNodes.getLength() == 0) {
                File defaultPublickDir = new File(moduleParent, "public");
                if (defaultPublickDir.exists()) {
                    sourcePaths.add(defaultPublickDir);
                }
            } else {
                for (int i = 0; i < publicNodes.getLength(); ++i) {
                    String path2 = publicNodes.item(i).getAttributes().getNamedItem("path").getNodeValue();
                    File publicDir = new File(moduleParent, path2);
                    sourcePaths.add(publicDir);
                }
            }
        }
        catch (Exception e) {
            log.error("Error reading GWT module file: {}", (Object)moduleFile, (Object)e);
        }
        return sourcePaths;
    }

    public void execute(GwtCompileTask task) {
        Project project = task.getProject();
        org.gradle.api.logging.Logger log = project.getLogger();
        HashSet<File> trackedPaths = new HashSet<File>();
        for (String module : (List)this.extension.getModules().get()) {
            log.info("gwtCompile - Processing GWT module: {}", (Object)module);
            File moduleFile = this.findModuleFile(project, module);
            log.info("gwtCompile - Found module file: {}", (Object)moduleFile);
            if (moduleFile == null) continue;
            trackedPaths.addAll(this.extractSourcePaths(moduleFile));
        }
        ConfigurableFileCollection trackedFiles = project.files(trackedPaths.toArray());
        log.info("gwtCompile - Tracking GWT source files: {}", (Object)trackedFiles.getFiles());
        task.getInputs().files(new Object[]{trackedFiles});
        if (this.extension.getCompiler().getMinHeapSize().isPresent()) {
            task.setMinHeapSize((String)this.extension.getCompiler().getMinHeapSize().get());
        } else {
            task.setMinHeapSize((String)this.extension.getMinHeapSize().getOrElse((Object)"256M"));
        }
        if (this.extension.getCompiler().getMaxHeapSize().isPresent()) {
            task.setMaxHeapSize((String)this.extension.getCompiler().getMaxHeapSize().get());
        } else {
            task.setMaxHeapSize((String)this.extension.getMaxHeapSize().getOrElse((Object)"512M"));
        }
        if (this.extension.getCompiler().getLogLevel().isPresent()) {
            task.getLogLevel().set((Object)((String)this.extension.getCompiler().getLogLevel().get()));
        } else {
            task.getLogLevel().set((Object)((String)this.extension.getLogLevel().getOrNull()));
        }
        if (this.extension.getCompiler().getWorkDir().isPresent()) {
            task.getWorkDir().set((Object)((Directory)this.extension.getCompiler().getWorkDir().get()));
        } else {
            task.getWorkDir().set((Object)((Directory)this.extension.getWorkDir().getOrNull()));
        }
        task.getClosureFormattedOutput().set(this.extension.getCompiler().getClosureFormattedOutput());
        task.getCompileReport().set(this.extension.getCompiler().getCompileReport());
        task.getStrict().set(this.extension.getCompiler().getStrict());
        task.getClassMetadata().set(this.extension.getCompiler().getClassMetadata());
        task.getDraftCompile().set(this.extension.getCompiler().getDraftCompile());
        task.getCheckAssertions().set(this.extension.getCompiler().getCheckAssertions());
        task.getFragmentCount().set(this.extension.getCompiler().getFragmentCount());
        if (this.extension.getCompiler().getGen().isPresent()) {
            task.getGen().set((Object)((Directory)this.extension.getCompiler().getGen().get()));
        } else {
            task.getGen().set((Object)((Directory)this.extension.getGen().getOrNull()));
        }
        if (this.extension.getCompiler().getGenerateJsInteropExports().isPresent()) {
            task.getGenerateJsInteropExports().set((Object)((Boolean)this.extension.getCompiler().getGenerateJsInteropExports().get()));
        } else {
            task.getGenerateJsInteropExports().set((Object)((Boolean)this.extension.getGenerateJsInteropExports().getOrNull()));
        }
        if (this.extension.getCompiler().getIncludeJsInteropExports().isPresent() && !((List)this.extension.getCompiler().getIncludeJsInteropExports().get()).isEmpty()) {
            task.getIncludeJsInteropExports().set((Iterable)this.extension.getCompiler().getIncludeJsInteropExports().get());
        } else {
            task.getIncludeJsInteropExports().set((Iterable)this.extension.getIncludeJsInteropExports().getOrNull());
        }
        if (this.extension.getCompiler().getExcludeJsInteropExports().isPresent() && !((List)this.extension.getCompiler().getExcludeJsInteropExports().get()).isEmpty()) {
            task.getExcludeJsInteropExports().set((Iterable)this.extension.getCompiler().getExcludeJsInteropExports().get());
        } else {
            task.getExcludeJsInteropExports().set((Iterable)this.extension.getExcludeJsInteropExports().getOrNull());
        }
        if (this.extension.getCompiler().getMethodNameDisplayMode().isPresent()) {
            task.getMethodNameDisplayMode().set((Object)((String)this.extension.getCompiler().getMethodNameDisplayMode().get()));
        } else {
            task.getMethodNameDisplayMode().set((Object)((String)this.extension.getMethodNameDisplayMode().getOrNull()));
        }
        task.getNamespace().set((Object)((String)this.extension.getCompiler().getNamespace().getOrNull()));
        task.getOptimize().set((Object)((Integer)this.extension.getCompiler().getOptimize().getOrNull()));
        task.getSaveSource().set((Object)((Boolean)this.extension.getCompiler().getSaveSource().getOrNull()));
        if (this.extension.getCompiler().getSetProperty().isPresent() && !((List)this.extension.getCompiler().getSetProperty().get()).isEmpty()) {
            task.getSetProperty().set((Iterable)this.extension.getCompiler().getSetProperty().get());
        } else {
            task.getSetProperty().set((Iterable)this.extension.getSetProperty().getOrNull());
        }
        if (this.extension.getCompiler().getStyle().isPresent()) {
            task.getStyle().set((Object)((String)this.extension.getCompiler().getStyle().get()));
        } else {
            task.getStyle().set((Object)((String)this.extension.getStyle().getOrNull()));
        }
        if (this.extension.getCompiler().getFailOnError().isPresent()) {
            task.getFailOnError().set((Object)((Boolean)this.extension.getCompiler().getFailOnError().get()));
        } else {
            task.getFailOnError().set((Object)((Boolean)this.extension.getFailOnError().getOrNull()));
        }
        task.getValidateOnly().set((Object)((Boolean)this.extension.getCompiler().getValidateOnly().getOrNull()));
        if (this.extension.getCompiler().getSourceLevel().isPresent()) {
            task.getSourceLevel().set((Object)((String)this.extension.getCompiler().getSourceLevel().get()));
        } else {
            task.getSourceLevel().set((Object)((String)this.extension.getSourceLevel().getOrNull()));
        }
        task.getLocalWorkers().set((Object)((Integer)this.extension.getCompiler().getLocalWorkers().getOrNull()));
        if (this.extension.getCompiler().getIncremental().isPresent()) {
            task.getIncremental().set((Object)((Boolean)this.extension.getCompiler().getIncremental().get()));
        } else {
            task.getIncremental().set((Object)((Boolean)this.extension.getIncremental().getOrNull()));
        }
        if (this.extension.getCompiler().getWar().isPresent()) {
            task.getWar().set((Object)((Directory)this.extension.getCompiler().getWar().get()));
        } else {
            task.getWar().set((Object)((Directory)this.extension.getWar().getOrNull()));
        }
        if (this.extension.getCompiler().getDeploy().isPresent()) {
            task.getDeploy().set((Object)((Directory)this.extension.getCompiler().getDeploy().get()));
        } else {
            task.getDeploy().set((Object)((Directory)this.extension.getDeploy().getOrNull()));
        }
        if (this.extension.getCompiler().getExtra().isPresent()) {
            task.getExtra().set((Object)((Directory)this.extension.getCompiler().getExtra().get()));
        } else {
            task.getExtra().set((Object)((Directory)this.extension.getExtra().getOrNull()));
        }
        if (this.extension.getCompiler().getCacheDir().isPresent()) {
            task.getCacheDir().set((Object)((Directory)this.extension.getCompiler().getCacheDir().get()));
        } else {
            task.getCacheDir().set((Object)((Directory)this.extension.getCacheDir().getOrNull()));
        }
        task.getSaveSourceOutput().set((Object)((Directory)this.extension.getCompiler().getSaveSourceOutput().getOrNull()));
        if (this.extension.getCompiler().getModules().isPresent() && !((List)this.extension.getCompiler().getModules().get()).isEmpty()) {
            task.getModules().set((Iterable)this.extension.getCompiler().getModules().get());
        } else {
            task.getModules().set((Iterable)this.extension.getModules().get());
        }
        if (((List)task.getModules().get()).isEmpty()) {
            throw new GradleException("gwtCompile failed: 'modules' property is required. Please specify at least one GWT module in the gwt { ... } block.");
        }
    }
}

