/*
 * Decompiled with CFR 0.152.
 */
package org.didd.http;

import java.util.List;
import java.util.Map;
import org.didd.http.HttpEntry;
import org.didd.http.HttpResponseBody;
import org.didd.http.HttpResponseHeader;

public class HttpResponse {
    public int code;
    public String message;
    private HttpEntry entry;
    private HttpResponseHeader header;
    private HttpResponseBody body;

    public HttpResponse(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public HttpResponse(int code, String message, HttpEntry entry, HttpResponseHeader header, HttpResponseBody body) {
        this.code = code;
        this.message = message;
        this.entry = entry;
        this.header = header;
        this.body = body;
    }

    public HttpEntry getEntry() {
        return this.entry;
    }

    public HttpResponseHeader getHeader() {
        return this.header;
    }

    public HttpResponseBody getBody() {
        return this.body;
    }

    public String log() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.entry.log());
        sb.append("\n");
        sb.append("-------------------------------Response Start------------------------------------------------").append("\n");
        sb.append("            ").append(this.code).append(" ").append(null == this.message ? "" : this.message).append("\n");
        int len = 0;
        String bank = "";
        int size = 0;
        sb.append("\n");
        if (null != this.header && null != this.header.getMap()) {
            for (Map.Entry<String, List<String>> entry : this.header.getMap().entrySet()) {
                sb.append("            ").append("    ").append(entry.getKey()).append(":");
                len = (entry.getKey() + ":").length();
                bank = this.getBanks(len);
                size = null == entry.getValue() ? 0 : entry.getValue().size();
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        sb.append("            ").append("    ").append(bank);
                    }
                    sb.append(entry.getValue().get(i)).append("\n");
                }
            }
        }
        sb.append("\n");
        if (null != this.body) {
            sb.append("\n").append("            ").append("    ").append(this.body.getCharset().displayName()).append("\n");
            sb.append("            ").append("    ").append(this.body.getString()).append("\n");
        }
        sb.append("-------------------------------Response  End--------------------------------------------------").append("\n");
        return sb.toString();
    }

    private String getBanks(int len) {
        if (len < 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }
}

