/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel.reader;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.util.ZipEntrySource;
import org.apache.poi.openxml4j.util.ZipFileZipEntrySource;
import org.apache.poi.poifs.common.POIFSConstants;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStrings;
import org.dhatim.fastexcel.reader.ExcelReaderException;
import org.dhatim.fastexcel.reader.Row;
import org.dhatim.fastexcel.reader.RowSpliterator;
import org.dhatim.fastexcel.reader.Sheet;
import org.dhatim.fastexcel.reader.SimpleXmlReader;
import org.xml.sax.SAXException;

public class ReadableWorkbook
implements Closeable {
    private final OPCPackage pkg;
    private final XSSFReader reader;
    private final SharedStrings sst;
    private final XMLInputFactory factory;
    private boolean date1904;
    private final List<Sheet> sheets = new ArrayList<Sheet>();

    public ReadableWorkbook(File inputFile) throws IOException {
        this(ReadableWorkbook.open(inputFile));
    }

    public ReadableWorkbook(InputStream inputStream) throws IOException {
        this(ReadableWorkbook.open(inputStream));
    }

    private ReadableWorkbook(OPCPackage pkg) throws IOException {
        try {
            this.pkg = pkg;
            this.reader = new XSSFReader(pkg);
            this.sst = new ReadOnlySharedStringsTable(pkg, false);
        }
        catch (NotOfficeXmlFileException | OpenXML4JException | SAXException e) {
            throw new ExcelReaderException(e);
        }
        this.factory = XMLInputFactory.newInstance();
        this.factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        try (SimpleXmlReader workbookReader = new SimpleXmlReader(this.factory, this.reader.getWorkbookData());){
            this.readWorkbook(workbookReader);
        }
        catch (XMLStreamException | InvalidFormatException e) {
            throw new ExcelReaderException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.pkg.close();
    }

    public boolean isDate1904() {
        return this.date1904;
    }

    public Stream<Sheet> getSheets() {
        return this.sheets.stream();
    }

    public Optional<Sheet> getSheet(int index) {
        return index < 0 || index >= this.sheets.size() ? Optional.empty() : Optional.of(this.sheets.get(index));
    }

    public Sheet getFirstSheet() {
        return this.sheets.get(0);
    }

    public Optional<Sheet> findSheet(String name) {
        return this.sheets.stream().filter(sheet -> name.equals(sheet.getName())).findFirst();
    }

    private void readWorkbook(SimpleXmlReader r) throws XMLStreamException {
        while (r.goTo(() -> r.isStartElement("sheets") || r.isStartElement("workbookPr") || r.isEndElement("workbook"))) {
            if ("sheets".equals(r.getLocalName())) {
                r.forEach("sheet", "sheets", this::createSheet);
                continue;
            }
            if (!"workbookPr".equals(r.getLocalName())) break;
            String date1904Value = r.getAttribute("date1904");
            this.date1904 = Boolean.parseBoolean(date1904Value);
        }
    }

    private void createSheet(SimpleXmlReader r) {
        String name = r.getAttribute("name");
        String id = r.getAttribute("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id");
        int index = this.sheets.size();
        this.sheets.add(new Sheet(this, index, id, name));
    }

    Stream<Row> openStream(Sheet sheet) throws IOException {
        try {
            InputStream inputStream = this.reader.getSheet(sheet.getId());
            Stream<Row> stream = StreamSupport.stream(new RowSpliterator(this, inputStream), false);
            return (Stream)stream.onClose(ReadableWorkbook.asUncheckedRunnable(inputStream));
        }
        catch (XMLStreamException | InvalidFormatException e) {
            throw new IOException(e);
        }
    }

    XMLInputFactory getXmlFactory() {
        return this.factory;
    }

    SharedStrings getSharedStringsTable() {
        return this.sst;
    }

    public static boolean isOOXMLZipHeader(byte[] bytes) {
        ReadableWorkbook.requireLength(bytes, POIFSConstants.OOXML_FILE_HEADER.length);
        return Arrays.equals(Arrays.copyOf(bytes, POIFSConstants.OOXML_FILE_HEADER.length), POIFSConstants.OOXML_FILE_HEADER);
    }

    public static boolean isOLE2Header(byte[] bytes) {
        ReadableWorkbook.requireLength(bytes, 8);
        byte[] ole2Header = new byte[8];
        LittleEndian.putLong((byte[])ole2Header, (int)0, (long)-2226271756974174256L);
        return Arrays.equals(Arrays.copyOf(bytes, ole2Header.length), ole2Header);
    }

    private static void requireLength(byte[] bytes, int requiredLength) {
        if (bytes.length < requiredLength) {
            throw new IllegalArgumentException("Insufficient header bytes");
        }
    }

    private static Runnable asUncheckedRunnable(Closeable c) {
        return () -> {
            try {
                c.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private static OPCPackage open(File file) {
        try {
            return OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);
        }
        catch (InvalidFormatException e) {
            throw new ExcelReaderException(e);
        }
    }

    private static OPCPackage open(InputStream in) throws IOException {
        try {
            byte[] compressedBytes = IOUtils.toByteArray((InputStream)in);
            ZipFile zipFile = new ZipFile((SeekableByteChannel)new SeekableInMemoryByteChannel(compressedBytes));
            return OPCPackage.open((ZipEntrySource)new ZipFileZipEntrySource(zipFile));
        }
        catch (InvalidFormatException e) {
            throw new ExcelReaderException(e);
        }
    }
}

