/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.gym;

import com.mashape.unirest.http.JsonNode;
import java.util.Set;
import org.deeplearning4j.gym.ClientUtils;
import org.deeplearning4j.gym.StepReply;
import org.deeplearning4j.rl4j.space.ActionSpace;
import org.deeplearning4j.rl4j.space.GymObservationSpace;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Client<O, A, AS extends ActionSpace<A>> {
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    public static String V1_ROOT = "/v1";
    public static String ENVS_ROOT = V1_ROOT + "/envs/";
    public static String MONITOR_START = "/monitor/start/";
    public static String MONITOR_CLOSE = "/monitor/close/";
    public static String CLOSE = "/close/";
    public static String RESET = "/reset/";
    public static String SHUTDOWN = "/shutdown/";
    public static String UPLOAD = "/upload/";
    public static String STEP = "/step/";
    public static String OBSERVATION_SPACE = "/observation_space/";
    public static String ACTION_SPACE = "/action_space/";
    private final String url;
    private final String envId;
    private final String instanceId;
    private final GymObservationSpace<O> observationSpace;
    private final AS actionSpace;
    private final boolean render;

    public static Set<String> listAll(String url) {
        JSONObject reply = ClientUtils.get(url + ENVS_ROOT);
        return reply.getJSONObject("envs").keySet();
    }

    public static void serverShutdown(String url) {
        ClientUtils.post(url + ENVS_ROOT + SHUTDOWN, new JSONObject());
    }

    public Set<String> listAll() {
        return Client.listAll(this.url);
    }

    public StepReply<O> step(A action) {
        JSONObject body = new JSONObject().put("action", this.getActionSpace().encode(action)).put("render", this.render);
        JSONObject reply = ClientUtils.post(this.url + ENVS_ROOT + this.instanceId + STEP, body).getObject();
        O observation = this.observationSpace.getValue(reply, "observation");
        double reward = reply.getDouble("reward");
        boolean done = reply.getBoolean("done");
        JSONObject info = reply.getJSONObject("info");
        return new StepReply<O>(observation, reward, done, info);
    }

    public O reset() {
        JsonNode resetRep = ClientUtils.post(this.url + ENVS_ROOT + this.instanceId + RESET, new JSONObject());
        return this.observationSpace.getValue(resetRep.getObject(), "observation");
    }

    public void monitorStart(String directory, boolean force, boolean resume) {
        JSONObject json = new JSONObject().put("directory", (Object)directory).put("force", force).put("resume", resume);
        this.monitorStartPost(json);
    }

    private void monitorStartPost(JSONObject json) {
        ClientUtils.post(this.url + ENVS_ROOT + this.instanceId + MONITOR_START, json);
    }

    public void monitorClose() {
        ClientUtils.post(this.url + ENVS_ROOT + this.instanceId + MONITOR_CLOSE, new JSONObject());
    }

    public void upload(String trainingDir, String apiKey, String algorithmId) {
        JSONObject json = new JSONObject().put("training_dir", (Object)trainingDir).put("api_key", (Object)apiKey).put("algorithm_id", (Object)algorithmId);
        this.uploadPost(json);
    }

    public void upload(String trainingDir, String apiKey) {
        JSONObject json = new JSONObject().put("training_dir", (Object)trainingDir).put("api_key", (Object)apiKey);
        this.uploadPost(json);
    }

    private void uploadPost(JSONObject json) {
        try {
            ClientUtils.post(this.url + V1_ROOT + UPLOAD, json);
        }
        catch (RuntimeException e) {
            log.error("Impossible to upload: Wrong API key?");
        }
    }

    public void serverShutdown() {
        Client.serverShutdown(this.url);
    }

    public ActionSpace getActionSpace() {
        return this.actionSpace;
    }

    public Client(String url, String envId, String instanceId, GymObservationSpace<O> observationSpace, AS actionSpace, boolean render) {
        this.url = url;
        this.envId = envId;
        this.instanceId = instanceId;
        this.observationSpace = observationSpace;
        this.actionSpace = actionSpace;
        this.render = render;
    }

    public String getUrl() {
        return this.url;
    }

    public String getEnvId() {
        return this.envId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public GymObservationSpace<O> getObservationSpace() {
        return this.observationSpace;
    }

    public boolean isRender() {
        return this.render;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Client)) {
            return false;
        }
        Client other = (Client)o;
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$envId = this.getEnvId();
        String other$envId = other.getEnvId();
        if (this$envId == null ? other$envId != null : !this$envId.equals(other$envId)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
            return false;
        }
        GymObservationSpace<O> this$observationSpace = this.getObservationSpace();
        GymObservationSpace<O> other$observationSpace = other.getObservationSpace();
        if (this$observationSpace == null ? other$observationSpace != null : !((Object)this$observationSpace).equals(other$observationSpace)) {
            return false;
        }
        ActionSpace this$actionSpace = this.getActionSpace();
        ActionSpace other$actionSpace = other.getActionSpace();
        if (this$actionSpace == null ? other$actionSpace != null : !this$actionSpace.equals(other$actionSpace)) {
            return false;
        }
        return this.isRender() == other.isRender();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $envId = this.getEnvId();
        result = result * 59 + ($envId == null ? 43 : $envId.hashCode());
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        GymObservationSpace<O> $observationSpace = this.getObservationSpace();
        result = result * 59 + ($observationSpace == null ? 43 : ((Object)$observationSpace).hashCode());
        ActionSpace $actionSpace = this.getActionSpace();
        result = result * 59 + ($actionSpace == null ? 43 : $actionSpace.hashCode());
        result = result * 59 + (this.isRender() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Client(url=" + this.getUrl() + ", envId=" + this.getEnvId() + ", instanceId=" + this.getInstanceId() + ", observationSpace=" + this.getObservationSpace() + ", actionSpace=" + this.getActionSpace() + ", render=" + this.isRender() + ")";
    }
}

