/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.util.imagenet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.deeplearning4j.zoo.util.BaseLabels;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.jackson.databind.ObjectMapper;

public class ImageNetLabels
extends BaseLabels {
    private static final String jsonResource = "imagenet_class_index.json";
    private ArrayList<String> predictionLabels = this.getLabels();

    @Override
    protected ArrayList<String> getLabels() throws IOException {
        if (this.predictionLabels == null) {
            HashMap jsonMap = (HashMap)new ObjectMapper().readValue(this.getClass().getResourceAsStream(jsonResource), HashMap.class);
            this.predictionLabels = new ArrayList(jsonMap.size());
            for (int i = 0; i < jsonMap.size(); ++i) {
                this.predictionLabels.add((String)((ArrayList)jsonMap.get(String.valueOf(i))).get(1));
            }
        }
        return this.predictionLabels;
    }

    @Override
    public String getLabel(int n) {
        return this.predictionLabels.get(n);
    }

    public String decodePredictions(INDArray predictions) {
        String predictionDescription = "";
        int[] top5 = new int[5];
        float[] top5Prob = new float[5];
        int i = 0;
        for (int batch = 0; batch < predictions.size(0); ++batch) {
            predictionDescription = predictionDescription + "Predictions for batch ";
            if (predictions.size(0) > 1) {
                predictionDescription = predictionDescription + String.valueOf(batch);
            }
            predictionDescription = predictionDescription + " :";
            INDArray currentBatch = predictions.getRow(batch).dup();
            while (i < 5) {
                top5[i] = Nd4j.argMax((INDArray)currentBatch, (int[])new int[]{1}).getInt(new int[]{0, 0});
                top5Prob[i] = currentBatch.getFloat(batch, top5[i]);
                currentBatch.putScalar(0, top5[i], 0.0);
                predictionDescription = predictionDescription + "\n\t" + String.format("%3f", Float.valueOf(top5Prob[i] * 100.0f)) + "%, " + this.predictionLabels.get(top5[i]);
                ++i;
            }
        }
        return predictionDescription;
    }
}

