/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DropoutLayer;
import org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.PoolingType;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.AdaDelta;
import org.nd4j.linalg.learning.config.IUpdater;

public class SimpleCNN
extends ZooModel {
    private int[] inputShape = new int[]{3, 48, 48};
    private int numLabels;
    private long seed;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    public SimpleCNN(int numLabels, long seed) {
        this(numLabels, seed, WorkspaceMode.SEPARATE);
    }

    public SimpleCNN(int numLabels, long seed, WorkspaceMode workspaceMode) {
        this.numLabels = numLabels;
        this.seed = seed;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = workspaceMode == WorkspaceMode.SINGLE ? ConvolutionLayer.AlgoMode.PREFER_FASTEST : ConvolutionLayer.AlgoMode.NO_WORKSPACE;
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        return 0L;
    }

    @Override
    public ZooType zooType() {
        return ZooType.SIMPLECNN;
    }

    @Override
    public Class<? extends Model> modelType() {
        return MultiLayerNetwork.class;
    }

    public MultiLayerConfiguration conf() {
        MultiLayerConfiguration conf = new NeuralNetConfiguration.Builder().trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).seed(this.seed).activation(Activation.IDENTITY).weightInit(WeightInit.RELU).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).updater((IUpdater)new AdaDelta()).convolutionMode(ConvolutionMode.Same).list().layer(0, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{7, 7}).name("image_array")).nIn(this.inputShape[0])).nOut(16)).build()).layer(1, (Layer)new BatchNormalization.Builder().build()).layer(2, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{7, 7}).nIn(16)).nOut(16)).build()).layer(3, (Layer)new BatchNormalization.Builder().build()).layer(4, (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build()).layer(5, (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.AVG, new int[]{2, 2}).build()).layer(6, (Layer)new DropoutLayer.Builder(0.5).build()).layer(7, (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{5, 5}).nOut(32)).build()).layer(8, (Layer)new BatchNormalization.Builder().build()).layer(9, (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{5, 5}).nOut(32)).build()).layer(10, (Layer)new BatchNormalization.Builder().build()).layer(11, (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build()).layer(12, (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.AVG, new int[]{2, 2}).build()).layer(13, (Layer)new DropoutLayer.Builder(0.5).build()).layer(14, (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).nOut(64)).build()).layer(15, (Layer)new BatchNormalization.Builder().build()).layer(16, (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).nOut(64)).build()).layer(17, (Layer)new BatchNormalization.Builder().build()).layer(18, (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build()).layer(19, (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.AVG, new int[]{2, 2}).build()).layer(20, (Layer)new DropoutLayer.Builder(0.5).build()).layer(21, (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).nOut(128)).build()).layer(22, (Layer)new BatchNormalization.Builder().build()).layer(23, (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).nOut(128)).build()).layer(24, (Layer)new BatchNormalization.Builder().build()).layer(25, (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build()).layer(26, (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.AVG, new int[]{2, 2}).build()).layer(27, (Layer)new DropoutLayer.Builder(0.5).build()).layer(28, (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).nOut(256)).build()).layer(29, (Layer)new BatchNormalization.Builder().build()).layer(30, (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).nOut(this.numLabels)).build()).layer(31, (Layer)new GlobalPoolingLayer.Builder(PoolingType.AVG).build()).layer(32, (Layer)new ActivationLayer.Builder().activation(Activation.SOFTMAX).build()).setInputType(InputType.convolutional((int)this.inputShape[2], (int)this.inputShape[1], (int)this.inputShape[0])).backprop(true).pretrain(false).build();
        return conf;
    }

    @Override
    public Model init() {
        MultiLayerNetwork network = new MultiLayerNetwork(this.conf());
        network.init();
        return network;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    public SimpleCNN() {
    }
}

