/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.module.train;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.ext.web.RoutingContext;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.deeplearning4j.core.storage.Persistable;
import org.deeplearning4j.core.storage.StatsStorage;
import org.deeplearning4j.core.storage.StatsStorageEvent;
import org.deeplearning4j.core.storage.StatsStorageListener;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.graph.LayerVertex;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.serde.JsonMappers;
import org.deeplearning4j.ui.VertxUIServer;
import org.deeplearning4j.ui.api.HttpMethod;
import org.deeplearning4j.ui.api.I18N;
import org.deeplearning4j.ui.api.Route;
import org.deeplearning4j.ui.api.UIModule;
import org.deeplearning4j.ui.i18n.DefaultI18N;
import org.deeplearning4j.ui.i18n.I18NProvider;
import org.deeplearning4j.ui.i18n.I18NResource;
import org.deeplearning4j.ui.model.stats.api.Histogram;
import org.deeplearning4j.ui.model.stats.api.StatsInitializationReport;
import org.deeplearning4j.ui.model.stats.api.StatsReport;
import org.deeplearning4j.ui.model.stats.api.StatsType;
import org.deeplearning4j.ui.module.train.TrainModuleUtils;
import org.nd4j.common.function.Function;
import org.nd4j.common.primitives.Pair;
import org.nd4j.common.primitives.Triple;
import org.nd4j.common.resources.Resources;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainModule
implements UIModule {
    private static final Logger log = LoggerFactory.getLogger(TrainModule.class);
    public static final double NAN_REPLACEMENT_VALUE = 0.0;
    public static final int DEFAULT_MAX_CHART_POINTS = 512;
    private static final DecimalFormat df2 = new DecimalFormat("#.00");
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final int maxChartPoints;
    private Map<String, StatsStorage> knownSessionIDs = Collections.synchronizedMap(new HashMap());
    private String currentSessionID;
    private int currentWorkerIdx;
    private Map<String, AtomicInteger> workerIdxCount = new ConcurrentHashMap<String, AtomicInteger>();
    private Map<String, Map<Integer, String>> workerIdxToName = new ConcurrentHashMap<String, Map<Integer, String>>();
    private Map<String, Long> lastUpdateForSession = new ConcurrentHashMap<String, Long>();
    private final Configuration configuration;
    private static Triple<int[], float[], float[]> EMPTY_TRIPLE = new Triple((Object)new int[0], (Object)new float[0], (Object)new float[0]);
    private static final Map<String, Object> EMPTY_LR_MAP = new HashMap<String, Object>();

    public TrainModule() {
        String maxChartPointsProp = System.getProperty("org.deeplearning4j.ui.maxChartPoints");
        int value = 512;
        if (maxChartPointsProp != null) {
            try {
                value = Integer.parseInt(maxChartPointsProp);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid system property: {} = {}", (Object)"org.deeplearning4j.ui.maxChartPoints", (Object)maxChartPointsProp);
            }
        }
        this.maxChartPoints = value >= 10 ? value : 512;
        this.configuration = new Configuration(new Version(2, 3, 23));
        this.configuration.setDefaultEncoding("UTF-8");
        this.configuration.setLocale(Locale.US);
        this.configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.configuration.setClassForTemplateLoading(TrainModule.class, "");
        try {
            File dir = Resources.asFile((String)"templates/TrainingOverview.html.ftl").getParentFile();
            this.configuration.setDirectoryForTemplateLoading(dir);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public List<String> getCallbackTypeIDs() {
        return Collections.singletonList("StatsListener");
    }

    @Override
    public List<Route> getRoutes() {
        ArrayList<Route> r = new ArrayList<Route>();
        r.add(new Route("/train/multisession", HttpMethod.GET, (path, rc) -> rc.response().end(VertxUIServer.getInstance().isMultiSession() ? "true" : "false")));
        if (VertxUIServer.getInstance().isMultiSession()) {
            r.add(new Route("/train", HttpMethod.GET, (path, rc) -> this.listSessions((RoutingContext)rc)));
            r.add(new Route("/train/:sessionId", HttpMethod.GET, (path, rc) -> rc.response().putHeader("location", (String)path.get(0) + "/overview").setStatusCode(HttpResponseStatus.FOUND.code()).end()));
            r.add(new Route("/train/:sessionId/overview", HttpMethod.GET, (path, rc) -> {
                if (this.knownSessionIDs.containsKey(path.get(0))) {
                    this.renderFtl("TrainingOverview.html.ftl", (RoutingContext)rc);
                } else {
                    this.sessionNotFound((String)path.get(0), rc.request().path(), (RoutingContext)rc);
                }
            }));
            r.add(new Route("/train/:sessionId/overview/data", HttpMethod.GET, (path, rc) -> {
                if (this.knownSessionIDs.containsKey(path.get(0))) {
                    this.getOverviewDataForSession((String)path.get(0), (RoutingContext)rc);
                } else {
                    this.sessionNotFound((String)path.get(0), rc.request().path(), (RoutingContext)rc);
                }
            }));
            r.add(new Route("/train/:sessionId/model", HttpMethod.GET, (path, rc) -> {
                if (this.knownSessionIDs.containsKey(path.get(0))) {
                    this.renderFtl("TrainingModel.html.ftl", (RoutingContext)rc);
                } else {
                    this.sessionNotFound((String)path.get(0), rc.request().path(), (RoutingContext)rc);
                }
            }));
            r.add(new Route("/train/:sessionId/model/graph", HttpMethod.GET, (path, rc) -> this.getModelGraphForSession((String)path.get(0), (RoutingContext)rc)));
            r.add(new Route("/train/:sessionId/model/data/:layerId", HttpMethod.GET, (path, rc) -> this.getModelDataForSession((String)path.get(0), (String)path.get(1), (RoutingContext)rc)));
            r.add(new Route("/train/:sessionId/system", HttpMethod.GET, (path, rc) -> {
                if (this.knownSessionIDs.containsKey(path.get(0))) {
                    this.renderFtl("TrainingSystem.html.ftl", (RoutingContext)rc);
                } else {
                    this.sessionNotFound((String)path.get(0), rc.request().path(), (RoutingContext)rc);
                }
            }));
            r.add(new Route("/train/:sessionId/info", HttpMethod.GET, (path, rc) -> this.sessionInfoForSession((String)path.get(0), (RoutingContext)rc)));
            r.add(new Route("/train/:sessionId/system/data", HttpMethod.GET, (path, rc) -> this.getSystemDataForSession((String)path.get(0), (RoutingContext)rc)));
        } else {
            r.add(new Route("/train", HttpMethod.GET, (path, rc) -> rc.reroute("/train/overview")));
            r.add(new Route("/train/sessions/current", HttpMethod.GET, (path, rc) -> rc.response().end(this.currentSessionID == null ? "" : this.currentSessionID)));
            r.add(new Route("/train/sessions/set/:to", HttpMethod.GET, (path, rc) -> this.setSession((String)path.get(0), (RoutingContext)rc)));
            r.add(new Route("/train/overview", HttpMethod.GET, (path, rc) -> this.renderFtl("TrainingOverview.html.ftl", (RoutingContext)rc)));
            r.add(new Route("/train/overview/data", HttpMethod.GET, (path, rc) -> this.getOverviewData((RoutingContext)rc)));
            r.add(new Route("/train/model", HttpMethod.GET, (path, rc) -> this.renderFtl("TrainingModel.html.ftl", (RoutingContext)rc)));
            r.add(new Route("/train/model/graph", HttpMethod.GET, (path, rc) -> this.getModelGraph((RoutingContext)rc)));
            r.add(new Route("/train/model/data/:layerId", HttpMethod.GET, (path, rc) -> this.getModelData((String)path.get(0), (RoutingContext)rc)));
            r.add(new Route("/train/system", HttpMethod.GET, (path, rc) -> this.renderFtl("TrainingSystem.html.ftl", (RoutingContext)rc)));
            r.add(new Route("/train/sessions/info", HttpMethod.GET, (path, rc) -> this.sessionInfo((RoutingContext)rc)));
            r.add(new Route("/train/system/data", HttpMethod.GET, (path, rc) -> this.getSystemData((RoutingContext)rc)));
        }
        r.add(new Route("/train/sessions/lastUpdate/:sessionId", HttpMethod.GET, (path, rc) -> this.getLastUpdateForSession((String)path.get(0), (RoutingContext)rc)));
        r.add(new Route("/train/workers/setByIdx/:to", HttpMethod.GET, (path, rc) -> this.setWorkerByIdx((String)path.get(0), (RoutingContext)rc)));
        return r;
    }

    private void renderFtl(String file, RoutingContext rc) {
        String html;
        String sessionId = rc.request().getParam("sessionID");
        String langCode = DefaultI18N.getInstance(sessionId).getDefaultLanguage();
        Map<String, String> input = DefaultI18N.getInstance().getMessages(langCode);
        try {
            String content = FileUtils.readFileToString((File)Resources.asFile((String)("templates/" + file)), (Charset)StandardCharsets.UTF_8);
            Template template = new Template(FilenameUtils.getName((String)file), (Reader)new StringReader(content), this.configuration);
            StringWriter stringWriter = new StringWriter();
            template.process(input, (Writer)stringWriter);
            html = stringWriter.toString();
        }
        catch (Throwable t) {
            log.error("", t);
            throw new RuntimeException(t);
        }
        rc.response().end(html);
    }

    private synchronized void listSessions(RoutingContext rc) {
        StringBuilder sb = new StringBuilder("<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n        <meta charset=\"utf-8\">\n        <title>Training sessions - DL4J Training UI</title>\n    </head>\n\n    <body>\n        <h1>DL4J Training UI</h1>\n        <p>UI server is in multi-session mode. To visualize a training session, please select one from the following list.</p>\n        <h2>List of attached training sessions</h2>\n");
        if (!this.knownSessionIDs.isEmpty()) {
            sb.append("        <ul>");
            for (String sessionId : this.knownSessionIDs.keySet()) {
                sb.append("            <li><a href=\"/train/").append(sessionId).append("\">").append(sessionId).append("</a></li>\n");
            }
            sb.append("        </ul>");
        } else {
            sb.append("No training session attached.");
        }
        sb.append("    </body>\n</html>\n");
        rc.response().putHeader("content-type", "text/html; charset=utf-8").end(sb.toString());
    }

    private void sessionNotFound(String sessionId, String targetPath, RoutingContext rc) {
        Function<String, Boolean> loader = VertxUIServer.getInstance().getStatsStorageLoader();
        if (loader != null && ((Boolean)loader.apply((Object)sessionId)).booleanValue()) {
            if (targetPath != null) {
                rc.reroute(targetPath);
            } else {
                rc.response().end();
            }
        } else {
            rc.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end("Unknown session ID: " + sessionId);
        }
    }

    @Override
    public synchronized void reportStorageEvents(Collection<StatsStorageEvent> events) {
        for (StatsStorageEvent sse : events) {
            Long lastUpdate;
            if (!"StatsListener".equals(sse.getTypeID())) continue;
            if (sse.getEventType() == StatsStorageListener.EventType.PostStaticInfo && "StatsListener".equals(sse.getTypeID()) && !this.knownSessionIDs.containsKey(sse.getSessionID())) {
                this.knownSessionIDs.put(sse.getSessionID(), sse.getStatsStorage());
                if (VertxUIServer.getInstance().isMultiSession()) {
                    log.info("Adding training session {}/train/{} of StatsStorage instance {}", new Object[]{VertxUIServer.getInstance().getAddress(), sse.getSessionID(), sse.getStatsStorage()});
                }
            }
            if ((lastUpdate = this.lastUpdateForSession.get(sse.getSessionID())) == null) {
                this.lastUpdateForSession.put(sse.getSessionID(), sse.getTimestamp());
                continue;
            }
            if (sse.getTimestamp() <= lastUpdate) continue;
            this.lastUpdateForSession.put(sse.getSessionID(), sse.getTimestamp());
        }
        if (this.currentSessionID == null) {
            this.getDefaultSession();
        }
    }

    @Override
    public synchronized void onAttach(StatsStorage statsStorage) {
        for (String sessionID : statsStorage.listSessionIDs()) {
            for (String typeID : statsStorage.listTypeIDsForSession(sessionID)) {
                if (!"StatsListener".equals(typeID)) continue;
                this.knownSessionIDs.put(sessionID, statsStorage);
                if (VertxUIServer.getInstance().isMultiSession()) {
                    log.info("Adding training session {}/train/{} of StatsStorage instance {}", new Object[]{VertxUIServer.getInstance().getAddress(), sessionID, statsStorage});
                }
                List latestUpdates = statsStorage.getLatestUpdateAllWorkers(sessionID, typeID);
                for (Persistable update : latestUpdates) {
                    long updateTime = update.getTimeStamp();
                    if (!this.lastUpdateForSession.containsKey(sessionID) || this.lastUpdateForSession.get(sessionID) >= updateTime) continue;
                    this.lastUpdateForSession.put(sessionID, updateTime);
                }
            }
        }
        if (this.currentSessionID == null) {
            this.getDefaultSession();
        }
    }

    @Override
    public synchronized void onDetach(StatsStorage statsStorage) {
        HashSet<String> toRemove = new HashSet<String>();
        for (String s : this.knownSessionIDs.keySet()) {
            if (this.knownSessionIDs.get(s) != statsStorage) continue;
            toRemove.add(s);
            this.workerIdxCount.remove(s);
            this.workerIdxToName.remove(s);
            this.currentSessionID = null;
        }
        for (String s : toRemove) {
            this.knownSessionIDs.remove(s);
            if (VertxUIServer.getInstance().isMultiSession()) {
                log.info("Removing training session {}/train/{} of StatsStorage instance {}.", new Object[]{VertxUIServer.getInstance().getAddress(), s, statsStorage});
            }
            this.lastUpdateForSession.remove(s);
        }
        this.getDefaultSession();
    }

    private synchronized void getDefaultSession() {
        if (this.currentSessionID != null) {
            return;
        }
        long mostRecentTime = Long.MIN_VALUE;
        String sessionID = null;
        for (Map.Entry<String, StatsStorage> entry : this.knownSessionIDs.entrySet()) {
            Persistable p;
            long thisTime;
            List staticInfos = entry.getValue().getAllStaticInfos(entry.getKey(), "StatsListener");
            if (staticInfos == null || staticInfos.isEmpty() || (thisTime = (p = (Persistable)staticInfos.get(0)).getTimeStamp()) <= mostRecentTime) continue;
            mostRecentTime = thisTime;
            sessionID = entry.getKey();
        }
        if (sessionID != null) {
            this.currentSessionID = sessionID;
        }
    }

    private synchronized String getWorkerIdForIndex(String sessionId, int workerIdx) {
        StatsStorage ss;
        if (sessionId == null) {
            return null;
        }
        Map idxToId = this.workerIdxToName.computeIfAbsent(sessionId, k -> Collections.synchronizedMap(new HashMap()));
        if (idxToId.containsKey(workerIdx)) {
            return (String)idxToId.get(workerIdx);
        }
        AtomicInteger counter = this.workerIdxCount.get(sessionId);
        if (counter == null) {
            counter = new AtomicInteger(0);
            this.workerIdxCount.put(sessionId, counter);
        }
        if ((ss = this.knownSessionIDs.get(sessionId)) == null) {
            return null;
        }
        ArrayList allWorkerIds = new ArrayList(ss.listWorkerIDsForSessionAndType(sessionId, "StatsListener"));
        Collections.sort(allWorkerIds);
        for (String s : allWorkerIds) {
            if (idxToId.containsValue(s)) continue;
            idxToId.put(counter.getAndIncrement(), s);
        }
        return (String)idxToId.get(workerIdx);
    }

    private synchronized void sessionInfo(RoutingContext rc) {
        HashMap<String, Map<String, Object>> dataEachSession = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, StatsStorage> entry : this.knownSessionIDs.entrySet()) {
            String sid = entry.getKey();
            StatsStorage ss = entry.getValue();
            Map<String, Object> dataThisSession = TrainModule.sessionData(sid, ss);
            dataEachSession.put(sid, dataThisSession);
        }
        rc.response().putHeader("content-type", "application/json").end(TrainModule.asJson(dataEachSession));
    }

    private static Map<String, Object> sessionData(String sid, StatsStorage ss) {
        HashMap<String, Object> dataThisSession = new HashMap<String, Object>();
        List workerIDs = ss.listWorkerIDsForSessionAndType(sid, "StatsListener");
        int workerCount = workerIDs == null ? 0 : workerIDs.size();
        List staticInfo = ss.getAllStaticInfos(sid, "StatsListener");
        long initTime = Long.MAX_VALUE;
        if (staticInfo != null) {
            for (Persistable p : staticInfo) {
                initTime = Math.min(p.getTimeStamp(), initTime);
            }
        }
        long lastUpdateTime = Long.MIN_VALUE;
        List lastUpdatesAllWorkers = ss.getLatestUpdateAllWorkers(sid, "StatsListener");
        for (Persistable p : lastUpdatesAllWorkers) {
            lastUpdateTime = Math.max(lastUpdateTime, p.getTimeStamp());
        }
        dataThisSession.put("numWorkers", workerCount);
        dataThisSession.put("initTime", initTime == Long.MAX_VALUE ? "" : Long.valueOf(initTime));
        dataThisSession.put("lastUpdate", lastUpdateTime == Long.MIN_VALUE ? "" : Long.valueOf(lastUpdateTime));
        if (workerCount > 0) {
            dataThisSession.put("workers", workerIDs);
        }
        if (staticInfo != null && !staticInfo.isEmpty()) {
            StatsInitializationReport sr = (StatsInitializationReport)staticInfo.get(0);
            String modelClassName = sr.getModelClassName();
            if (modelClassName.endsWith("MultiLayerNetwork")) {
                modelClassName = "MultiLayerNetwork";
            } else if (modelClassName.endsWith("ComputationGraph")) {
                modelClassName = "ComputationGraph";
            }
            int numLayers = sr.getModelNumLayers();
            long numParams = sr.getModelNumParams();
            dataThisSession.put("modelType", modelClassName);
            dataThisSession.put("numLayers", numLayers);
            dataThisSession.put("numParams", numParams);
        } else {
            dataThisSession.put("modelType", "");
            dataThisSession.put("numLayers", "");
            dataThisSession.put("numParams", "");
        }
        return dataThisSession;
    }

    private synchronized void sessionInfoForSession(String sessionId, RoutingContext rc) {
        HashMap<String, Map<String, Object>> dataEachSession = new HashMap<String, Map<String, Object>>();
        StatsStorage ss = this.knownSessionIDs.get(sessionId);
        if (ss != null) {
            Map<String, Object> dataThisSession = TrainModule.sessionData(sessionId, ss);
            dataEachSession.put(sessionId, dataThisSession);
        }
        rc.response().putHeader("content-type", "application/json").end(TrainModule.asJson(dataEachSession));
    }

    private synchronized void setSession(String newSessionID, RoutingContext rc) {
        if (this.knownSessionIDs.containsKey(newSessionID)) {
            this.currentSessionID = newSessionID;
            this.currentWorkerIdx = 0;
            rc.response().end();
        } else {
            rc.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end();
        }
    }

    private void getLastUpdateForSession(String sessionID, RoutingContext rc) {
        Long lastUpdate = this.lastUpdateForSession.get(sessionID);
        if (lastUpdate != null) {
            rc.response().end(String.valueOf(lastUpdate));
            return;
        }
        rc.response().end("-1");
    }

    private void setWorkerByIdx(String newWorkerIdx, RoutingContext rc) {
        try {
            this.currentWorkerIdx = Integer.parseInt(newWorkerIdx);
        }
        catch (NumberFormatException e) {
            log.debug("Invalid call to setWorkerByIdx", (Throwable)e);
        }
        rc.response().end();
    }

    private static double fixNaN(double d) {
        return Double.isFinite(d) ? d : 0.0;
    }

    private static void cleanLegacyIterationCounts(List<Integer> iterationCounts) {
        if (!iterationCounts.isEmpty()) {
            int i;
            boolean allEqual = true;
            int maxStepSize = 1;
            int first = iterationCounts.get(0);
            int length = iterationCounts.size();
            int prevIterCount = first;
            for (i = 1; i < length; ++i) {
                int currIterCount = iterationCounts.get(i);
                if (allEqual && first != currIterCount) {
                    allEqual = false;
                }
                maxStepSize = Math.max(maxStepSize, prevIterCount - currIterCount);
                prevIterCount = currIterCount;
            }
            if (allEqual) {
                maxStepSize = 1;
            }
            for (i = 0; i < length; ++i) {
                iterationCounts.set(i, first + i * maxStepSize);
            }
        }
    }

    private Long getLastUpdateTime(String sessionId) {
        if (this.lastUpdateForSession != null && sessionId != null && this.lastUpdateForSession.containsKey(sessionId)) {
            return this.lastUpdateForSession.get(sessionId);
        }
        return -1L;
    }

    private I18N getI18N(String sessionId) {
        return VertxUIServer.getInstance().isMultiSession() ? I18NProvider.getInstance(sessionId) : I18NProvider.getInstance();
    }

    private void getOverviewData(RoutingContext rc) {
        this.getOverviewDataForSession(this.currentSessionID, rc);
    }

    private synchronized void getOverviewDataForSession(String sessionId, RoutingContext rc) {
        Persistable p;
        Persistable u;
        Long lastUpdateTime = this.getLastUpdateTime(sessionId);
        I18N i18N = this.getI18N(sessionId);
        StatsStorage ss = sessionId == null ? null : this.knownSessionIDs.get(sessionId);
        String wid = this.getWorkerIdForIndex(sessionId, this.currentWorkerIdx);
        boolean noData = sessionId == null || ss == null || wid == null;
        ArrayList<Integer> scoresIterCount = new ArrayList<Integer>();
        ArrayList<Double> scores = new ArrayList<Double>();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("updateTimestamp", lastUpdateTime);
        result.put("scores", scores);
        result.put("scoresIter", scoresIterCount);
        long[] allTimes = noData ? null : ss.getAllUpdateTimes(sessionId, "StatsListener", wid);
        List updates = null;
        if (allTimes != null && allTimes.length > this.maxChartPoints) {
            int i;
            int subsamplingFrequency = allTimes.length / this.maxChartPoints;
            LongArrayList timesToQuery = new LongArrayList(this.maxChartPoints + 2);
            for (i = 0; i < allTimes.length; i += subsamplingFrequency) {
                timesToQuery.add(allTimes[i]);
            }
            if (i - subsamplingFrequency != allTimes.length - 1) {
                timesToQuery.add(allTimes[allTimes.length - 1]);
            }
            updates = ss.getUpdates(sessionId, "StatsListener", wid, timesToQuery.toLongArray());
        } else if (allTimes != null) {
            updates = ss.getAllUpdatesAfter(sessionId, "StatsListener", wid, 0L);
        }
        if (updates == null || updates.isEmpty()) {
            noData = true;
        }
        HashMap updateRatios = new HashMap();
        result.put("updateRatios", updateRatios);
        HashMap stdevActivations = new HashMap();
        HashMap stdevGradients = new HashMap();
        HashMap stdevUpdates = new HashMap();
        result.put("stdevActivations", stdevActivations);
        result.put("stdevGradients", stdevGradients);
        result.put("stdevUpdates", stdevUpdates);
        if (!noData && (u = (Persistable)updates.get(0)) instanceof StatsReport) {
            Map stdAct;
            Map stdUpdate;
            Map stdGrad;
            StatsReport sp = (StatsReport)u;
            Map map = sp.getMeanMagnitudes(StatsType.Parameters);
            if (map != null) {
                for (Object s : map.keySet()) {
                    if (!((String)s).toLowerCase().endsWith("w")) continue;
                    updateRatios.put(s, new ArrayList());
                }
            }
            if ((stdGrad = sp.getStdev(StatsType.Gradients)) != null) {
                for (Object s : stdGrad.keySet()) {
                    if (!((String)s).toLowerCase().endsWith("w")) continue;
                    stdevGradients.put(s, new ArrayList());
                }
            }
            if ((stdUpdate = sp.getStdev(StatsType.Updates)) != null) {
                for (Object s : stdUpdate.keySet()) {
                    if (!((String)s).toLowerCase().endsWith("w")) continue;
                    stdevUpdates.put(s, new ArrayList());
                }
            }
            if ((stdAct = sp.getStdev(StatsType.Activations)) != null) {
                for (String s : stdAct.keySet()) {
                    stdevActivations.put(s, new ArrayList());
                }
            }
        }
        StatsReport last = null;
        int lastIterCount = -1;
        boolean needToHandleLegacyIterCounts = false;
        if (!noData) {
            int totalUpdates = updates.size();
            int subsamplingFrequency = 1;
            if (totalUpdates > this.maxChartPoints) {
                subsamplingFrequency = totalUpdates / this.maxChartPoints;
            }
            int pCount = -1;
            int lastUpdateIdx = updates.size() - 1;
            for (Persistable u2 : updates) {
                double d;
                ++pCount;
                if (!(u2 instanceof StatsReport)) continue;
                last = (StatsReport)u2;
                int iterCount = last.getIterationCount();
                if (iterCount <= lastIterCount) {
                    needToHandleLegacyIterCounts = true;
                }
                lastIterCount = iterCount;
                if (pCount > 0 && subsamplingFrequency > 1 && pCount % subsamplingFrequency != 0 && pCount != lastUpdateIdx) continue;
                scoresIterCount.add(iterCount);
                double lastScore = last.getScore();
                if (Double.isFinite(lastScore)) {
                    scores.add(lastScore);
                } else {
                    scores.add(0.0);
                }
                Map updateMM = last.getMeanMagnitudes(StatsType.Updates);
                Map paramMM = last.getMeanMagnitudes(StatsType.Parameters);
                if (updateMM != null && paramMM != null && updateMM.size() > 0 && paramMM.size() > 0) {
                    for (String s : updateRatios.keySet()) {
                        double currParam;
                        List ratioHistory = (List)updateRatios.get(s);
                        double currUpdate = updateMM.getOrDefault(s, 0.0);
                        double ratio = currUpdate / (currParam = paramMM.getOrDefault(s, 0.0).doubleValue());
                        if (Double.isFinite(ratio)) {
                            ratioHistory.add(ratio);
                            continue;
                        }
                        ratioHistory.add(0.0);
                    }
                }
                Map stdGrad = last.getStdev(StatsType.Gradients);
                Map stdUpd = last.getStdev(StatsType.Updates);
                Map stdAct = last.getStdev(StatsType.Activations);
                if (stdGrad != null) {
                    for (String s : stdevGradients.keySet()) {
                        d = stdGrad.getOrDefault(s, 0.0);
                        ((List)stdevGradients.get(s)).add(TrainModule.fixNaN(d));
                    }
                }
                if (stdUpd != null) {
                    for (String s : stdevUpdates.keySet()) {
                        d = stdUpd.getOrDefault(s, 0.0);
                        ((List)stdevUpdates.get(s)).add(TrainModule.fixNaN(d));
                    }
                }
                if (stdAct == null) continue;
                for (String s : stdevActivations.keySet()) {
                    d = stdAct.getOrDefault(s, 0.0);
                    ((List)stdevActivations.get(s)).add(TrainModule.fixNaN(d));
                }
            }
        }
        if (needToHandleLegacyIterCounts) {
            TrainModule.cleanLegacyIterationCounts(scoresIterCount);
        }
        String[][] perfInfo = new String[][]{{i18N.getMessage("train.overview.perftable.startTime"), ""}, {i18N.getMessage("train.overview.perftable.totalRuntime"), ""}, {i18N.getMessage("train.overview.perftable.lastUpdate"), ""}, {i18N.getMessage("train.overview.perftable.totalParamUpdates"), ""}, {i18N.getMessage("train.overview.perftable.updatesPerSec"), ""}, {i18N.getMessage("train.overview.perftable.examplesPerSec"), ""}};
        if (last != null) {
            perfInfo[2][1] = String.valueOf(dateFormat.format(new Date(last.getTimeStamp())));
            perfInfo[3][1] = String.valueOf(last.getTotalMinibatches());
            perfInfo[4][1] = String.valueOf(df2.format(last.getMinibatchesPerSecond()));
            perfInfo[5][1] = String.valueOf(df2.format(last.getExamplesPerSecond()));
        }
        result.put("perf", perfInfo);
        String[][] modelInfo = new String[][]{{i18N.getMessage("train.overview.modeltable.modeltype"), ""}, {i18N.getMessage("train.overview.modeltable.nLayers"), ""}, {i18N.getMessage("train.overview.modeltable.nParams"), ""}};
        if (!noData && (p = ss.getStaticInfo(sessionId, "StatsListener", wid)) != null) {
            String modelType;
            StatsInitializationReport initReport = (StatsInitializationReport)p;
            int nLayers = initReport.getModelNumLayers();
            long numParams = initReport.getModelNumParams();
            String className = initReport.getModelClassName();
            if (className.endsWith("MultiLayerNetwork")) {
                modelType = "MultiLayerNetwork";
            } else if (className.endsWith("ComputationGraph")) {
                modelType = "ComputationGraph";
            } else {
                modelType = className;
                if (modelType.lastIndexOf(46) > 0) {
                    modelType = modelType.substring(modelType.lastIndexOf(46) + 1);
                }
            }
            modelInfo[0][1] = modelType;
            modelInfo[1][1] = String.valueOf(nLayers);
            modelInfo[2][1] = String.valueOf(numParams);
        }
        result.put("model", modelInfo);
        String json = TrainModule.asJson(result);
        rc.response().putHeader("content-type", "application/json").end(json);
    }

    private void getModelGraph(RoutingContext rc) {
        this.getModelGraphForSession(this.currentSessionID, rc);
    }

    private void getModelGraphForSession(String sessionId, RoutingContext rc) {
        List allStatic;
        boolean noData = sessionId == null || !this.knownSessionIDs.containsKey(sessionId);
        StatsStorage ss = noData ? null : this.knownSessionIDs.get(sessionId);
        List list = allStatic = noData ? Collections.EMPTY_LIST : ss.getAllStaticInfos(sessionId, "StatsListener");
        if (allStatic.isEmpty()) {
            rc.response().end();
            return;
        }
        TrainModuleUtils.GraphInfo gi = this.getGraphInfo(this.getConfig(sessionId));
        if (gi == null) {
            rc.response().end();
            return;
        }
        String json = TrainModule.asJson(gi);
        rc.response().putHeader("content-type", "application/json").end(json);
    }

    private TrainModuleUtils.GraphInfo getGraphInfo(Triple<MultiLayerConfiguration, ComputationGraphConfiguration, NeuralNetConfiguration> conf) {
        if (conf == null) {
            return null;
        }
        if (conf.getFirst() != null) {
            return TrainModuleUtils.buildGraphInfo((MultiLayerConfiguration)conf.getFirst());
        }
        if (conf.getSecond() != null) {
            return TrainModuleUtils.buildGraphInfo((ComputationGraphConfiguration)conf.getSecond());
        }
        if (conf.getThird() != null) {
            return TrainModuleUtils.buildGraphInfo((NeuralNetConfiguration)conf.getThird());
        }
        return null;
    }

    private Triple<MultiLayerConfiguration, ComputationGraphConfiguration, NeuralNetConfiguration> getConfig(String sessionId) {
        List allStatic;
        boolean noData = sessionId == null || !this.knownSessionIDs.containsKey(sessionId);
        StatsStorage ss = noData ? null : this.knownSessionIDs.get(sessionId);
        List list = allStatic = noData ? Collections.EMPTY_LIST : ss.getAllStaticInfos(sessionId, "StatsListener");
        if (allStatic.isEmpty()) {
            return null;
        }
        StatsInitializationReport p = (StatsInitializationReport)allStatic.get(0);
        String modelClass = p.getModelClassName();
        String config = p.getModelConfigJson();
        if (modelClass.endsWith("MultiLayerNetwork")) {
            MultiLayerConfiguration conf = MultiLayerConfiguration.fromJson((String)config);
            return new Triple((Object)conf, null, null);
        }
        if (modelClass.endsWith("ComputationGraph")) {
            ComputationGraphConfiguration conf = ComputationGraphConfiguration.fromJson((String)config);
            return new Triple(null, (Object)conf, null);
        }
        try {
            NeuralNetConfiguration layer = (NeuralNetConfiguration)NeuralNetConfiguration.mapper().readValue(config, NeuralNetConfiguration.class);
            return new Triple(null, null, (Object)layer);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    private void getModelData(String layerId, RoutingContext rc) {
        this.getModelDataForSession(this.currentSessionID, layerId, rc);
    }

    private void getModelDataForSession(String sessionId, String layerId, RoutingContext rc) {
        Long lastUpdateTime = this.getLastUpdateTime(sessionId);
        int layerIdx = Integer.parseInt(layerId);
        I18N i18N = this.getI18N(sessionId);
        StatsStorage ss = sessionId == null ? null : this.knownSessionIDs.get(sessionId);
        String wid = this.getWorkerIdForIndex(sessionId, this.currentWorkerIdx);
        boolean noData = sessionId == null || ss == null || wid == null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("updateTimestamp", lastUpdateTime);
        Triple<MultiLayerConfiguration, ComputationGraphConfiguration, NeuralNetConfiguration> conf = this.getConfig(sessionId);
        if (conf == null) {
            rc.response().putHeader("content-type", "application/json").end(TrainModule.asJson(result));
            return;
        }
        TrainModuleUtils.GraphInfo gi = this.getGraphInfo(conf);
        if (gi == null) {
            rc.response().putHeader("content-type", "application/json").end(TrainModule.asJson(result));
            return;
        }
        String[][] layerInfoTable = TrainModule.getLayerInfoTable(sessionId, layerIdx, gi, i18N, noData, ss, wid);
        result.put("layerInfo", layerInfoTable);
        long[] allTimes = noData ? null : ss.getAllUpdateTimes(sessionId, "StatsListener", wid);
        List updates = null;
        ArrayList<Integer> iterationCounts = null;
        boolean needToHandleLegacyIterCounts = false;
        if (allTimes != null && allTimes.length > this.maxChartPoints) {
            int i;
            int subsamplingFrequency = allTimes.length / this.maxChartPoints;
            LongArrayList timesToQuery = new LongArrayList(this.maxChartPoints + 2);
            for (i = 0; i < allTimes.length; i += subsamplingFrequency) {
                timesToQuery.add(allTimes[i]);
            }
            if (i - subsamplingFrequency != allTimes.length - 1) {
                timesToQuery.add(allTimes[allTimes.length - 1]);
            }
            updates = ss.getUpdates(sessionId, "StatsListener", wid, timesToQuery.toLongArray());
        } else if (allTimes != null) {
            updates = ss.getAllUpdatesAfter(sessionId, "StatsListener", wid, 0L);
        }
        iterationCounts = new ArrayList<Integer>(updates.size());
        int lastIterCount = -1;
        for (Persistable p : updates) {
            if (!(p instanceof StatsReport)) continue;
            StatsReport sr = (StatsReport)p;
            int iterCount = sr.getIterationCount();
            if (iterCount <= lastIterCount) {
                needToHandleLegacyIterCounts = true;
            }
            iterationCounts.add(iterCount);
        }
        if (needToHandleLegacyIterCounts) {
            TrainModule.cleanLegacyIterationCounts(iterationCounts);
        }
        ModelType mt = conf.getFirst() != null ? ModelType.MLN : (conf.getSecond() != null ? ModelType.CG : ModelType.Layer);
        MeanMagnitudes mm = TrainModule.getLayerMeanMagnitudes(layerIdx, gi, updates, iterationCounts, mt);
        HashMap<String, Object> mmRatioMap = new HashMap<String, Object>();
        mmRatioMap.put("layerParamNames", mm.getRatios().keySet());
        mmRatioMap.put("iterCounts", mm.getIterations());
        mmRatioMap.put("ratios", mm.getRatios());
        mmRatioMap.put("paramMM", mm.getParamMM());
        mmRatioMap.put("updateMM", mm.getUpdateMM());
        result.put("meanMag", mmRatioMap);
        Triple<int[], float[], float[]> activationsData = TrainModule.getLayerActivations(layerIdx, gi, updates, iterationCounts);
        HashMap<String, Object> activationMap = new HashMap<String, Object>();
        activationMap.put("iterCount", activationsData.getFirst());
        activationMap.put("mean", activationsData.getSecond());
        activationMap.put("stdev", activationsData.getThird());
        result.put("activations", activationMap);
        Map<String, Object> lrs = TrainModule.getLayerLearningRates(layerIdx, gi, updates, iterationCounts, mt);
        result.put("learningRates", lrs);
        Persistable lastUpdate = updates != null && !updates.isEmpty() ? (Persistable)updates.get(updates.size() - 1) : null;
        Map<String, Object> paramHistograms = TrainModule.getHistograms(layerIdx, gi, StatsType.Parameters, lastUpdate);
        result.put("paramHist", paramHistograms);
        Map<String, Object> updateHistograms = TrainModule.getHistograms(layerIdx, gi, StatsType.Updates, lastUpdate);
        result.put("updateHist", updateHistograms);
        rc.response().putHeader("content-type", "application/json").end(TrainModule.asJson(result));
    }

    private void getSystemData(RoutingContext rc) {
        this.getSystemDataForSession(this.currentSessionID, rc);
    }

    private void getSystemDataForSession(String sessionId, RoutingContext rc) {
        Long lastUpdate = this.getLastUpdateTime(sessionId);
        I18N i18n = this.getI18N(sessionId);
        StatsStorage ss = sessionId == null ? null : this.knownSessionIDs.get(sessionId);
        boolean noData = ss == null;
        List allStatic = noData ? Collections.EMPTY_LIST : ss.getAllStaticInfos(sessionId, "StatsListener");
        List latestUpdates = noData ? Collections.EMPTY_LIST : ss.getLatestUpdateAllWorkers(sessionId, "StatsListener");
        long lastUpdateTime = -1L;
        if (latestUpdates == null || latestUpdates.isEmpty()) {
            noData = true;
        } else {
            for (Persistable p : latestUpdates) {
                lastUpdateTime = Math.max(lastUpdateTime, p.getTimeStamp());
            }
        }
        long fromTime = lastUpdateTime - 300000L;
        List lastNMinutes = noData ? null : ss.getAllUpdatesAfter(sessionId, "StatsListener", fromTime);
        Map<String, Object> mem = TrainModule.getMemory(allStatic, lastNMinutes, i18n);
        Pair<Map<String, Object>, Map<String, Object>> hwSwInfo = TrainModule.getHardwareSoftwareInfo(allStatic, i18n);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("updateTimestamp", lastUpdate);
        ret.put("memory", mem);
        ret.put("hardware", hwSwInfo.getFirst());
        ret.put("software", hwSwInfo.getSecond());
        rc.response().putHeader("content-type", "application/json").end(TrainModule.asJson(ret));
    }

    private static String getLayerType(Layer layer) {
        String layerType = "n/a";
        if (layer != null) {
            try {
                layerType = layer.getClass().getSimpleName().replaceAll("Layer$", "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return layerType;
    }

    private static String[][] getLayerInfoTable(String sessionId, int layerIdx, TrainModuleUtils.GraphInfo gi, I18N i18N, boolean noData, StatsStorage ss, String wid) {
        ArrayList<String[]> layerInfoRows;
        block15: {
            NeuralNetConfiguration nnc;
            Layer layer;
            String layerType;
            block17: {
                String modelClass;
                block18: {
                    String vertexName;
                    MultiLayerConfiguration conf;
                    block20: {
                        block19: {
                            String configJson;
                            block16: {
                                Persistable p;
                                layerInfoRows = new ArrayList<String[]>();
                                layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerName"), gi.getVertexNames().get(layerIdx)});
                                layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerType"), ""});
                                if (noData || (p = ss.getStaticInfo(sessionId, "StatsListener", wid)) == null) break block15;
                                StatsInitializationReport initReport = (StatsInitializationReport)p;
                                configJson = initReport.getModelConfigJson();
                                modelClass = initReport.getModelClassName();
                                layerType = "";
                                layer = null;
                                nnc = null;
                                if (!modelClass.endsWith("MultiLayerNetwork")) break block16;
                                conf = MultiLayerConfiguration.fromJson((String)configJson);
                                int confIdx = layerIdx - 1;
                                if (confIdx >= 0) {
                                    nnc = conf.getConf(confIdx);
                                    layer = nnc.getLayer();
                                } else {
                                    layerType = "Input";
                                }
                                break block17;
                            }
                            if (!modelClass.endsWith("ComputationGraph")) break block18;
                            conf = ComputationGraphConfiguration.fromJson((String)configJson);
                            vertexName = gi.getVertexNames().get(layerIdx);
                            Map vertices = conf.getVertices();
                            if (!vertices.containsKey(vertexName) || !(vertices.get(vertexName) instanceof LayerVertex)) break block19;
                            LayerVertex lv = (LayerVertex)vertices.get(vertexName);
                            nnc = lv.getLayerConf();
                            layer = nnc.getLayer();
                            break block17;
                        }
                        if (!conf.getNetworkInputs().contains(vertexName)) break block20;
                        layerType = "Input";
                        break block17;
                    }
                    GraphVertex gv = (GraphVertex)conf.getVertices().get(vertexName);
                    if (gv == null) break block17;
                    layerType = gv.getClass().getSimpleName();
                    break block17;
                }
                if (modelClass.endsWith("VariationalAutoencoder")) {
                    layerType = gi.getVertexTypes().get(layerIdx);
                    Map<String, String> map = gi.getVertexInfo().get(layerIdx);
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        layerInfoRows.add(new String[]{entry.getKey(), entry.getValue()});
                    }
                }
            }
            if (layer != null) {
                layerType = TrainModule.getLayerType(layer);
            }
            if (layer != null) {
                String activationFn = null;
                if (layer instanceof FeedForwardLayer) {
                    FeedForwardLayer ffl = (FeedForwardLayer)layer;
                    layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerNIn"), String.valueOf(ffl.getNIn())});
                    layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerSize"), String.valueOf(ffl.getNOut())});
                }
                if (layer instanceof BaseLayer) {
                    BaseLayer bl = (BaseLayer)layer;
                    activationFn = bl.getActivationFn().toString();
                    long nParams = layer.initializer().numParams(nnc);
                    layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerNParams"), String.valueOf(nParams)});
                    if (nParams > 0L) {
                        try {
                            String str = JsonMappers.getMapper().writeValueAsString((Object)bl.getWeightInitFn());
                            layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerWeightInit"), str});
                        }
                        catch (JsonProcessingException e) {
                            throw new RuntimeException(e);
                        }
                        IUpdater u = bl.getIUpdater();
                        String us = u == null ? "" : u.getClass().getSimpleName();
                        layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerUpdater"), us});
                    }
                }
                if (layer instanceof ConvolutionLayer || layer instanceof SubsamplingLayer) {
                    int[] padding;
                    int[] stride;
                    int[] kernel;
                    if (layer instanceof ConvolutionLayer) {
                        ConvolutionLayer cl = (ConvolutionLayer)layer;
                        kernel = cl.getKernelSize();
                        stride = cl.getStride();
                        padding = cl.getPadding();
                    } else {
                        SubsamplingLayer ssl = (SubsamplingLayer)layer;
                        kernel = ssl.getKernelSize();
                        stride = ssl.getStride();
                        padding = ssl.getPadding();
                        activationFn = null;
                        layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerSubsamplingPoolingType"), ssl.getPoolingType().toString()});
                    }
                    layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerCnnKernel"), Arrays.toString(kernel)});
                    layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerCnnStride"), Arrays.toString(stride)});
                    layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerCnnPadding"), Arrays.toString(padding)});
                }
                if (activationFn != null) {
                    layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerActivationFn"), activationFn});
                }
            }
            ((String[])layerInfoRows.get((int)1))[1] = layerType;
        }
        return (String[][])layerInfoRows.toArray((T[])new String[layerInfoRows.size()][0]);
    }

    private static MeanMagnitudes getLayerMeanMagnitudes(int layerIdx, TrainModuleUtils.GraphInfo gi, List<Persistable> updates, List<Integer> iterationCounts, ModelType modelType) {
        String layerType;
        if (gi == null) {
            return new MeanMagnitudes(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        }
        String layerName = gi.getVertexNames().get(layerIdx);
        if (modelType != ModelType.CG) {
            layerName = gi.getOriginalVertexName().get(layerIdx);
        }
        if ("input".equalsIgnoreCase(layerType = gi.getVertexTypes().get(layerIdx))) {
            return new MeanMagnitudes(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        }
        ArrayList<Integer> iterCounts = new ArrayList<Integer>();
        HashMap<String, List<Double>> ratioValues = new HashMap<String, List<Double>>();
        HashMap<String, List<Double>> outParamMM = new HashMap<String, List<Double>>();
        HashMap<String, List<Double>> outUpdateMM = new HashMap<String, List<Double>>();
        if (updates != null) {
            int pCount = -1;
            for (Persistable u : updates) {
                ++pCount;
                if (!(u instanceof StatsReport)) continue;
                StatsReport sp = (StatsReport)u;
                if (iterationCounts != null) {
                    iterCounts.add(iterationCounts.get(pCount));
                } else {
                    int iterCount = sp.getIterationCount();
                    iterCounts.add(iterCount);
                }
                Map paramMM = sp.getMeanMagnitudes(StatsType.Parameters);
                Map updateMM = sp.getMeanMagnitudes(StatsType.Updates);
                for (String s : paramMM.keySet()) {
                    Object prefix;
                    if (!s.startsWith((String)(prefix = modelType == ModelType.Layer ? layerName : layerName + "_"))) continue;
                    String layerParam = s.substring(((String)prefix).length());
                    double pmm = paramMM.getOrDefault(s, 0.0);
                    double umm = updateMM.getOrDefault(s, 0.0);
                    if (!Double.isFinite(pmm)) {
                        pmm = 0.0;
                    }
                    if (!Double.isFinite(umm)) {
                        umm = 0.0;
                    }
                    double ratio = umm == 0.0 && pmm == 0.0 ? 0.0 : umm / pmm;
                    ArrayList<Double> list = (ArrayList<Double>)ratioValues.get(layerParam);
                    if (list == null) {
                        list = new ArrayList<Double>();
                        ratioValues.put(layerParam, list);
                    }
                    list.add(ratio);
                    ArrayList<Double> pmmList = (ArrayList<Double>)outParamMM.get(layerParam);
                    if (pmmList == null) {
                        pmmList = new ArrayList<Double>();
                        outParamMM.put(layerParam, pmmList);
                    }
                    pmmList.add(pmm);
                    ArrayList<Double> ummList = (ArrayList<Double>)outUpdateMM.get(layerParam);
                    if (ummList == null) {
                        ummList = new ArrayList<Double>();
                        outUpdateMM.put(layerParam, ummList);
                    }
                    ummList.add(umm);
                }
            }
        }
        return new MeanMagnitudes(iterCounts, ratioValues, outParamMM, outUpdateMM);
    }

    private static Triple<int[], float[], float[]> getLayerActivations(int index, TrainModuleUtils.GraphInfo gi, List<Persistable> updates, List<Integer> iterationCounts) {
        if (gi == null) {
            return EMPTY_TRIPLE;
        }
        String type = gi.getVertexTypes().get(index);
        if ("input".equalsIgnoreCase(type)) {
            return EMPTY_TRIPLE;
        }
        List<String> origNames = gi.getOriginalVertexName();
        if (index < 0 || index >= origNames.size()) {
            return EMPTY_TRIPLE;
        }
        String layerName = origNames.get(index);
        int size = updates == null ? 0 : updates.size();
        int[] iterCounts = new int[size];
        float[] mean = new float[size];
        float[] stdev = new float[size];
        int used = 0;
        if (updates != null) {
            int uCount = -1;
            for (Persistable u : updates) {
                ++uCount;
                if (!(u instanceof StatsReport)) continue;
                StatsReport sp = (StatsReport)u;
                iterCounts[used] = iterationCounts == null ? sp.getIterationCount() : iterationCounts.get(uCount).intValue();
                Map means = sp.getMean(StatsType.Activations);
                Map stdevs = sp.getStdev(StatsType.Activations);
                if (means == null || !means.containsKey(layerName)) continue;
                mean[used] = ((Double)means.get(layerName)).floatValue();
                stdev[used] = ((Double)stdevs.get(layerName)).floatValue();
                if (!Float.isFinite(mean[used])) {
                    mean[used] = 0.0f;
                }
                if (!Float.isFinite(stdev[used])) {
                    stdev[used] = 0.0f;
                }
                ++used;
            }
        }
        if (used != iterCounts.length) {
            iterCounts = Arrays.copyOf(iterCounts, used);
            mean = Arrays.copyOf(mean, used);
            stdev = Arrays.copyOf(stdev, used);
        }
        return new Triple((Object)iterCounts, (Object)mean, (Object)stdev);
    }

    private static Map<String, Object> getLayerLearningRates(int layerIdx, TrainModuleUtils.GraphInfo gi, List<Persistable> updates, List<Integer> iterationCounts, ModelType modelType) {
        if (gi == null) {
            return Collections.emptyMap();
        }
        List<String> origNames = gi.getOriginalVertexName();
        String type = gi.getVertexTypes().get(layerIdx);
        if ("input".equalsIgnoreCase(type)) {
            return EMPTY_LR_MAP;
        }
        if (layerIdx < 0 || layerIdx >= origNames.size()) {
            return EMPTY_LR_MAP;
        }
        String layerName = gi.getOriginalVertexName().get(layerIdx);
        int size = updates == null ? 0 : updates.size();
        int[] iterCounts = new int[size];
        HashMap<String, float[]> byName = new HashMap<String, float[]>();
        int used = 0;
        if (updates != null) {
            int uCount = -1;
            for (Persistable u : updates) {
                ++uCount;
                if (!(u instanceof StatsReport)) continue;
                StatsReport sp = (StatsReport)u;
                iterCounts[used] = iterationCounts == null ? sp.getIterationCount() : iterationCounts.get(uCount).intValue();
                Map lrs = sp.getLearningRates();
                Object prefix = modelType == ModelType.Layer ? layerName : layerName + "_";
                for (String p : lrs.keySet()) {
                    if (!p.startsWith((String)prefix)) continue;
                    String layerParamName = p.substring(Math.min(p.length(), ((String)prefix).length()));
                    if (!byName.containsKey(layerParamName)) {
                        byName.put(layerParamName, new float[size]);
                    }
                    float[] lrThisParam = (float[])byName.get(layerParamName);
                    lrThisParam[used] = ((Double)lrs.get(p)).floatValue();
                }
                ++used;
            }
        }
        ArrayList paramNames = new ArrayList(byName.keySet());
        Collections.sort(paramNames);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("iterCounts", iterCounts);
        ret.put("paramNames", paramNames);
        ret.put("lrs", byName);
        return ret;
    }

    private static Map<String, Object> getHistograms(int layerIdx, TrainModuleUtils.GraphInfo gi, StatsType statsType, Persistable p) {
        if (p == null) {
            return null;
        }
        if (!(p instanceof StatsReport)) {
            return null;
        }
        StatsReport sr = (StatsReport)p;
        String layerName = gi.getOriginalVertexName().get(layerIdx);
        Map map = sr.getHistograms(statsType);
        ArrayList<String> paramNames = new ArrayList<String>();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (layerName != null) {
            for (String s : map.keySet()) {
                if (!s.startsWith(layerName)) continue;
                String paramName = s.charAt(layerName.length()) == '_' ? s.substring(layerName.length() + 1) : s.substring(layerName.length());
                paramNames.add(paramName);
                Histogram h = (Histogram)map.get(s);
                HashMap<String, Object> thisHist = new HashMap<String, Object>();
                double min = h.getMin();
                double max = h.getMax();
                if (Double.isNaN(min)) {
                    min = 0.0;
                    max = 0.0;
                }
                thisHist.put("min", min);
                thisHist.put("max", max);
                thisHist.put("bins", h.getNBins());
                thisHist.put("counts", h.getBinCounts());
                ret.put(paramName, thisHist);
            }
        }
        ret.put("paramNames", paramNames);
        return ret;
    }

    private static Map<String, Object> getMemory(List<Persistable> staticInfoAllWorkers, List<Persistable> updatesLastNMinutes, I18N i18n) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        HashSet<String> jvmIDs = new HashSet<String>();
        HashMap<String, String> workersToJvms = new HashMap<String, String>();
        HashMap<String, Integer> workerNumDevices = new HashMap<String, Integer>();
        HashMap<String, String[]> deviceNames = new HashMap<String, String[]>();
        for (Persistable p : staticInfoAllWorkers) {
            StatsInitializationReport init = (StatsInitializationReport)p;
            String jvmuid = init.getSwJvmUID();
            workersToJvms.put(p.getWorkerID(), jvmuid);
            jvmIDs.add(jvmuid);
            int nDevices = init.getHwNumDevices();
            workerNumDevices.put(p.getWorkerID(), nDevices);
            if (nDevices <= 0) continue;
            String[] deviceNamesArr = init.getHwDeviceDescription();
            deviceNames.put(p.getWorkerID(), deviceNamesArr);
        }
        ArrayList jvmList = new ArrayList(jvmIDs);
        Collections.sort(jvmList);
        int count = 0;
        for (String jvm : jvmList) {
            ArrayList<String> workersForJvm = new ArrayList<String>();
            for (String s : workersToJvms.keySet()) {
                if (!((String)workersToJvms.get(s)).equals(jvm)) continue;
                workersForJvm.add(s);
            }
            Collections.sort(workersForJvm);
            String wid = (String)workersForJvm.get(0);
            int numDevices = (Integer)workerNumDevices.get(wid);
            HashMap<String, Object> jvmData = new HashMap<String, Object>();
            ArrayList<Long> timestamps = new ArrayList<Long>();
            ArrayList<Float> fracJvm = new ArrayList<Float>();
            ArrayList<Float> fracOffHeap = new ArrayList<Float>();
            long[] lastBytes = new long[2 + numDevices];
            long[] lastMaxBytes = new long[2 + numDevices];
            ArrayList fracDeviceMem = null;
            if (numDevices > 0) {
                fracDeviceMem = new ArrayList(numDevices);
                for (int i = 0; i < numDevices; ++i) {
                    fracDeviceMem.add(new ArrayList());
                }
            }
            if (updatesLastNMinutes != null) {
                for (Persistable p : updatesLastNMinutes) {
                    if (!p.getWorkerID().equals(wid) || !(p instanceof StatsReport)) continue;
                    StatsReport sp = (StatsReport)p;
                    timestamps.add(sp.getTimeStamp());
                    long jvmCurrentBytes = sp.getJvmCurrentBytes();
                    long jvmMaxBytes = sp.getJvmMaxBytes();
                    long ohCurrentBytes = sp.getOffHeapCurrentBytes();
                    long ohMaxBytes = sp.getOffHeapMaxBytes();
                    double jvmFrac = (double)jvmCurrentBytes / (double)jvmMaxBytes;
                    double offheapFrac = (double)ohCurrentBytes / (double)ohMaxBytes;
                    if (Double.isNaN(jvmFrac)) {
                        jvmFrac = 0.0;
                    }
                    if (Double.isNaN(offheapFrac)) {
                        offheapFrac = 0.0;
                    }
                    fracJvm.add(Float.valueOf((float)jvmFrac));
                    fracOffHeap.add(Float.valueOf((float)offheapFrac));
                    lastBytes[0] = jvmCurrentBytes;
                    lastBytes[1] = ohCurrentBytes;
                    lastMaxBytes[0] = jvmMaxBytes;
                    lastMaxBytes[1] = ohMaxBytes;
                    if (numDevices <= 0) continue;
                    long[] devBytes = sp.getDeviceCurrentBytes();
                    long[] devMaxBytes = sp.getDeviceMaxBytes();
                    for (int i = 0; i < numDevices; ++i) {
                        double frac = (double)devBytes[i] / (double)devMaxBytes[i];
                        if (Double.isNaN(frac)) {
                            frac = 0.0;
                        }
                        ((List)fracDeviceMem.get(i)).add(Float.valueOf((float)frac));
                        lastBytes[2 + i] = devBytes[i];
                        lastMaxBytes[2 + i] = devMaxBytes[i];
                    }
                }
            }
            ArrayList<List> fracUtilized = new ArrayList<List>();
            fracUtilized.add(fracJvm);
            fracUtilized.add(fracOffHeap);
            String[] seriesNames = new String[2 + numDevices];
            seriesNames[0] = i18n.getMessage("train.system.hwTable.jvmCurrent");
            seriesNames[1] = i18n.getMessage("train.system.hwTable.offHeapCurrent");
            boolean[] isDevice = new boolean[2 + numDevices];
            String[] devNames = (String[])deviceNames.get(wid);
            for (int i = 0; i < numDevices; ++i) {
                seriesNames[2 + i] = devNames != null && devNames.length > i ? devNames[i] : "";
                fracUtilized.add((List)fracDeviceMem.get(i));
                isDevice[2 + i] = true;
            }
            jvmData.put("times", timestamps);
            jvmData.put("isDevice", isDevice);
            jvmData.put("seriesNames", seriesNames);
            jvmData.put("values", fracUtilized);
            jvmData.put("currentBytes", lastBytes);
            jvmData.put("maxBytes", lastMaxBytes);
            ret.put(String.valueOf(count), jvmData);
            ++count;
        }
        return ret;
    }

    private static Pair<Map<String, Object>, Map<String, Object>> getHardwareSoftwareInfo(List<Persistable> staticInfoAllWorkers, I18N i18n) {
        HashMap retHw = new HashMap();
        HashMap retSw = new HashMap();
        HashSet<String> jvmIDs = new HashSet<String>();
        HashMap<String, StatsInitializationReport> staticByJvm = new HashMap<String, StatsInitializationReport>();
        for (Persistable p : staticInfoAllWorkers) {
            StatsInitializationReport init = (StatsInitializationReport)p;
            String jvmuid = init.getSwJvmUID();
            jvmIDs.add(jvmuid);
            staticByJvm.put(jvmuid, init);
        }
        ArrayList jvmList = new ArrayList(jvmIDs);
        Collections.sort(jvmList);
        int count = 0;
        for (String jvm : jvmList) {
            String datatype;
            StatsInitializationReport sr = (StatsInitializationReport)staticByJvm.get(jvm);
            ArrayList<String[]> hwInfo = new ArrayList<String[]>();
            int numDevices = sr.getHwNumDevices();
            String[] deviceDescription = sr.getHwDeviceDescription();
            long[] devTotalMem = sr.getHwDeviceTotalMemory();
            hwInfo.add(new String[]{i18n.getMessage("train.system.hwTable.jvmMax"), String.valueOf(sr.getHwJvmMaxMemory())});
            hwInfo.add(new String[]{i18n.getMessage("train.system.hwTable.offHeapMax"), String.valueOf(sr.getHwOffHeapMaxMemory())});
            hwInfo.add(new String[]{i18n.getMessage("train.system.hwTable.jvmProcs"), String.valueOf(sr.getHwJvmAvailableProcessors())});
            hwInfo.add(new String[]{i18n.getMessage("train.system.hwTable.computeDevices"), String.valueOf(numDevices)});
            for (int i = 0; i < numDevices; ++i) {
                String label = i18n.getMessage("train.system.hwTable.deviceName") + " (" + i + ")";
                String name = deviceDescription == null || i >= deviceDescription.length ? String.valueOf(i) : deviceDescription[i];
                hwInfo.add(new String[]{label, name});
                String memLabel = i18n.getMessage("train.system.hwTable.deviceMemory") + " (" + i + ")";
                String memBytes = devTotalMem == null || i >= devTotalMem.length ? "-" : String.valueOf(devTotalMem[i]);
                hwInfo.add(new String[]{memLabel, memBytes});
            }
            retHw.put(String.valueOf(count), hwInfo);
            String nd4jBackend = sr.getSwNd4jBackendClass();
            if (nd4jBackend != null && nd4jBackend.contains(".")) {
                String temp;
                int idx = nd4jBackend.lastIndexOf(46);
                switch (nd4jBackend = nd4jBackend.substring(idx + 1)) {
                    case "CpuNDArrayFactory": {
                        temp = "CPU";
                        break;
                    }
                    case "JCublasNDArrayFactory": {
                        temp = "CUDA";
                        break;
                    }
                    default: {
                        temp = nd4jBackend;
                    }
                }
                nd4jBackend = temp;
            }
            datatype = (datatype = sr.getSwNd4jDataTypeName()) == null ? "" : datatype.toLowerCase();
            ArrayList<String[]> swInfo = new ArrayList<String[]>();
            swInfo.add(new String[]{i18n.getMessage("train.system.swTable.os"), sr.getSwOsName()});
            swInfo.add(new String[]{i18n.getMessage("train.system.swTable.hostname"), sr.getSwHostName()});
            swInfo.add(new String[]{i18n.getMessage("train.system.swTable.osArch"), sr.getSwArch()});
            swInfo.add(new String[]{i18n.getMessage("train.system.swTable.jvmName"), sr.getSwJvmName()});
            swInfo.add(new String[]{i18n.getMessage("train.system.swTable.jvmVersion"), sr.getSwJvmVersion()});
            swInfo.add(new String[]{i18n.getMessage("train.system.swTable.nd4jBackend"), nd4jBackend});
            swInfo.add(new String[]{i18n.getMessage("train.system.swTable.nd4jDataType"), datatype});
            retSw.put(String.valueOf(count), swInfo);
            ++count;
        }
        return new Pair(retHw, retSw);
    }

    private static final String asJson(Object o) {
        try {
            return JsonMappers.getMapper().writeValueAsString(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<I18NResource> getInternationalizationResources() {
        ArrayList<I18NResource> files = new ArrayList<I18NResource>();
        String[] langs = new String[]{"de", "en", "ja", "ko", "ru", "zh"};
        TrainModule.addAll(files, "train", langs);
        TrainModule.addAll(files, "train.model", langs);
        TrainModule.addAll(files, "train.overview", langs);
        TrainModule.addAll(files, "train.system", langs);
        return files;
    }

    private static void addAll(List<I18NResource> to, String prefix, String ... suffixes) {
        for (String s : suffixes) {
            to.add(new I18NResource("dl4j_i18n/" + prefix + "." + s));
        }
    }

    static {
        EMPTY_LR_MAP.put("iterCounts", new int[0]);
        EMPTY_LR_MAP.put("paramNames", Collections.EMPTY_LIST);
        EMPTY_LR_MAP.put("lrs", Collections.EMPTY_MAP);
    }

    private static class MeanMagnitudes {
        private List<Integer> iterations;
        private Map<String, List<Double>> ratios;
        private Map<String, List<Double>> paramMM;
        private Map<String, List<Double>> updateMM;

        public MeanMagnitudes(List<Integer> iterations, Map<String, List<Double>> ratios, Map<String, List<Double>> paramMM, Map<String, List<Double>> updateMM) {
            this.iterations = iterations;
            this.ratios = ratios;
            this.paramMM = paramMM;
            this.updateMM = updateMM;
        }

        public List<Integer> getIterations() {
            return this.iterations;
        }

        public Map<String, List<Double>> getRatios() {
            return this.ratios;
        }

        public Map<String, List<Double>> getParamMM() {
            return this.paramMM;
        }

        public Map<String, List<Double>> getUpdateMM() {
            return this.updateMM;
        }

        public void setIterations(List<Integer> iterations) {
            this.iterations = iterations;
        }

        public void setRatios(Map<String, List<Double>> ratios) {
            this.ratios = ratios;
        }

        public void setParamMM(Map<String, List<Double>> paramMM) {
            this.paramMM = paramMM;
        }

        public void setUpdateMM(Map<String, List<Double>> updateMM) {
            this.updateMM = updateMM;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MeanMagnitudes)) {
                return false;
            }
            MeanMagnitudes other = (MeanMagnitudes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Integer> this$iterations = this.getIterations();
            List<Integer> other$iterations = other.getIterations();
            if (this$iterations == null ? other$iterations != null : !((Object)this$iterations).equals(other$iterations)) {
                return false;
            }
            Map<String, List<Double>> this$ratios = this.getRatios();
            Map<String, List<Double>> other$ratios = other.getRatios();
            if (this$ratios == null ? other$ratios != null : !((Object)this$ratios).equals(other$ratios)) {
                return false;
            }
            Map<String, List<Double>> this$paramMM = this.getParamMM();
            Map<String, List<Double>> other$paramMM = other.getParamMM();
            if (this$paramMM == null ? other$paramMM != null : !((Object)this$paramMM).equals(other$paramMM)) {
                return false;
            }
            Map<String, List<Double>> this$updateMM = this.getUpdateMM();
            Map<String, List<Double>> other$updateMM = other.getUpdateMM();
            return !(this$updateMM == null ? other$updateMM != null : !((Object)this$updateMM).equals(other$updateMM));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MeanMagnitudes;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Integer> $iterations = this.getIterations();
            result = result * 59 + ($iterations == null ? 43 : ((Object)$iterations).hashCode());
            Map<String, List<Double>> $ratios = this.getRatios();
            result = result * 59 + ($ratios == null ? 43 : ((Object)$ratios).hashCode());
            Map<String, List<Double>> $paramMM = this.getParamMM();
            result = result * 59 + ($paramMM == null ? 43 : ((Object)$paramMM).hashCode());
            Map<String, List<Double>> $updateMM = this.getUpdateMM();
            result = result * 59 + ($updateMM == null ? 43 : ((Object)$updateMM).hashCode());
            return result;
        }

        public String toString() {
            return "TrainModule.MeanMagnitudes(iterations=" + this.getIterations() + ", ratios=" + this.getRatios() + ", paramMM=" + this.getParamMM() + ", updateMM=" + this.getUpdateMM() + ")";
        }
    }

    private static enum ModelType {
        MLN,
        CG,
        Layer;

    }
}

