/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.loader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import org.nd4j.api.loader.Loader;
import org.nd4j.api.loader.Source;
import org.nd4j.api.loader.SourceFactory;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.util.MathUtils;

public class DataSetLoaderIterator
implements DataSetIterator {
    protected final List<String> paths;
    protected final Iterator<String> iter;
    protected final SourceFactory sourceFactory;
    protected final Loader<org.nd4j.linalg.dataset.DataSet> loader;
    protected final Random rng;
    protected final int[] order;
    protected int position;
    protected DataSetPreProcessor preProcessor;

    public DataSetLoaderIterator(Iterator<String> paths, Loader<org.nd4j.linalg.dataset.DataSet> loader, SourceFactory sourceFactory) {
        this.paths = null;
        this.iter = paths;
        this.loader = loader;
        this.sourceFactory = sourceFactory;
        this.rng = null;
        this.order = null;
    }

    public DataSetLoaderIterator(Collection<String> paths, Loader<org.nd4j.linalg.dataset.DataSet> loader, SourceFactory sourceFactory) {
        this(paths, null, loader, sourceFactory);
    }

    public DataSetLoaderIterator(Collection<String> paths, Random rng, Loader<org.nd4j.linalg.dataset.DataSet> loader, SourceFactory sourceFactory) {
        this.paths = paths instanceof List ? (List<Object>)paths : new ArrayList<String>(paths);
        this.rng = rng;
        this.loader = loader;
        this.sourceFactory = sourceFactory;
        this.iter = null;
        if (rng != null) {
            this.order = new int[paths.size()];
            for (int i = 0; i < this.order.length; ++i) {
                this.order[i] = i;
            }
            MathUtils.shuffleArray((int[])this.order, (Random)rng);
        } else {
            this.order = null;
        }
    }

    public org.nd4j.linalg.dataset.DataSet next(int i) {
        throw new UnsupportedOperationException("Not supported");
    }

    public int inputColumns() {
        throw new UnsupportedOperationException("Not supported");
    }

    public int totalOutcomes() {
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean resetSupported() {
        return this.paths != null;
    }

    public boolean asyncSupported() {
        return true;
    }

    public void reset() {
        if (!this.resetSupported()) {
            throw new UnsupportedOperationException("Reset not supported when using Iterator<String> instead of Iterable<String>");
        }
        this.position = 0;
        if (this.rng != null) {
            MathUtils.shuffleArray((int[])this.order, (Random)this.rng);
        }
    }

    public int batch() {
        throw new UnsupportedOperationException("Not supported");
    }

    public List<String> getLabels() {
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean hasNext() {
        if (this.iter != null) {
            return this.iter.hasNext();
        }
        return this.position < this.paths.size();
    }

    public org.nd4j.linalg.dataset.DataSet next() {
        org.nd4j.linalg.dataset.DataSet ds;
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        String path = this.iter != null ? this.iter.next() : (this.order != null ? this.paths.get(this.order[this.position++]) : this.paths.get(this.position++));
        Source s = this.sourceFactory.getSource(path);
        try {
            ds = (org.nd4j.linalg.dataset.DataSet)this.loader.load(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((DataSet)ds);
        }
        return ds;
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public Iterator<String> getIter() {
        return this.iter;
    }

    public SourceFactory getSourceFactory() {
        return this.sourceFactory;
    }

    public Loader<org.nd4j.linalg.dataset.DataSet> getLoader() {
        return this.loader;
    }

    public Random getRng() {
        return this.rng;
    }

    public int[] getOrder() {
        return this.order;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSetLoaderIterator)) {
            return false;
        }
        DataSetLoaderIterator other = (DataSetLoaderIterator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$paths = this.getPaths();
        List<String> other$paths = other.getPaths();
        if (this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths)) {
            return false;
        }
        Iterator<String> this$iter = this.getIter();
        Iterator<String> other$iter = other.getIter();
        if (this$iter == null ? other$iter != null : !this$iter.equals(other$iter)) {
            return false;
        }
        SourceFactory this$sourceFactory = this.getSourceFactory();
        SourceFactory other$sourceFactory = other.getSourceFactory();
        if (this$sourceFactory == null ? other$sourceFactory != null : !this$sourceFactory.equals(other$sourceFactory)) {
            return false;
        }
        Loader<org.nd4j.linalg.dataset.DataSet> this$loader = this.getLoader();
        Loader<org.nd4j.linalg.dataset.DataSet> other$loader = other.getLoader();
        if (this$loader == null ? other$loader != null : !this$loader.equals(other$loader)) {
            return false;
        }
        Random this$rng = this.getRng();
        Random other$rng = other.getRng();
        if (this$rng == null ? other$rng != null : !this$rng.equals(other$rng)) {
            return false;
        }
        if (!Arrays.equals(this.getOrder(), other.getOrder())) {
            return false;
        }
        if (this.getPosition() != other.getPosition()) {
            return false;
        }
        DataSetPreProcessor this$preProcessor = this.getPreProcessor();
        DataSetPreProcessor other$preProcessor = other.getPreProcessor();
        return !(this$preProcessor == null ? other$preProcessor != null : !this$preProcessor.equals(other$preProcessor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSetLoaderIterator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        Iterator<String> $iter = this.getIter();
        result = result * 59 + ($iter == null ? 43 : $iter.hashCode());
        SourceFactory $sourceFactory = this.getSourceFactory();
        result = result * 59 + ($sourceFactory == null ? 43 : $sourceFactory.hashCode());
        Loader<org.nd4j.linalg.dataset.DataSet> $loader = this.getLoader();
        result = result * 59 + ($loader == null ? 43 : $loader.hashCode());
        Random $rng = this.getRng();
        result = result * 59 + ($rng == null ? 43 : $rng.hashCode());
        result = result * 59 + Arrays.hashCode(this.getOrder());
        result = result * 59 + this.getPosition();
        DataSetPreProcessor $preProcessor = this.getPreProcessor();
        result = result * 59 + ($preProcessor == null ? 43 : $preProcessor.hashCode());
        return result;
    }

    public String toString() {
        return "DataSetLoaderIterator(paths=" + this.getPaths() + ", iter=" + this.getIter() + ", sourceFactory=" + this.getSourceFactory() + ", loader=" + this.getLoader() + ", rng=" + this.getRng() + ", order=" + Arrays.toString(this.getOrder()) + ", position=" + this.getPosition() + ", preProcessor=" + this.getPreProcessor() + ")";
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }
}

