/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;

public class EarlyTerminationMultiDataSetIterator
implements MultiDataSetIterator {
    private MultiDataSetIterator underlyingIterator;
    private int terminationPoint;
    private int minibatchCount = 0;

    public EarlyTerminationMultiDataSetIterator(MultiDataSetIterator underlyingIterator, int terminationPoint) {
        if (terminationPoint <= 0) {
            throw new IllegalArgumentException("Termination point (the number of calls to .next() or .next(num)) has to be > 0");
        }
        this.underlyingIterator = underlyingIterator;
        this.terminationPoint = terminationPoint;
    }

    public MultiDataSet next(int num) {
        if (this.minibatchCount < this.terminationPoint) {
            ++this.minibatchCount;
            return this.underlyingIterator.next(num);
        }
        throw new RuntimeException("Calls to next have exceeded termination point.");
    }

    public void setPreProcessor(MultiDataSetPreProcessor preProcessor) {
        this.underlyingIterator.setPreProcessor(preProcessor);
    }

    public MultiDataSetPreProcessor getPreProcessor() {
        return this.underlyingIterator.getPreProcessor();
    }

    public boolean resetSupported() {
        return this.underlyingIterator.resetSupported();
    }

    public boolean asyncSupported() {
        return this.underlyingIterator.asyncSupported();
    }

    public void reset() {
        this.minibatchCount = 0;
        this.underlyingIterator.reset();
    }

    public boolean hasNext() {
        return this.underlyingIterator.hasNext() && this.minibatchCount < this.terminationPoint;
    }

    public MultiDataSet next() {
        if (this.minibatchCount < this.terminationPoint) {
            ++this.minibatchCount;
            return (MultiDataSet)this.underlyingIterator.next();
        }
        throw new RuntimeException("Calls to next have exceeded the allotted number of minibatches.");
    }

    public void remove() {
        this.underlyingIterator.remove();
    }
}

