/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.rl;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.deeplearning4j.ui.UiConnectionInfo;
import org.deeplearning4j.ui.providers.ObjectMapperProvider;
import org.deeplearning4j.ui.rl.beans.ReportBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReinforcedReporter {
    private static Logger log = LoggerFactory.getLogger(ReinforcedReporter.class);
    private final UiConnectionInfo connectionInfo;
    private Client client = (Client)((Client)ClientBuilder.newClient().register(JacksonJsonProvider.class)).register((Object)new ObjectMapperProvider());
    private WebTarget target;

    public ReinforcedReporter(UiConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        this.target = this.client.target(connectionInfo.getFirstPart()).path(connectionInfo.getSecondPart("rl")).path("state").queryParam("sid", new Object[]{connectionInfo.getSessionId()});
    }

    public void report(long epochId, double reward) {
        ReportBean bean = new ReportBean(epochId, reward);
        Response resp = this.target.request(new String[]{"application/json"}).accept(new String[]{"application/json"}).post(Entity.entity((Object)bean, (String)"application/json"));
        log.debug("Response: " + resp);
    }
}

