/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.weights;

import com.codahale.metrics.annotation.ExceptionMetered;
import java.util.Collections;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.deeplearning4j.ui.storage.SessionStorage;
import org.deeplearning4j.ui.storage.def.ObjectType;
import org.deeplearning4j.ui.weights.beans.CompactModelAndGradient;

@Path(value="/weights")
public class WeightResource {
    String path = "weights";
    private SessionStorage storage = SessionStorage.getInstance();

    @GET
    @Path(value="/updated")
    @Produces(value={"application/json"})
    public Response updated(@QueryParam(value="sid") String sessionId) {
        CompactModelAndGradient model = (CompactModelAndGradient)this.storage.getObject(sessionId, ObjectType.HISTOGRAM);
        if (model == null) {
            return Response.noContent().build();
        }
        return Response.ok(Collections.singletonMap("status", true)).build();
    }

    @GET
    @Path(value="/data")
    @Produces(value={"application/json"})
    public Response data(@QueryParam(value="sid") String sessionId) {
        CompactModelAndGradient model = (CompactModelAndGradient)this.storage.getObject(sessionId, ObjectType.HISTOGRAM);
        if (model == null) {
            return Response.ok(new HashMap()).build();
        }
        return Response.ok((Object)model).build();
    }

    @POST
    @Path(value="/update")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ExceptionMetered
    public Response update(CompactModelAndGradient modelAndGrad, @PathParam(value="path") String path, @QueryParam(value="sid") String sessionId) {
        this.storage.putObject(sessionId, ObjectType.HISTOGRAM, modelAndGrad);
        return Response.ok(Collections.singletonMap("status", "ok")).build();
    }
}

