/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.tsne;

import io.dropwizard.views.View;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.ui.tsne.TsneView;
import org.deeplearning4j.ui.uploads.FileResource;

@Path(value="/tsne")
@Produces(value={"text/html"})
public class TsneResource
extends FileResource {
    private List<VocabWord> words;
    private VocabCache vocab;

    public TsneResource(String filePath) {
        super(filePath);
    }

    @GET
    public View get() {
        return new TsneView();
    }

    @POST
    @Path(value="/vocab")
    @Produces(value={"application/json"})
    public Response getVocab() {
        ArrayList<String> words = new ArrayList<String>();
        for (VocabWord word : this.words) {
            words.add(word.getWord());
        }
        return Response.ok(new ArrayList(words)).build();
    }

    @Override
    public void handleUpload(File path) {
    }
}

