/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.nearestneighbors;

import io.dropwizard.views.View;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.clustering.sptree.DataPoint;
import org.deeplearning4j.clustering.vptree.VPTree;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.embeddings.loader.WordVectorSerializer;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectors;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.ui.nearestneighbors.NearestNeighborsQuery;
import org.deeplearning4j.ui.nearestneighbors.NearestNeighborsView;
import org.deeplearning4j.ui.uploads.FileResource;
import org.deeplearning4j.util.SerializationUtils;

@Path(value="/nearestneighbors")
public class NearestNeighborsResource
extends FileResource {
    private VPTree tree;
    private List<VocabWord> words;
    private Map<Integer, VocabWord> theVocab;
    private VocabCache vocab;

    public NearestNeighborsResource(String filePath) {
        super(filePath);
    }

    @GET
    public View get() {
        return new NearestNeighborsView();
    }

    @POST
    @Path(value="/vocab")
    @Produces(value={"application/json"})
    public Response getVocab() {
        ArrayList<String> words = new ArrayList<String>();
        for (VocabWord word : this.words) {
            words.add(word.getWord());
        }
        return Response.ok(new ArrayList(words)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/words")
    public Response getWords(NearestNeighborsQuery query) {
        ArrayList results = new ArrayList();
        ArrayList distances = new ArrayList();
        this.tree.search((DataPoint)this.tree.getItems().get(this.vocab.indexOf(query.getWord())), query.getNumWords(), results, distances);
        HashMap map = new HashMap();
        for (int i = 0; i < results.size(); ++i) {
            map.put(this.theVocab.get(((DataPoint)results.get(i)).getIndex()).getWord(), distances.get(i));
        }
        return Response.ok(map).build();
    }

    @Override
    public void handleUpload(File path) {
        try {
            if (path.getAbsolutePath().endsWith(".ser")) {
                WordVectors vectors = (WordVectors)SerializationUtils.readObject((File)path);
                InMemoryLookupTable table = (InMemoryLookupTable)vectors.lookupTable();
                this.tree = new VPTree(table.getSyn0(), "dot", true);
                this.words = new ArrayList<VocabWord>(vectors.vocab().vocabWords());
                this.theVocab = new HashMap<Integer, VocabWord>();
                for (VocabWord word : this.words) {
                    this.theVocab.put(word.getIndex(), word);
                }
                this.vocab = vectors.vocab();
            } else {
                Pair vocab = WordVectorSerializer.loadTxt((File)path);
                InMemoryLookupTable table = (InMemoryLookupTable)vocab.getFirst();
                table.getSyn0().divi(table.getSyn0().norm2(Integer.MAX_VALUE));
                this.tree = new VPTree(table.getSyn0(), "dot", true);
                this.words = new ArrayList<VocabWord>(((VocabCache)vocab.getSecond()).vocabWords());
                this.theVocab = new HashMap<Integer, VocabWord>();
                for (VocabWord word : this.words) {
                    this.theVocab.put(word.getIndex(), word);
                }
                this.vocab = (VocabCache)vocab.getSecond();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

