/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.model.storage.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.compress.utils.IOUtils;
import org.deeplearning4j.core.storage.StorageMetaData;
import org.deeplearning4j.ui.model.stats.impl.SbeUtil;

public class JavaStorageMetaData
implements StorageMetaData {
    private long timeStamp;
    private String sessionID;
    private String typeID;
    private String workerID;
    private String initTypeClass;
    private String updateTypeClass;
    private byte[] extraMeta;

    public JavaStorageMetaData() {
    }

    public JavaStorageMetaData(long timeStamp, String sessionID, String typeID, String workerID, Class<?> initType, Class<?> updateType) {
        this(timeStamp, sessionID, typeID, workerID, initType != null ? initType.getName() : null, updateType != null ? updateType.getName() : null);
    }

    public JavaStorageMetaData(long timeStamp, String sessionID, String typeID, String workerID, String initTypeClass, String updateTypeClass) {
        this(timeStamp, sessionID, typeID, workerID, initTypeClass, updateTypeClass, null);
    }

    public JavaStorageMetaData(long timeStamp, String sessionID, String typeID, String workerID, String initTypeClass, String updateTypeClass, Serializable extraMetaData) {
        this.timeStamp = timeStamp;
        this.sessionID = sessionID;
        this.typeID = typeID;
        this.workerID = workerID;
        this.initTypeClass = initTypeClass;
        this.updateTypeClass = updateTypeClass;
        this.extraMeta = extraMetaData == null ? null : SbeUtil.toBytesSerializable(extraMetaData);
    }

    public int encodingLengthBytes() {
        byte[] encoded = this.encode();
        return encoded.length;
    }

    public byte[] encode() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public void encode(ByteBuffer buffer) {
        buffer.put(this.encode());
    }

    public void encode(OutputStream outputStream) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(outputStream);){
            oos.writeObject(this);
        }
    }

    public void decode(byte[] decode) {
        Field[] fields;
        JavaStorageMetaData r;
        try {
            Field[] fieldArray = null;
            try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(decode));){
                r = (JavaStorageMetaData)ois.readObject();
            }
            catch (Throwable object) {
                fieldArray = object;
                throw object;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        for (Field f : fields = JavaStorageMetaData.class.getDeclaredFields()) {
            f.setAccessible(true);
            try {
                f.set(this, f.get(r));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void decode(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        this.decode(bytes);
    }

    public void decode(InputStream inputStream) throws IOException {
        this.decode(IOUtils.toByteArray((InputStream)inputStream));
    }

    public Serializable getExtraMetaData() {
        return null;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getTypeID() {
        return this.typeID;
    }

    public String getWorkerID() {
        return this.workerID;
    }

    public String getInitTypeClass() {
        return this.initTypeClass;
    }

    public String getUpdateTypeClass() {
        return this.updateTypeClass;
    }

    public byte[] getExtraMeta() {
        return this.extraMeta;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public void setTypeID(String typeID) {
        this.typeID = typeID;
    }

    public void setWorkerID(String workerID) {
        this.workerID = workerID;
    }

    public void setInitTypeClass(String initTypeClass) {
        this.initTypeClass = initTypeClass;
    }

    public void setUpdateTypeClass(String updateTypeClass) {
        this.updateTypeClass = updateTypeClass;
    }

    public void setExtraMeta(byte[] extraMeta) {
        this.extraMeta = extraMeta;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaStorageMetaData)) {
            return false;
        }
        JavaStorageMetaData other = (JavaStorageMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        String this$sessionID = this.getSessionID();
        String other$sessionID = other.getSessionID();
        if (this$sessionID == null ? other$sessionID != null : !this$sessionID.equals(other$sessionID)) {
            return false;
        }
        String this$typeID = this.getTypeID();
        String other$typeID = other.getTypeID();
        if (this$typeID == null ? other$typeID != null : !this$typeID.equals(other$typeID)) {
            return false;
        }
        String this$workerID = this.getWorkerID();
        String other$workerID = other.getWorkerID();
        if (this$workerID == null ? other$workerID != null : !this$workerID.equals(other$workerID)) {
            return false;
        }
        String this$initTypeClass = this.getInitTypeClass();
        String other$initTypeClass = other.getInitTypeClass();
        if (this$initTypeClass == null ? other$initTypeClass != null : !this$initTypeClass.equals(other$initTypeClass)) {
            return false;
        }
        String this$updateTypeClass = this.getUpdateTypeClass();
        String other$updateTypeClass = other.getUpdateTypeClass();
        if (this$updateTypeClass == null ? other$updateTypeClass != null : !this$updateTypeClass.equals(other$updateTypeClass)) {
            return false;
        }
        return Arrays.equals(this.getExtraMeta(), other.getExtraMeta());
    }

    protected boolean canEqual(Object other) {
        return other instanceof JavaStorageMetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        String $sessionID = this.getSessionID();
        result = result * 59 + ($sessionID == null ? 43 : $sessionID.hashCode());
        String $typeID = this.getTypeID();
        result = result * 59 + ($typeID == null ? 43 : $typeID.hashCode());
        String $workerID = this.getWorkerID();
        result = result * 59 + ($workerID == null ? 43 : $workerID.hashCode());
        String $initTypeClass = this.getInitTypeClass();
        result = result * 59 + ($initTypeClass == null ? 43 : $initTypeClass.hashCode());
        String $updateTypeClass = this.getUpdateTypeClass();
        result = result * 59 + ($updateTypeClass == null ? 43 : $updateTypeClass.hashCode());
        result = result * 59 + Arrays.hashCode(this.getExtraMeta());
        return result;
    }

    public String toString() {
        return "JavaStorageMetaData(timeStamp=" + this.getTimeStamp() + ", sessionID=" + this.getSessionID() + ", typeID=" + this.getTypeID() + ", workerID=" + this.getWorkerID() + ", initTypeClass=" + this.getInitTypeClass() + ", updateTypeClass=" + this.getUpdateTypeClass() + ", extraMeta=" + Arrays.toString(this.getExtraMeta()) + ")";
    }
}

