/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.flow.data;

import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.compress.utils.IOUtils;
import org.deeplearning4j.api.storage.Persistable;
import org.deeplearning4j.ui.flow.beans.ModelState;

public class FlowUpdatePersistable
implements Persistable {
    public static final String TYPE_ID = "FlowListener";
    private String sessionID;
    private String workerID;
    private long timestamp;
    private ModelState modelState;

    public String getSessionID() {
        return this.sessionID;
    }

    public String getTypeID() {
        return TYPE_ID;
    }

    public String getWorkerID() {
        return this.workerID;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public int encodingLengthBytes() {
        return 0;
    }

    public byte[] encode() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public void encode(ByteBuffer buffer) {
        buffer.put(this.encode());
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encode());
    }

    public void decode(byte[] decode) {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(decode));){
            FlowUpdatePersistable p = (FlowUpdatePersistable)ois.readObject();
            this.sessionID = p.sessionID;
            this.workerID = p.workerID;
            this.timestamp = p.getTimeStamp();
            this.modelState = p.modelState;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void decode(ByteBuffer buffer) {
        byte[] arr = new byte[buffer.remaining()];
        buffer.get(arr);
        this.decode(arr);
    }

    public void decode(InputStream inputStream) throws IOException {
        byte[] b = IOUtils.toByteArray((InputStream)inputStream);
        this.decode(b);
    }

    @ConstructorProperties(value={"sessionID", "workerID", "timestamp", "modelState"})
    public FlowUpdatePersistable(String sessionID, String workerID, long timestamp, ModelState modelState) {
        this.sessionID = sessionID;
        this.workerID = workerID;
        this.timestamp = timestamp;
        this.modelState = modelState;
    }

    public FlowUpdatePersistable() {
    }

    public ModelState getModelState() {
        return this.modelState;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public void setWorkerID(String workerID) {
        this.workerID = workerID;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setModelState(ModelState modelState) {
        this.modelState = modelState;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowUpdatePersistable)) {
            return false;
        }
        FlowUpdatePersistable other = (FlowUpdatePersistable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sessionID = this.getSessionID();
        String other$sessionID = other.getSessionID();
        if (this$sessionID == null ? other$sessionID != null : !this$sessionID.equals(other$sessionID)) {
            return false;
        }
        String this$workerID = this.getWorkerID();
        String other$workerID = other.getWorkerID();
        if (this$workerID == null ? other$workerID != null : !this$workerID.equals(other$workerID)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        ModelState this$modelState = this.getModelState();
        ModelState other$modelState = other.getModelState();
        return !(this$modelState == null ? other$modelState != null : !((Object)this$modelState).equals(other$modelState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowUpdatePersistable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sessionID = this.getSessionID();
        result = result * 59 + ($sessionID == null ? 43 : $sessionID.hashCode());
        String $workerID = this.getWorkerID();
        result = result * 59 + ($workerID == null ? 43 : $workerID.hashCode());
        long $timestamp = this.getTimeStamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        ModelState $modelState = this.getModelState();
        result = result * 59 + ($modelState == null ? 43 : ((Object)$modelState).hashCode());
        return result;
    }

    public String toString() {
        return "FlowUpdatePersistable(sessionID=" + this.getSessionID() + ", workerID=" + this.getWorkerID() + ", timestamp=" + this.getTimeStamp() + ", modelState=" + this.getModelState() + ")";
    }
}

