/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.weights;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.Model;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ModelAndGradient
implements Serializable {
    private long lastUpdateTime = -1L;
    private Map<String, INDArray> parameters;
    private Map<String, INDArray> gradients;
    private double score;
    private List<Double> scores = new ArrayList<Double>();
    private List<Map<String, List<Double>>> updateMagnitudes = new ArrayList<Map<String, List<Double>>>();
    private List<Map<String, List<Double>>> paramMagnitudes = new ArrayList<Map<String, List<Double>>>();
    private List<String> layerNames = new ArrayList<String>();
    private String path;

    public ModelAndGradient() {
        this.parameters = new HashMap<String, INDArray>();
        this.gradients = new HashMap<String, INDArray>();
    }

    public ModelAndGradient(Model model) {
        model.computeGradientAndScore();
        this.gradients = model.gradient().gradientForVariable();
        this.parameters = model.paramTable();
        this.score = model.score();
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public Map<String, INDArray> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, INDArray> parameters) {
        this.parameters = parameters;
    }

    public Map<String, INDArray> getGradients() {
        return this.gradients;
    }

    public void setGradients(Map<String, INDArray> gradients) {
        this.gradients = gradients;
    }

    public void setScores(List<Double> scores) {
        this.scores = scores;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public List<Double> getScores() {
        return this.scores;
    }

    public void setUpdateMagnitudes(List<Map<String, List<Double>>> updateMagnitudes) {
        this.updateMagnitudes = updateMagnitudes;
    }

    public List<Map<String, List<Double>>> getUpdateMagnitudes() {
        return this.updateMagnitudes;
    }

    public void setParamMagnitudes(List<Map<String, List<Double>>> paramMagnitudes) {
        this.paramMagnitudes = paramMagnitudes;
    }

    public List<Map<String, List<Double>>> getParamMagnitudes() {
        return this.paramMagnitudes;
    }

    public void setLayerNames(List<String> layerNames) {
        this.layerNames = layerNames;
    }

    public List<String> getLayerNames() {
        return this.layerNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelAndGradient that = (ModelAndGradient)o;
        if (Double.compare(that.score, this.score) != 0) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        return !(this.gradients == null ? that.gradients != null : !this.gradients.equals(that.gradients));
    }

    public int hashCode() {
        int result = this.parameters != null ? this.parameters.hashCode() : 0;
        result = 31 * result + (this.gradients != null ? this.gradients.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.score);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

