/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.components.chart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.deeplearning4j.ui.components.chart.Chart;
import org.deeplearning4j.ui.components.chart.style.StyleChart;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChartLine
extends Chart {
    public static final String COMPONENT_TYPE = "ChartLine";
    private List<double[]> x;
    private List<double[]> y;
    private List<String> seriesNames;

    private ChartLine(Builder builder) {
        super(COMPONENT_TYPE, builder);
        this.x = builder.x;
        this.y = builder.y;
        this.seriesNames = builder.seriesNames;
    }

    public ChartLine() {
        super(COMPONENT_TYPE);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChartLine(x=[");
        boolean first = true;
        if (this.x != null) {
            for (double[] d : this.x) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(Arrays.toString(d));
                first = false;
            }
        }
        sb.append("],y=[");
        first = true;
        if (this.y != null) {
            for (double[] d : this.y) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(Arrays.toString(d));
                first = false;
            }
        }
        sb.append("],seriesNames=");
        if (this.seriesNames != null) {
            sb.append(this.seriesNames);
        }
        sb.append(")");
        return sb.toString();
    }

    public List<double[]> getX() {
        return this.x;
    }

    public List<double[]> getY() {
        return this.y;
    }

    public List<String> getSeriesNames() {
        return this.seriesNames;
    }

    public void setX(List<double[]> x) {
        this.x = x;
    }

    public void setY(List<double[]> y) {
        this.y = y;
    }

    public void setSeriesNames(List<String> seriesNames) {
        this.seriesNames = seriesNames;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChartLine)) {
            return false;
        }
        ChartLine other = (ChartLine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<double[]> this$x = this.getX();
        List<double[]> other$x = other.getX();
        if (this$x == null ? other$x != null : !((Object)this$x).equals(other$x)) {
            return false;
        }
        List<double[]> this$y = this.getY();
        List<double[]> other$y = other.getY();
        if (this$y == null ? other$y != null : !((Object)this$y).equals(other$y)) {
            return false;
        }
        List<String> this$seriesNames = this.getSeriesNames();
        List<String> other$seriesNames = other.getSeriesNames();
        return !(this$seriesNames == null ? other$seriesNames != null : !((Object)this$seriesNames).equals(other$seriesNames));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChartLine;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<double[]> $x = this.getX();
        result = result * 59 + ($x == null ? 43 : ((Object)$x).hashCode());
        List<double[]> $y = this.getY();
        result = result * 59 + ($y == null ? 43 : ((Object)$y).hashCode());
        List<String> $seriesNames = this.getSeriesNames();
        result = result * 59 + ($seriesNames == null ? 43 : ((Object)$seriesNames).hashCode());
        return result;
    }

    public static class Builder
    extends Chart.Builder<Builder> {
        private List<double[]> x = new ArrayList<double[]>();
        private List<double[]> y = new ArrayList<double[]>();
        private List<String> seriesNames = new ArrayList<String>();
        private boolean showLegend = true;

        public Builder(String title, StyleChart style) {
            super(title, style);
        }

        public Builder addSeries(String seriesName, double[] xValues, double[] yValues) {
            this.x.add(xValues);
            this.y.add(yValues);
            this.seriesNames.add(seriesName);
            return this;
        }

        public ChartLine build() {
            return new ChartLine(this);
        }
    }
}

