/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.standalone;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.ui.api.Component;
import org.deeplearning4j.ui.standalone.ClassPathResource;
import org.deeplearning4j.ui.standalone.ComponentObject;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.MapperFeature;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;

public class StaticPageUtil {
    private StaticPageUtil() {
    }

    public static String renderHTML(Collection<Component> components) throws Exception {
        return StaticPageUtil.renderHTML(components.toArray(new Component[components.size()]));
    }

    public static String renderHTML(Component ... components) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        Configuration cfg = new Configuration(new Version(2, 3, 23));
        cfg.setClassForTemplateLoading(StaticPageUtil.class, "");
        cfg.setIncompatibleImprovements(new Version(2, 3, 23));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setLocale(Locale.US);
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        ClassPathResource cpr = new ClassPathResource("assets/dl4j-ui.js");
        String scriptContents = IOUtils.toString((InputStream)cpr.getInputStream(), (String)"UTF-8");
        HashMap<String, Object> pageElements = new HashMap<String, Object>();
        ArrayList<ComponentObject> list = new ArrayList<ComponentObject>();
        int i = 0;
        for (Component c : components) {
            list.add(new ComponentObject(String.valueOf(i), mapper.writeValueAsString((Object)c)));
            ++i;
        }
        pageElements.put("components", list);
        pageElements.put("scriptcontent", scriptContents);
        Template template = cfg.getTemplate("staticpage.ftl");
        StringWriter stringWriter = new StringWriter();
        template.process(pageElements, (Writer)stringWriter);
        return ((Object)stringWriter).toString();
    }

    public static void saveHTMLFile(String outputPath, Component ... components) throws Exception {
        FileUtils.writeStringToFile((File)new File(outputPath), (String)StaticPageUtil.renderHTML(components));
    }
}

