/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.components.chart.style;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.awt.Color;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.deeplearning4j.ui.api.Style;
import org.deeplearning4j.ui.api.Utils;
import org.deeplearning4j.ui.components.text.style.StyleText;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StyleChart
extends Style {
    public static final Double DEFAULT_CHART_MARGIN_TOP = 60.0;
    public static final Double DEFAULT_CHART_MARGIN_BOTTOM = 20.0;
    public static final Double DEFAULT_CHART_MARGIN_LEFT = 60.0;
    public static final Double DEFAULT_CHART_MARGIN_RIGHT = 20.0;
    protected Double strokeWidth;
    protected Double pointSize;
    protected String[] seriesColors;
    protected Double axisStrokeWidth;
    protected StyleText titleStyle;

    private StyleChart(Builder b) {
        super(b);
        this.strokeWidth = b.strokeWidth;
        this.pointSize = b.pointSize;
        this.seriesColors = b.seriesColors;
        this.axisStrokeWidth = b.axisStrokeWidth;
        this.titleStyle = b.titleStyle;
    }

    @ConstructorProperties(value={"strokeWidth", "pointSize", "seriesColors", "axisStrokeWidth", "titleStyle"})
    public StyleChart(Double strokeWidth, Double pointSize, String[] seriesColors, Double axisStrokeWidth, StyleText titleStyle) {
        this.strokeWidth = strokeWidth;
        this.pointSize = pointSize;
        this.seriesColors = seriesColors;
        this.axisStrokeWidth = axisStrokeWidth;
        this.titleStyle = titleStyle;
    }

    public Double getStrokeWidth() {
        return this.strokeWidth;
    }

    public Double getPointSize() {
        return this.pointSize;
    }

    public String[] getSeriesColors() {
        return this.seriesColors;
    }

    public Double getAxisStrokeWidth() {
        return this.axisStrokeWidth;
    }

    public StyleText getTitleStyle() {
        return this.titleStyle;
    }

    public void setStrokeWidth(Double strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    public void setPointSize(Double pointSize) {
        this.pointSize = pointSize;
    }

    public void setSeriesColors(String[] seriesColors) {
        this.seriesColors = seriesColors;
    }

    public void setAxisStrokeWidth(Double axisStrokeWidth) {
        this.axisStrokeWidth = axisStrokeWidth;
    }

    public void setTitleStyle(StyleText titleStyle) {
        this.titleStyle = titleStyle;
    }

    @Override
    public String toString() {
        return "StyleChart(strokeWidth=" + this.getStrokeWidth() + ", pointSize=" + this.getPointSize() + ", seriesColors=" + Arrays.deepToString(this.getSeriesColors()) + ", axisStrokeWidth=" + this.getAxisStrokeWidth() + ", titleStyle=" + this.getTitleStyle() + ")";
    }

    public StyleChart() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StyleChart)) {
            return false;
        }
        StyleChart other = (StyleChart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$strokeWidth = this.getStrokeWidth();
        Double other$strokeWidth = other.getStrokeWidth();
        if (this$strokeWidth == null ? other$strokeWidth != null : !((Object)this$strokeWidth).equals(other$strokeWidth)) {
            return false;
        }
        Double this$pointSize = this.getPointSize();
        Double other$pointSize = other.getPointSize();
        if (this$pointSize == null ? other$pointSize != null : !((Object)this$pointSize).equals(other$pointSize)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSeriesColors(), other.getSeriesColors())) {
            return false;
        }
        Double this$axisStrokeWidth = this.getAxisStrokeWidth();
        Double other$axisStrokeWidth = other.getAxisStrokeWidth();
        if (this$axisStrokeWidth == null ? other$axisStrokeWidth != null : !((Object)this$axisStrokeWidth).equals(other$axisStrokeWidth)) {
            return false;
        }
        StyleText this$titleStyle = this.getTitleStyle();
        StyleText other$titleStyle = other.getTitleStyle();
        return !(this$titleStyle == null ? other$titleStyle != null : !((Object)this$titleStyle).equals(other$titleStyle));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StyleChart;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Double $strokeWidth = this.getStrokeWidth();
        result = result * 59 + ($strokeWidth == null ? 0 : ((Object)$strokeWidth).hashCode());
        Double $pointSize = this.getPointSize();
        result = result * 59 + ($pointSize == null ? 0 : ((Object)$pointSize).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSeriesColors());
        Double $axisStrokeWidth = this.getAxisStrokeWidth();
        result = result * 59 + ($axisStrokeWidth == null ? 0 : ((Object)$axisStrokeWidth).hashCode());
        StyleText $titleStyle = this.getTitleStyle();
        result = result * 59 + ($titleStyle == null ? 0 : ((Object)$titleStyle).hashCode());
        return result;
    }

    public static class Builder
    extends Style.Builder<Builder> {
        protected Double strokeWidth;
        protected Double pointSize;
        protected String[] seriesColors;
        protected Double axisStrokeWidth;
        protected StyleText titleStyle;

        public Builder() {
            this.marginTop = DEFAULT_CHART_MARGIN_TOP;
            this.marginBottom = DEFAULT_CHART_MARGIN_BOTTOM;
            this.marginLeft = DEFAULT_CHART_MARGIN_LEFT;
            this.marginRight = DEFAULT_CHART_MARGIN_RIGHT;
        }

        public Builder strokeWidth(double strokeWidth) {
            this.strokeWidth = strokeWidth;
            return this;
        }

        public Builder pointSize(double pointSize) {
            this.pointSize = pointSize;
            return this;
        }

        public Builder seriesColors(Color ... colors) {
            String[] str = new String[colors.length];
            for (int i = 0; i < str.length; ++i) {
                str[i] = Utils.colorToHex(colors[i]);
            }
            return this.seriesColors(str);
        }

        public Builder seriesColors(String ... colors) {
            this.seriesColors = colors;
            return this;
        }

        public Builder axisStrokeWidth(double axisStrokeWidth) {
            this.axisStrokeWidth = axisStrokeWidth;
            return this;
        }

        public Builder titleStyle(StyleText style) {
            this.titleStyle = style;
            return this;
        }

        public StyleChart build() {
            return new StyleChart(this);
        }
    }
}

