/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.components.decorator;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.deeplearning4j.ui.api.Component;
import org.deeplearning4j.ui.components.decorator.style.StyleAccordion;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DecoratorAccordion
extends Component {
    public static final String COMPONENT_TYPE = "DecoratorAccordion";
    private String title;
    private boolean defaultCollapsed;
    private Component[] innerComponents;

    public DecoratorAccordion() {
        super(COMPONENT_TYPE, null);
    }

    private DecoratorAccordion(Builder builder) {
        super(COMPONENT_TYPE, builder.style);
        this.title = builder.title;
        this.defaultCollapsed = builder.defaultCollapsed;
        this.innerComponents = builder.innerComponents.toArray(new Component[builder.innerComponents.size()]);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DecoratorAccordion)) {
            return false;
        }
        DecoratorAccordion other = (DecoratorAccordion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        if (this.isDefaultCollapsed() != other.isDefaultCollapsed()) {
            return false;
        }
        return Arrays.deepEquals(this.getInnerComponents(), other.getInnerComponents());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DecoratorAccordion;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 0 : $title.hashCode());
        result = result * 59 + (this.isDefaultCollapsed() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getInnerComponents());
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isDefaultCollapsed() {
        return this.defaultCollapsed;
    }

    public Component[] getInnerComponents() {
        return this.innerComponents;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDefaultCollapsed(boolean defaultCollapsed) {
        this.defaultCollapsed = defaultCollapsed;
    }

    public void setInnerComponents(Component[] innerComponents) {
        this.innerComponents = innerComponents;
    }

    @Override
    public String toString() {
        return "DecoratorAccordion(title=" + this.getTitle() + ", defaultCollapsed=" + this.isDefaultCollapsed() + ", innerComponents=" + Arrays.deepToString(this.getInnerComponents()) + ")";
    }

    public static class Builder {
        private StyleAccordion style;
        private String title;
        private List<Component> innerComponents = new ArrayList<Component>();
        private boolean defaultCollapsed;

        public Builder(StyleAccordion style) {
            this(null, style);
        }

        public Builder(String title, StyleAccordion style) {
            this.title = title;
            this.style = style;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder addComponents(Component ... innerComponents) {
            Collections.addAll(this.innerComponents, innerComponents);
            return this;
        }

        public Builder setDefaultCollapsed(boolean defaultCollapsed) {
            this.defaultCollapsed = defaultCollapsed;
            return this;
        }

        public DecoratorAccordion build() {
            return new DecoratorAccordion(this);
        }
    }
}

