/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.components.chart;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.deeplearning4j.ui.api.Component;
import org.deeplearning4j.ui.components.chart.style.StyleChart;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class Chart
extends Component {
    private String title;
    private Boolean suppressAxisHorizontal;
    private Boolean suppressAxisVertical;
    private boolean showLegend;
    private Double setXMin;
    private Double setXMax;
    private Double setYMin;
    private Double setYMax;
    private Double gridVerticalStrokeWidth;
    private Double gridHorizontalStrokeWidth;

    public Chart(String componentType) {
        super(componentType, null);
    }

    public Chart(String componentType, Builder builder) {
        super(componentType, builder.getStyle());
        this.title = builder.title;
        this.suppressAxisHorizontal = builder.suppressAxisHorizontal;
        this.suppressAxisVertical = builder.suppressAxisVertical;
        this.setXMin = builder.setXMin;
        this.setXMax = builder.setXMax;
        this.setYMin = builder.setYMin;
        this.setYMax = builder.setYMax;
        this.gridVerticalStrokeWidth = builder.gridVerticalStrokeWidth;
        this.gridHorizontalStrokeWidth = builder.gridHorizontalStrokeWidth;
    }

    public String getTitle() {
        return this.title;
    }

    public Boolean getSuppressAxisHorizontal() {
        return this.suppressAxisHorizontal;
    }

    public Boolean getSuppressAxisVertical() {
        return this.suppressAxisVertical;
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public Double getSetXMin() {
        return this.setXMin;
    }

    public Double getSetXMax() {
        return this.setXMax;
    }

    public Double getSetYMin() {
        return this.setYMin;
    }

    public Double getSetYMax() {
        return this.setYMax;
    }

    public Double getGridVerticalStrokeWidth() {
        return this.gridVerticalStrokeWidth;
    }

    public Double getGridHorizontalStrokeWidth() {
        return this.gridHorizontalStrokeWidth;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSuppressAxisHorizontal(Boolean suppressAxisHorizontal) {
        this.suppressAxisHorizontal = suppressAxisHorizontal;
    }

    public void setSuppressAxisVertical(Boolean suppressAxisVertical) {
        this.suppressAxisVertical = suppressAxisVertical;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    public void setSetXMin(Double setXMin) {
        this.setXMin = setXMin;
    }

    public void setSetXMax(Double setXMax) {
        this.setXMax = setXMax;
    }

    public void setSetYMin(Double setYMin) {
        this.setYMin = setYMin;
    }

    public void setSetYMax(Double setYMax) {
        this.setYMax = setYMax;
    }

    public void setGridVerticalStrokeWidth(Double gridVerticalStrokeWidth) {
        this.gridVerticalStrokeWidth = gridVerticalStrokeWidth;
    }

    public void setGridHorizontalStrokeWidth(Double gridHorizontalStrokeWidth) {
        this.gridHorizontalStrokeWidth = gridHorizontalStrokeWidth;
    }

    @Override
    public String toString() {
        return "Chart(title=" + this.getTitle() + ", suppressAxisHorizontal=" + this.getSuppressAxisHorizontal() + ", suppressAxisVertical=" + this.getSuppressAxisVertical() + ", showLegend=" + this.isShowLegend() + ", setXMin=" + this.getSetXMin() + ", setXMax=" + this.getSetXMax() + ", setYMin=" + this.getSetYMin() + ", setYMax=" + this.getSetYMax() + ", gridVerticalStrokeWidth=" + this.getGridVerticalStrokeWidth() + ", gridHorizontalStrokeWidth=" + this.getGridHorizontalStrokeWidth() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Chart)) {
            return false;
        }
        Chart other = (Chart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Boolean this$suppressAxisHorizontal = this.getSuppressAxisHorizontal();
        Boolean other$suppressAxisHorizontal = other.getSuppressAxisHorizontal();
        if (this$suppressAxisHorizontal == null ? other$suppressAxisHorizontal != null : !((Object)this$suppressAxisHorizontal).equals(other$suppressAxisHorizontal)) {
            return false;
        }
        Boolean this$suppressAxisVertical = this.getSuppressAxisVertical();
        Boolean other$suppressAxisVertical = other.getSuppressAxisVertical();
        if (this$suppressAxisVertical == null ? other$suppressAxisVertical != null : !((Object)this$suppressAxisVertical).equals(other$suppressAxisVertical)) {
            return false;
        }
        if (this.isShowLegend() != other.isShowLegend()) {
            return false;
        }
        Double this$setXMin = this.getSetXMin();
        Double other$setXMin = other.getSetXMin();
        if (this$setXMin == null ? other$setXMin != null : !((Object)this$setXMin).equals(other$setXMin)) {
            return false;
        }
        Double this$setXMax = this.getSetXMax();
        Double other$setXMax = other.getSetXMax();
        if (this$setXMax == null ? other$setXMax != null : !((Object)this$setXMax).equals(other$setXMax)) {
            return false;
        }
        Double this$setYMin = this.getSetYMin();
        Double other$setYMin = other.getSetYMin();
        if (this$setYMin == null ? other$setYMin != null : !((Object)this$setYMin).equals(other$setYMin)) {
            return false;
        }
        Double this$setYMax = this.getSetYMax();
        Double other$setYMax = other.getSetYMax();
        if (this$setYMax == null ? other$setYMax != null : !((Object)this$setYMax).equals(other$setYMax)) {
            return false;
        }
        Double this$gridVerticalStrokeWidth = this.getGridVerticalStrokeWidth();
        Double other$gridVerticalStrokeWidth = other.getGridVerticalStrokeWidth();
        if (this$gridVerticalStrokeWidth == null ? other$gridVerticalStrokeWidth != null : !((Object)this$gridVerticalStrokeWidth).equals(other$gridVerticalStrokeWidth)) {
            return false;
        }
        Double this$gridHorizontalStrokeWidth = this.getGridHorizontalStrokeWidth();
        Double other$gridHorizontalStrokeWidth = other.getGridHorizontalStrokeWidth();
        return !(this$gridHorizontalStrokeWidth == null ? other$gridHorizontalStrokeWidth != null : !((Object)this$gridHorizontalStrokeWidth).equals(other$gridHorizontalStrokeWidth));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Chart;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 0 : $title.hashCode());
        Boolean $suppressAxisHorizontal = this.getSuppressAxisHorizontal();
        result = result * 59 + ($suppressAxisHorizontal == null ? 0 : ((Object)$suppressAxisHorizontal).hashCode());
        Boolean $suppressAxisVertical = this.getSuppressAxisVertical();
        result = result * 59 + ($suppressAxisVertical == null ? 0 : ((Object)$suppressAxisVertical).hashCode());
        result = result * 59 + (this.isShowLegend() ? 79 : 97);
        Double $setXMin = this.getSetXMin();
        result = result * 59 + ($setXMin == null ? 0 : ((Object)$setXMin).hashCode());
        Double $setXMax = this.getSetXMax();
        result = result * 59 + ($setXMax == null ? 0 : ((Object)$setXMax).hashCode());
        Double $setYMin = this.getSetYMin();
        result = result * 59 + ($setYMin == null ? 0 : ((Object)$setYMin).hashCode());
        Double $setYMax = this.getSetYMax();
        result = result * 59 + ($setYMax == null ? 0 : ((Object)$setYMax).hashCode());
        Double $gridVerticalStrokeWidth = this.getGridVerticalStrokeWidth();
        result = result * 59 + ($gridVerticalStrokeWidth == null ? 0 : ((Object)$gridVerticalStrokeWidth).hashCode());
        Double $gridHorizontalStrokeWidth = this.getGridHorizontalStrokeWidth();
        result = result * 59 + ($gridHorizontalStrokeWidth == null ? 0 : ((Object)$gridHorizontalStrokeWidth).hashCode());
        return result;
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String title;
        private StyleChart style;
        private Boolean suppressAxisHorizontal;
        private Boolean suppressAxisVertical;
        private boolean showLegend;
        private Double setXMin;
        private Double setXMax;
        private Double setYMin;
        private Double setYMax;
        private Double gridVerticalStrokeWidth;
        private Double gridHorizontalStrokeWidth;

        public Builder(String title, StyleChart style) {
            this.title = title;
            this.style = style;
        }

        public T suppressAxisHorizontal(boolean suppressAxisHorizontal) {
            this.suppressAxisHorizontal = suppressAxisHorizontal;
            return (T)this;
        }

        public T suppressAxisVertical(boolean suppressAxisVertical) {
            this.suppressAxisVertical = suppressAxisVertical;
            return (T)this;
        }

        public T showLegend(boolean showLegend) {
            this.showLegend = showLegend;
            return (T)this;
        }

        public T setXMin(Double xMin) {
            this.setXMin = xMin;
            return (T)this;
        }

        public T setXMax(Double xMax) {
            this.setXMax = xMax;
            return (T)this;
        }

        public T setYMin(Double yMin) {
            this.setYMin = yMin;
            return (T)this;
        }

        public T setYMax(Double yMax) {
            this.setYMax = yMax;
            return (T)this;
        }

        public T setGridWidth(Double gridVerticalStrokeWidth, Double gridHorizontalStrokeWidth) {
            this.gridVerticalStrokeWidth = gridVerticalStrokeWidth;
            this.gridHorizontalStrokeWidth = gridHorizontalStrokeWidth;
            return (T)this;
        }

        public T setGridWidth(Integer gridVerticalStrokeWidth, Integer gridHorizontalStrokeWidth) {
            return this.setGridWidth(gridVerticalStrokeWidth != null ? Double.valueOf(gridVerticalStrokeWidth.doubleValue()) : null, gridHorizontalStrokeWidth != null ? Double.valueOf(gridHorizontalStrokeWidth.doubleValue()) : null);
        }

        public String getTitle() {
            return this.title;
        }

        public StyleChart getStyle() {
            return this.style;
        }

        public Boolean getSuppressAxisHorizontal() {
            return this.suppressAxisHorizontal;
        }

        public Boolean getSuppressAxisVertical() {
            return this.suppressAxisVertical;
        }

        public boolean isShowLegend() {
            return this.showLegend;
        }

        public Double getSetXMin() {
            return this.setXMin;
        }

        public Double getSetXMax() {
            return this.setXMax;
        }

        public Double getSetYMin() {
            return this.setYMin;
        }

        public Double getSetYMax() {
            return this.setYMax;
        }

        public Double getGridVerticalStrokeWidth() {
            return this.gridVerticalStrokeWidth;
        }

        public Double getGridHorizontalStrokeWidth() {
            return this.gridHorizontalStrokeWidth;
        }
    }
}

