/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.feedforward.embedding;

import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterUpdate;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddingLayer
extends BaseLayer<org.deeplearning4j.nn.conf.layers.EmbeddingLayer> {
    private static final Logger log = LoggerFactory.getLogger(EmbeddingLayer.class);
    private static final int[] DIM_1 = new int[]{1};

    public EmbeddingLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        INDArray z = this.preOutput(true, workspaceMgr);
        INDArray delta = (INDArray)((org.deeplearning4j.nn.conf.layers.EmbeddingLayer)this.layerConf()).getActivationFn().backprop(z, epsilon).getFirst();
        if (this.maskArray != null) {
            delta.muliColumnVector(this.maskArray.castTo(this.dataType));
        }
        INDArray weightGradients = (INDArray)this.gradientViews.get("W");
        weightGradients.assign((Number)0);
        int[] indexes = new int[(int)this.input.length()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = this.input.getInt(new int[]{i, 0});
        }
        INDArray indices = Nd4j.createFromArray((int[])indexes);
        Nd4j.scatterUpdate((ScatterUpdate.UpdateOp)ScatterUpdate.UpdateOp.ADD, (INDArray)weightGradients, (INDArray)indices, (INDArray)delta, (int[])DIM_1);
        DefaultGradient ret = new DefaultGradient();
        ret.gradientForVariable().put("W", weightGradients);
        if (this.hasBias()) {
            INDArray biasGradientsView = (INDArray)this.gradientViews.get("b");
            delta.sum(biasGradientsView, new int[]{0});
            ret.gradientForVariable().put("b", biasGradientsView);
        }
        return new Pair((Object)ret, null);
    }

    @Override
    protected INDArray preOutput(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        if (this.input.columns() != 1) {
            throw new DL4JInvalidInputException("Cannot do forward pass for embedding layer with input more than one column. Expected input shape: [numExamples,1] with each entry being an integer index " + this.layerId());
        }
        long nIn = ((org.deeplearning4j.nn.conf.layers.EmbeddingLayer)this.layerConf()).getNIn();
        int[] indexes = new int[(int)this.input.length()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = this.input.getInt(new int[]{i, 0});
            if (indexes[i] >= 0 && (long)indexes[i] < nIn) continue;
            throw new DL4JInvalidInputException("Invalid index for embedding layer: got index " + indexes[i] + " for entry " + i + " in minibatch; indexes must be between 0 and nIn-1 inclusive (0 to " + (nIn - 1L) + ")");
        }
        INDArray weights = this.getParam("W");
        INDArray bias = this.getParam("b");
        INDArray destination = workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, weights.dataType(), new long[]{this.input.size(0), weights.size(1)});
        INDArray rows = Nd4j.pullRows((INDArray)weights, (INDArray)destination, (int)1, (int[])indexes);
        if (this.hasBias()) {
            rows.addiRowVector(bias);
        }
        return rows;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray rows = this.preOutput(training, workspaceMgr);
        INDArray ret = ((org.deeplearning4j.nn.conf.layers.EmbeddingLayer)this.layerConf()).getActivationFn().getActivation(rows, training);
        if (this.maskArray != null) {
            ret.muliColumnVector(this.maskArray.castTo(this.dataType));
        }
        return ret;
    }

    @Override
    public boolean hasBias() {
        return ((org.deeplearning4j.nn.conf.layers.EmbeddingLayer)this.layerConf()).hasBias();
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    protected void applyDropOutIfNecessary(boolean training, LayerWorkspaceMgr workspaceMgr) {
        throw new UnsupportedOperationException("Dropout not supported with EmbeddingLayer " + this.layerId());
    }
}

