/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.misc;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.EmptyParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class RepeatVector
extends FeedForwardLayer {
    private int n = 1;

    protected RepeatVector(Builder builder) {
        super(builder);
        this.n = builder.n;
    }

    @Override
    public RepeatVector clone() {
        return (RepeatVector)super.clone();
    }

    @Override
    public ParamInitializer initializer() {
        return EmptyParamInitializer.getInstance();
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        org.deeplearning4j.nn.layers.RepeatVector ret = new org.deeplearning4j.nn.layers.RepeatVector(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.FF) {
            throw new IllegalStateException("Invalid input for RepeatVector layer (layer name=\"" + this.getLayerName() + "\"): Expected FF input, got " + inputType);
        }
        InputType.InputTypeFeedForward ffInput = (InputType.InputTypeFeedForward)inputType;
        return InputType.recurrent(ffInput.getSize(), this.n);
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType outputType = this.getOutputType(-1, inputType);
        return new LayerMemoryReport.Builder(this.layerName, RepeatVector.class, inputType, outputType).standardMemory(0L, 0L).workingMemory(0L, 0L, 0L, 0L).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        throw new UnsupportedOperationException("UpsamplingLayer does not contain parameters");
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public RepeatVector() {
    }

    @Override
    public String toString() {
        return "RepeatVector(super=" + super.toString() + ", n=" + this.getN() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepeatVector)) {
            return false;
        }
        RepeatVector other = (RepeatVector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getN() == other.getN();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RepeatVector;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getN();
        return result;
    }

    public static class Builder<T extends Builder<T>>
    extends FeedForwardLayer.Builder<T> {
        private int n = 1;

        public int getRepetitionFactor() {
            return this.n;
        }

        public void setRepetitionFactor(int n) {
            this.setN(n);
        }

        public Builder(int n) {
            this.setN(n);
        }

        public Builder repetitionFactor(int n) {
            this.setN(n);
            return this;
        }

        @Override
        public RepeatVector build() {
            return new RepeatVector(this);
        }

        public Builder() {
        }

        public int getN() {
            return this.n;
        }

        public void setN(int n) {
            this.n = n;
        }
    }
}

