/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidConfigException;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.preprocessor.CnnToRnnPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.FeedForwardToCnnPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.FeedForwardToRnnPreProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputTypeUtil {
    private static final Logger log = LoggerFactory.getLogger(InputTypeUtil.class);

    public static InputType getOutputTypeDeconvLayer(InputType inputType, int[] kernelSize, int[] stride, int[] padding, int[] dilation, ConvolutionMode convolutionMode, long outputDepth, long layerIdx, String layerName, Class<?> layerClass) {
        InputType.InputTypeConvolutional i = (InputType.InputTypeConvolutional)inputType;
        int hIn = (int)i.getHeight();
        int wIn = (int)i.getWidth();
        int inHeight = (int)i.getHeight();
        int inWidth = (int)i.getWidth();
        int padH = padding == null ? 0 : padding[0];
        int padW = padding == null ? 0 : padding[1];
        int kH = kernelSize[0];
        int kW = kernelSize[1];
        if (dilation[0] != 1) {
            kH += (kH - 1) * (dilation[0] - 1);
        }
        if (dilation[1] != 1) {
            kW += (kW - 1) * (dilation[1] - 1);
        }
        int sH = stride[0];
        int sW = stride[1];
        if (sH <= 0 || sW <= 0) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, sH <= 0) + " Invalid strides: strides must be > 0 (strideH = " + sH + ", strideW = " + sW + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputDepth, convolutionMode));
        }
        if (convolutionMode == ConvolutionMode.Same) {
            int hOut = stride[0] * hIn;
            int wOut = stride[1] * wIn;
            return InputType.convolutional(hOut, wOut, outputDepth);
        }
        int hOut = sH * (hIn - 1) + kH - 2 * padH;
        int wOut = sW * (wIn - 1) + kW - 2 * padW;
        return InputType.convolutional(hOut, wOut, outputDepth);
    }

    public static InputType getOutputTypeCnn3DLayers(InputType inputType, int[] kernelSize, int[] stride, int[] padding, int[] dilation, ConvolutionMode convolutionMode, long outputChannels, long layerIdx, String layerName, Class<?> layerClass) {
        if (convolutionMode == null) {
            String name = layerName == null ? "(not named)" : layerName;
            throw new DL4JInvalidConfigException("Invalid configuration: convolution mode is null for layer (idx=" + layerIdx + ", name=" + name + ", type=" + layerClass.getName() + ")");
        }
        InputType.InputTypeConvolutional3D i = (InputType.InputTypeConvolutional3D)inputType;
        int inDepth = (int)i.getDepth();
        int inHeight = (int)i.getHeight();
        int inWidth = (int)i.getWidth();
        int padD = padding == null ? 0 : padding[0];
        int padH = padding == null ? 0 : padding[1];
        int padW = padding == null ? 0 : padding[2];
        int kD = kernelSize[0];
        int kH = kernelSize[1];
        int kW = kernelSize[2];
        if (dilation[0] != 1) {
            kD += (kD - 1) * (dilation[0] - 1);
        }
        if (dilation[1] != 1) {
            kH += (kH - 1) * (dilation[1] - 1);
        }
        if (dilation[2] != 1) {
            kW += (kW - 1) * (dilation[2] - 1);
        }
        int sD = stride[0];
        int sH = stride[1];
        int sW = stride[1];
        if (sH <= 0 || sW <= 0 || sD <= 0) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, sH <= 0) + " Invalid strides: strides must be > 0 (strideH = " + sH + ", strideW = " + sW + ", strideD = " + sD + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputChannels, convolutionMode));
        }
        if (kH <= 0 || kH > inHeight + 2 * padH) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, true) + " Invalid input configuration for kernel height. Require 0 < kH <= inHeight + 2*padH; got (kH=" + kH + ", inHeight=" + inHeight + ", padH=" + padH + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputChannels, convolutionMode));
        }
        if (kW <= 0 || kW > inWidth + 2 * padW) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, false) + " Invalid input configuration for kernel width. Require 0 < kW <= inWidth + 2*padW; got (kW=" + kW + ", inWidth=" + inWidth + ", padW=" + padW + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputChannels, convolutionMode));
        }
        if (kD <= 0 || kD > inDepth + 2 * padD) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, false) + " Invalid input configuration for kernel channels. Require 0 < kD <= inDepth + 2*padD; got (kD=" + kD + ", inDepth=" + inDepth + ", padD=" + padD + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputChannels, convolutionMode));
        }
        if (convolutionMode == ConvolutionMode.Strict) {
            if ((inHeight - kH + 2 * padH) % sH != 0) {
                double d = (double)(inHeight - kH + 2 * padH) / (double)sH + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inHeight / (double)stride[0]);
                throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, true) + "\nCombination of kernel size, stride and padding are not valid for given input height, using ConvolutionMode.Strict\nConvolutionMode.Strict requires: output height = (input height - kernelSize + 2*padding)/stride + 1 in height dimension to be an integer. Got: (" + inHeight + " - " + kH + " + 2*" + padH + ")/" + sH + " + 1 = " + str + "\nSee ConvolutionType enumeration Javadoc and \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/\nTo truncate/crop the input, such that output height = floor(" + str + ") = " + truncated + ", use ConvolutionType.Truncate.\nAlternatively use ConvolutionType.Same, which will use padding to give an output height of ceil(" + inHeight + "/" + stride[0] + ")=" + sameSize + "\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputChannels, convolutionMode));
            }
            if ((inWidth - kW + 2 * padW) % sW != 0) {
                double d = (double)(inWidth - kW + 2 * padW) / (double)sW + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inWidth / (double)stride[1]);
                throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, false) + "\nCombination of kernel size, stride and padding are not valid for given input width, using ConvolutionMode.Strict\nConvolutionMode.Strict requires: output width = (input width - kernelSize + 2*padding)/stride + 1 in width dimension to be an integer. Got: (" + inWidth + " - " + kW + " + 2*" + padW + ")/" + sW + " + 1 = " + str + "\nSee \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/ and ConvolutionType enumeration Javadoc.\nTo truncate/crop the input, such that output width = floor(" + str + ") = " + truncated + ", use ConvolutionType.Truncate.\nAlternatively use ConvolutionType.Same, which will use padding to give an output width of ceil(" + inWidth + "/" + stride[1] + ")=" + sameSize + "\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputChannels, convolutionMode));
            }
            if ((inDepth - kD + 2 * padD) % sD != 0) {
                double d = (double)(inDepth - kD + 2 * padD) / (double)sD + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inDepth / (double)stride[2]);
                throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, false) + "\nCombination of kernel size, stride and padding are not valid for given input width, using ConvolutionMode.Strict\nConvolutionMode.Strict requires: output channels = (input channels - kernelSize + 2*padding)/stride + 1 in width dimension to be an integer. Got: (" + inDepth + " - " + kD + " + 2*" + padD + ")/" + sD + " + 1 = " + str + "\nSee \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/ and ConvolutionType enumeration Javadoc.\nTo truncate/crop the input, such that output width = floor(" + str + ") = " + truncated + ", use ConvolutionType.Truncate.\nAlternatively use ConvolutionType.Same, which will use padding to give an output width of ceil(" + inDepth + "/" + stride[2] + ")=" + sameSize + "\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputChannels, convolutionMode));
            }
        } else if (convolutionMode == ConvolutionMode.Same) {
            int outD = (int)Math.ceil((double)inDepth / (double)sD);
            int outH = (int)Math.ceil((double)inHeight / (double)sH);
            int outW = (int)Math.ceil((double)inWidth / (double)sW);
            return InputType.convolutional3D(outD, outH, outW, outputChannels);
        }
        int dOut = (inDepth - kD + 2 * padD) / sD + 1;
        int hOut = (inHeight - kH + 2 * padH) / sH + 1;
        int wOut = (inWidth - kW + 2 * padW) / sW + 1;
        return InputType.convolutional3D(dOut, hOut, wOut, outputChannels);
    }

    public static InputType getOutputTypeCnn1DLayers(InputType inputType, int kH, int sH, int padH, int dilation, ConvolutionMode convolutionMode, long outputDepth, long layerIdx, String layerName, Class<?> layerClass) {
        if (convolutionMode == null) {
            String name = layerName == null ? "(not named)" : layerName;
            throw new DL4JInvalidConfigException("Invalid configuration: convolution mode is null for layer (idx=" + layerIdx + ", name=" + name + ", type=" + layerClass.getName() + ")");
        }
        InputType.InputTypeRecurrent i = (InputType.InputTypeRecurrent)inputType;
        int inHeight = (int)i.getTimeSeriesLength();
        if (dilation != 1) {
            kH += (kH - 1) * (dilation - 1);
        }
        if (sH <= 0) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, sH <= 0) + " Invalid strides: strides must be > 0 (strideH = " + sH + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine1D(inputType, kH, sH, padH, outputDepth, convolutionMode));
        }
        if (kH <= 0 || kH > inHeight + 2 * padH) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, true) + " Invalid input configuration for kernel height. Require 0 < kH <= inHeight + 2*padH; got (kH=" + kH + ", inHeight=" + inHeight + ", padH=" + padH + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine1D(inputType, kH, sH, padH, outputDepth, convolutionMode));
        }
        if (convolutionMode == ConvolutionMode.Strict) {
            if ((inHeight - kH + 2 * padH) % sH != 0) {
                double d = (double)(inHeight - kH + 2 * padH) / (double)sH + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inHeight / (double)sH);
                throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, true) + "\nCombination of kernel size, stride and padding are not valid for given input height, using ConvolutionMode.Strict\nConvolutionMode.Strict requires: output height = (input height - kernelSize + 2*padding)/stride + 1 in height dimension to be an integer. Got: (" + inHeight + " - " + kH + " + 2*" + padH + ")/" + sH + " + 1 = " + str + "\nSee ConvolutionType enumeration Javadoc and \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/\nTo truncate/crop the input, such that output height = floor(" + str + ") = " + truncated + ", use ConvolutionType.Truncate.\nAlternatively use ConvolutionType.Same, which will use padding to give an output height of ceil(" + inHeight + "/" + sH + ")=" + sameSize + "\n" + InputTypeUtil.getConfigErrorCommonLastLine1D(inputType, kH, sH, padH, outputDepth, convolutionMode));
            }
        } else if (convolutionMode == ConvolutionMode.Same) {
            int outH = (int)Math.ceil((double)inHeight / (double)sH);
            return InputType.recurrent(outputDepth, outH);
        }
        int outH = (inHeight - kH + 2 * padH) / sH + 1;
        return InputType.recurrent(outputDepth, outH);
    }

    public static InputType getOutputTypeCnnLayers(InputType inputType, int[] kernelSize, int[] stride, int[] padding, int[] dilation, ConvolutionMode convolutionMode, long outputDepth, long layerIdx, String layerName, Class<?> layerClass) {
        if (convolutionMode == null) {
            String name = layerName == null ? "(not named)" : layerName;
            throw new DL4JInvalidConfigException("Invalid configuration: convolution mode is null for layer (idx=" + layerIdx + ", name=" + name + ", type=" + layerClass.getName() + ")");
        }
        InputType.InputTypeConvolutional i = (InputType.InputTypeConvolutional)inputType;
        int inHeight = (int)i.getHeight();
        int inWidth = (int)i.getWidth();
        int padH = padding == null ? 0 : padding[0];
        int padW = padding == null ? 0 : padding[1];
        int kH = kernelSize[0];
        int kW = kernelSize[1];
        if (dilation[0] != 1) {
            kH += (kH - 1) * (dilation[0] - 1);
        }
        if (dilation[1] != 1) {
            kW += (kW - 1) * (dilation[1] - 1);
        }
        int sH = stride[0];
        int sW = stride[1];
        if (sH <= 0 || sW <= 0) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, sH <= 0) + " Invalid strides: strides must be > 0 (strideH = " + sH + ", strideW = " + sW + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputDepth, convolutionMode));
        }
        if (kH <= 0 || kH > inHeight + 2 * padH) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, true) + " Invalid input configuration for kernel height. Require 0 < kH <= inHeight + 2*padH; got (kH=" + kH + ", inHeight=" + inHeight + ", padH=" + padH + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputDepth, convolutionMode));
        }
        if (kW <= 0 || kW > inWidth + 2 * padW) {
            throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, false) + " Invalid input configuration for kernel width. Require 0 < kW <= inWidth + 2*padW; got (kW=" + kW + ", inWidth=" + inWidth + ", padW=" + padW + ")\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputDepth, convolutionMode));
        }
        if (convolutionMode == ConvolutionMode.Strict) {
            if ((inHeight - kH + 2 * padH) % sH != 0) {
                double d = (double)(inHeight - kH + 2 * padH) / (double)sH + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inHeight / (double)stride[0]);
                throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, true) + "\nCombination of kernel size, stride and padding are not valid for given input height, using ConvolutionMode.Strict\nConvolutionMode.Strict requires: output height = (input height - kernelSize + 2*padding)/stride + 1 in height dimension to be an integer. Got: (" + inHeight + " - " + kH + " + 2*" + padH + ")/" + sH + " + 1 = " + str + "\nSee ConvolutionType enumeration Javadoc and \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/\nTo truncate/crop the input, such that output height = floor(" + str + ") = " + truncated + ", use ConvolutionType.Truncate.\nAlternatively use ConvolutionType.Same, which will use padding to give an output height of ceil(" + inHeight + "/" + stride[0] + ")=" + sameSize + "\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputDepth, convolutionMode));
            }
            if ((inWidth - kW + 2 * padW) % sW != 0) {
                double d = (double)(inWidth - kW + 2 * padW) / (double)sW + 1.0;
                String str = String.format("%.2f", d);
                int truncated = (int)d;
                int sameSize = (int)Math.ceil((double)inWidth / (double)stride[1]);
                throw new DL4JInvalidConfigException(InputTypeUtil.getConfigErrorCommonLine(layerIdx, layerName, layerClass, false) + "\nCombination of kernel size, stride and padding are not valid for given input width, using ConvolutionMode.Strict\nConvolutionMode.Strict requires: output width = (input width - kernelSize + 2*padding)/stride + 1 in width dimension to be an integer. Got: (" + inWidth + " - " + kW + " + 2*" + padW + ")/" + sW + " + 1 = " + str + "\nSee \"Constraints on strides\" at http://cs231n.github.io/convolutional-networks/ and ConvolutionType enumeration Javadoc.\nTo truncate/crop the input, such that output width = floor(" + str + ") = " + truncated + ", use ConvolutionType.Truncate.\nAlternatively use ConvolutionType.Same, which will use padding to give an output width of ceil(" + inWidth + "/" + stride[1] + ")=" + sameSize + "\n" + InputTypeUtil.getConfigErrorCommonLastLine(inputType, kernelSize, stride, padding, outputDepth, convolutionMode));
            }
        } else if (convolutionMode == ConvolutionMode.Same) {
            int outH = (int)Math.ceil((double)inHeight / (double)stride[0]);
            int outW = (int)Math.ceil((double)inWidth / (double)stride[1]);
            return InputType.convolutional(outH, outW, outputDepth);
        }
        int hOut = (inHeight - kH + 2 * padH) / sH + 1;
        int wOut = (inWidth - kW + 2 * padW) / sW + 1;
        return InputType.convolutional(hOut, wOut, outputDepth);
    }

    private static String getConfigErrorCommonLine(long layerIdx, String layerName, Class<?> layerClass, boolean isHeight) {
        String name = layerName == null ? "(not named)" : layerName;
        String layerType = layerClass.getSimpleName();
        return "Invalid configuration for layer (idx=" + layerIdx + ", name=" + name + ", type=" + layerType + ") for " + (isHeight ? "height" : "width") + " dimension: ";
    }

    private static String getConfigErrorCommonLastLine1D(InputType inputType, int kernelSize, int stride, int padding, long outputDepth, ConvolutionMode convolutionMode) {
        return "Input type = " + inputType + ", kernel = " + kernelSize + ", strides = " + stride + ", padding = " + padding + ", layer size (output channels) = " + outputDepth + ", convolution mode = " + (Object)((Object)convolutionMode);
    }

    private static String getConfigErrorCommonLastLine(InputType inputType, int[] kernelSize, int[] stride, int[] padding, long outputDepth, ConvolutionMode convolutionMode) {
        return "Input type = " + inputType + ", kernel = " + Arrays.toString(kernelSize) + ", strides = " + Arrays.toString(stride) + ", padding = " + Arrays.toString(padding) + ", layer size (output channels) = " + outputDepth + ", convolution mode = " + (Object)((Object)convolutionMode);
    }

    public static InputPreProcessor getPreProcessorForInputTypeCnn3DLayers(InputType inputType, String layerName) {
        switch (inputType.getType()) {
            case FF: {
                log.info("Automatic addition of FF -> CNN3D preprocessors: not yet implemented (layer name: \"" + layerName + "\")");
                return null;
            }
            case RNN: {
                log.warn("Automatic addition of RNN -> CNN3D preprocessors: not yet implemented (layer name: \"" + layerName + "\")");
                return null;
            }
            case CNN3D: {
                return null;
            }
        }
        throw new RuntimeException("Unknown input type: " + inputType);
    }

    public static InputPreProcessor getPreProcessorForInputTypeCnnLayers(InputType inputType, String layerName) {
        switch (inputType.getType()) {
            case FF: {
                log.info("Automatic addition of FF -> CNN preprocessors: not yet implemented (layer name: \"" + layerName + "\")");
                return null;
            }
            case RNN: {
                log.warn("Automatic addition of RNN -> CNN preprocessors: not yet implemented (layer name: \"" + layerName + "\")");
                return null;
            }
            case CNN: {
                return null;
            }
            case CNNFlat: {
                InputType.InputTypeConvolutionalFlat f = (InputType.InputTypeConvolutionalFlat)inputType;
                return new FeedForwardToCnnPreProcessor(f.getHeight(), f.getWidth(), f.getDepth());
            }
        }
        throw new RuntimeException("Unknown input type: " + inputType);
    }

    public static InputPreProcessor getPreprocessorForInputTypeRnnLayers(InputType inputType, String layerName) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for RNN layer (layer name = \"" + layerName + "\"): input type is null");
        }
        switch (inputType.getType()) {
            case FF: 
            case CNNFlat: {
                return new FeedForwardToRnnPreProcessor();
            }
            case RNN: {
                return null;
            }
            case CNN: {
                InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
                return new CnnToRnnPreProcessor(c.getHeight(), c.getWidth(), c.getChannels());
            }
        }
        throw new RuntimeException("Unknown input type: " + inputType);
    }
}

