/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bytedeco.javacpp.Pointer;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.util.GraphIndices;
import org.deeplearning4j.nn.graph.vertex.GraphVertex;
import org.deeplearning4j.nn.graph.vertex.impl.LayerVertex;
import org.deeplearning4j.nn.layers.LayerHelper;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.nn.updater.BaseMultiLayerUpdater;
import org.deeplearning4j.nn.updater.UpdaterBlock;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.optimize.solvers.BaseOptimizer;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.util.StringUtils;
import org.nd4j.versioncheck.VersionCheck;
import org.nd4j.versioncheck.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.software.os.OperatingSystem;

public class CrashReportingUtil {
    private static final Logger log = LoggerFactory.getLogger(CrashReportingUtil.class);
    private static boolean crashDumpsEnabled = true;
    private static File crashDumpRootDirectory;
    private static final String FORMAT = "%-40s%s";

    private CrashReportingUtil() {
    }

    public static void crashDumpsEnabled(boolean enabled) {
        crashDumpsEnabled = enabled;
    }

    public static void crashDumpOutputDirectory(File rootDir) {
        if (rootDir == null) {
            String userDir = System.getProperty("user.dir");
            if (userDir == null) {
                userDir = "";
            }
            crashDumpRootDirectory = new File(userDir);
            return;
        }
        crashDumpRootDirectory = rootDir;
    }

    public static void writeMemoryCrashDump(@NonNull Model net, @NonNull Throwable e) {
        if (net == null) {
            throw new NullPointerException("net is marked @NonNull but is null");
        }
        if (e == null) {
            throw new NullPointerException("e is marked @NonNull but is null");
        }
        if (!crashDumpsEnabled) {
            return;
        }
        long now = System.currentTimeMillis();
        long tid = Thread.currentThread().getId();
        String threadName = Thread.currentThread().getName();
        crashDumpRootDirectory.mkdirs();
        File f = new File(crashDumpRootDirectory, "dl4j-memory-crash-dump-" + now + "_" + tid + ".txt");
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        sb.append("Deeplearning4j OOM Exception Encountered for ").append(net.getClass().getSimpleName()).append("\n").append(CrashReportingUtil.f("Timestamp: ", sdf.format(now))).append(CrashReportingUtil.f("Thread ID", tid)).append(CrashReportingUtil.f("Thread Name", threadName)).append("\n\n");
        sb.append("Stack Trace:\n").append(ExceptionUtils.getStackTrace((Throwable)e));
        try {
            sb.append("\n\n");
            sb.append(CrashReportingUtil.generateMemoryStatus(net, -1, null));
        }
        catch (Throwable t) {
            sb.append("<Error generating network memory status information section>").append(ExceptionUtils.getStackTrace((Throwable)t));
        }
        String toWrite = sb.toString();
        try {
            FileUtils.writeStringToFile((File)f, (String)toWrite);
        }
        catch (IOException e2) {
            log.error("Error writing memory crash dump information to disk: {}", (Object)f.getAbsolutePath(), (Object)e2);
        }
        log.error(">>> Out of Memory Exception Detected. Memory crash dump written to: {}", (Object)f.getAbsolutePath());
        log.warn("Memory crash dump reporting can be disabled with CrashUtil.crashDumpsEnabled(false) or using system property -Dorg.deeplearning4j.crash.reporting.enabled=false");
        log.warn("Memory crash dump reporting output location can be set with CrashUtil.crashDumpOutputDirectory(File) or using system property -Dorg.deeplearning4j.crash.reporting.directory=<path>");
    }

    public static String generateMemoryStatus(Model net, int minibatch, InputType ... inputTypes) {
        int bytesPerElement;
        boolean isMLN;
        MultiLayerNetwork mln = null;
        ComputationGraph cg = null;
        if (net instanceof MultiLayerNetwork) {
            mln = (MultiLayerNetwork)net;
            isMLN = true;
        } else {
            cg = (ComputationGraph)net;
            isMLN = false;
        }
        StringBuilder sb = CrashReportingUtil.genericMemoryStatus();
        switch (Nd4j.dataType()) {
            case DOUBLE: {
                bytesPerElement = 8;
                break;
            }
            case FLOAT: {
                bytesPerElement = 4;
                break;
            }
            case HALF: {
                bytesPerElement = 2;
                break;
            }
            default: {
                bytesPerElement = 0;
            }
        }
        sb.append("\n----- Workspace Information -----\n");
        List allWs = Nd4j.getWorkspaceManager().getAllWorkspacesForCurrentThread();
        sb.append(CrashReportingUtil.f("Workspaces: # for current thread", allWs == null ? 0 : allWs.size()));
        long totalWsSize = 0L;
        if (allWs != null && allWs.size() > 0) {
            sb.append("Current thread workspaces:\n");
            String wsFormat = "  %-26s%-12s%-30s%-20s";
            sb.append(String.format(wsFormat, "Name", "State", "Size", "# Cycles")).append("\n");
            for (MemoryWorkspace ws : allWs) {
                totalWsSize += ws.getCurrentSize();
                long numCycles = ws.getGenerationId();
                sb.append(String.format(wsFormat, ws.getId(), ws.isScopeActive() ? "OPEN" : "CLOSED", CrashReportingUtil.fBytes(ws.getCurrentSize()), String.valueOf(numCycles))).append("\n");
            }
        }
        sb.append(CrashReportingUtil.fBytes("Workspaces total size", totalWsSize));
        Map<String, Pointer> helperWorkspaces = isMLN ? mln.getHelperWorkspaces() : cg.getHelperWorkspaces();
        if (helperWorkspaces != null && !helperWorkspaces.isEmpty()) {
            boolean header = false;
            for (Map.Entry<String, Pointer> e : helperWorkspaces.entrySet()) {
                Pointer p = e.getValue();
                if (p == null) continue;
                if (!header) {
                    sb.append("Helper Workspaces\n");
                    header = true;
                }
                sb.append("  ").append(CrashReportingUtil.fBytes(e.getKey(), p.capacity()));
            }
        }
        long sumMem = 0L;
        long nParams = net.params().length();
        sb.append("\n----- Network Information -----\n").append(CrashReportingUtil.f("Network # Parameters", nParams)).append(CrashReportingUtil.fBytes("Parameter Memory", (long)bytesPerElement * nParams));
        INDArray flattenedGradients = isMLN ? mln.getFlattenedGradients() : cg.getFlattenedGradients();
        if (flattenedGradients == null) {
            sb.append(CrashReportingUtil.f("Parameter Gradients Memory", "<not allocated>"));
        } else {
            sumMem += flattenedGradients.length() * (long)bytesPerElement;
            sb.append(CrashReportingUtil.fBytes("Parameter Gradients Memory", (long)bytesPerElement * flattenedGradients.length()));
        }
        BaseMultiLayerUpdater u = isMLN ? (BaseMultiLayerUpdater)mln.getUpdater(false) : cg.getUpdater(false);
        HashSet<String> updaterClasses = new HashSet<String>();
        if (u == null) {
            sb.append(CrashReportingUtil.f("Updater", "<not initialized>"));
        } else {
            INDArray stateArr = u.getStateViewArray();
            long stateArrLength = stateArr == null ? 0L : stateArr.length();
            sb.append(CrashReportingUtil.f("Updater Number of Elements", stateArrLength));
            sb.append(CrashReportingUtil.fBytes("Updater Memory", stateArrLength * (long)bytesPerElement));
            sumMem += stateArrLength * (long)bytesPerElement;
            List<UpdaterBlock> blocks = u.getUpdaterBlocks();
            for (UpdaterBlock ub : blocks) {
                updaterClasses.add(ub.getGradientUpdater().getClass().getName());
            }
            sb.append("Updater Classes:").append("\n");
            for (String s : updaterClasses) {
                sb.append("  ").append(s).append("\n");
            }
        }
        sb.append(CrashReportingUtil.fBytes("Params + Gradient + Updater Memory", sumMem));
        sb.append(CrashReportingUtil.f("Iteration Count", BaseOptimizer.getIterationCount(net)));
        sb.append(CrashReportingUtil.f("Epoch Count", BaseOptimizer.getEpochCount(net)));
        if (isMLN) {
            sb.append(CrashReportingUtil.f("Backprop Type", (Object)mln.getLayerWiseConfigurations().getBackpropType()));
            if (mln.getLayerWiseConfigurations().getBackpropType() == BackpropType.TruncatedBPTT) {
                sb.append(CrashReportingUtil.f("TBPTT Length", mln.getLayerWiseConfigurations().getTbpttFwdLength() + "/" + mln.getLayerWiseConfigurations().getTbpttBackLength()));
            }
            sb.append(CrashReportingUtil.f("Workspace Mode: Training", (Object)mln.getLayerWiseConfigurations().getTrainingWorkspaceMode()));
            sb.append(CrashReportingUtil.f("Workspace Mode: Inference", (Object)mln.getLayerWiseConfigurations().getInferenceWorkspaceMode()));
            CrashReportingUtil.appendLayerInformation(sb, mln.getLayers(), bytesPerElement);
            CrashReportingUtil.appendHelperInformation(sb, mln.getLayers());
            CrashReportingUtil.appendActivationShapes(mln, inputTypes == null || inputTypes.length == 0 ? null : inputTypes[0], minibatch, sb, bytesPerElement);
        } else {
            sb.append(CrashReportingUtil.f("Backprop Type", (Object)cg.getConfiguration().getBackpropType()));
            if (cg.getConfiguration().getBackpropType() == BackpropType.TruncatedBPTT) {
                sb.append(CrashReportingUtil.f("TBPTT Length", cg.getConfiguration().getTbpttFwdLength() + "/" + cg.getConfiguration().getTbpttBackLength()));
            }
            sb.append(CrashReportingUtil.f("Workspace Mode: Training", (Object)cg.getConfiguration().getTrainingWorkspaceMode()));
            sb.append(CrashReportingUtil.f("Workspace Mode: Inference", (Object)cg.getConfiguration().getInferenceWorkspaceMode()));
            CrashReportingUtil.appendLayerInformation(sb, cg.getLayers(), bytesPerElement);
            CrashReportingUtil.appendHelperInformation(sb, cg.getLayers());
            CrashReportingUtil.appendActivationShapes(cg, sb, bytesPerElement);
        }
        Collection<TrainingListener> listeners = isMLN ? mln.getListeners() : cg.getListeners();
        sb.append("\n----- Network Training Listeners -----\n");
        sb.append(CrashReportingUtil.f("Number of Listeners", listeners == null ? 0 : listeners.size()));
        int lCount = 0;
        if (listeners != null && !listeners.isEmpty()) {
            for (TrainingListener tl : listeners) {
                sb.append(CrashReportingUtil.f("Listener " + lCount++, tl));
            }
        }
        return sb.toString();
    }

    private static String f(String s1, Object o) {
        return String.format(FORMAT, s1, o == null ? "null" : o.toString()) + "\n";
    }

    private static String fBytes(long bytes) {
        String s = StringUtils.TraditionalBinaryPrefix.long2String((long)bytes, (String)"B", (int)2);
        String format = "%10s";
        s = String.format(format, s);
        if (bytes >= 1024L) {
            s = s + " (" + bytes + ")";
        }
        return s;
    }

    private static String fBytes(String s1, long bytes) {
        String s = CrashReportingUtil.fBytes(bytes);
        return CrashReportingUtil.f(s1, s);
    }

    private static StringBuilder genericMemoryStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("========== Memory Information ==========\n");
        sb.append("----- Version Information -----\n");
        Pair<String, String> pair = CrashReportingUtil.inferVersion();
        sb.append(CrashReportingUtil.f("Deeplearning4j Version", pair.getFirst() == null ? "<could not determine>" : (String)pair.getFirst()));
        sb.append(CrashReportingUtil.f("Deeplearning4j CUDA", pair.getSecond() == null ? "<not present>" : (String)pair.getSecond()));
        sb.append("\n----- System Information -----\n");
        SystemInfo sys = new SystemInfo();
        OperatingSystem os = sys.getOperatingSystem();
        String procName = sys.getHardware().getProcessor().getName();
        long totalMem = sys.getHardware().getMemory().getTotal();
        sb.append(CrashReportingUtil.f("Operating System", os.getManufacturer() + " " + os.getFamily() + " " + os.getVersion().getVersion()));
        sb.append(CrashReportingUtil.f("CPU", procName));
        sb.append(CrashReportingUtil.f("CPU Cores - Physical", sys.getHardware().getProcessor().getPhysicalProcessorCount()));
        sb.append(CrashReportingUtil.f("CPU Cores - Logical", sys.getHardware().getProcessor().getLogicalProcessorCount()));
        sb.append(CrashReportingUtil.fBytes("Total System Memory", totalMem));
        NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
        int nDevices = nativeOps.getAvailableDevices();
        if (nDevices > 0) {
            sb.append(CrashReportingUtil.f("Number of GPUs Detected", nDevices));
            String fGpu = "  %-30s %-5s %24s %24s %24s";
            sb.append(String.format(fGpu, "Name", "CC", "Total Memory", "Used Memory", "Free Memory")).append("\n");
            for (int i = 0; i < nDevices; ++i) {
                try {
                    Class<?> c = Class.forName("org.nd4j.jita.allocator.pointers.CudaPointer");
                    Constructor<?> constructor = c.getConstructor(Long.TYPE);
                    Pointer p = (Pointer)constructor.newInstance(i);
                    String name = nativeOps.getDeviceName(p);
                    long total = nativeOps.getDeviceTotalMemory(p);
                    long free = nativeOps.getDeviceFreeMemory(p);
                    long current = total - free;
                    int major = nativeOps.getDeviceMajor(p);
                    int minor = nativeOps.getDeviceMinor(p);
                    sb.append(String.format(fGpu, name, major + "." + minor, CrashReportingUtil.fBytes(total), CrashReportingUtil.fBytes(current), CrashReportingUtil.fBytes(free))).append("\n");
                    continue;
                }
                catch (Exception e) {
                    sb.append("  Failed to get device info for device ").append(i).append("\n");
                }
            }
        }
        sb.append("\n----- ND4J Environment Information -----\n");
        sb.append(CrashReportingUtil.f("Data Type", Nd4j.dataType()));
        Properties p = Nd4j.getExecutioner().getEnvironmentInformation();
        for (String s : p.stringPropertyNames()) {
            sb.append(CrashReportingUtil.f(s, p.get(s)));
        }
        sb.append("\n----- Memory Configuration -----\n");
        long xmx = Runtime.getRuntime().maxMemory();
        long jvmTotal = Runtime.getRuntime().totalMemory();
        long javacppMaxPhys = Pointer.maxPhysicalBytes();
        long javacppMaxBytes = Pointer.maxBytes();
        long javacppCurrPhys = Pointer.physicalBytes();
        long javacppCurrBytes = Pointer.totalBytes();
        sb.append(CrashReportingUtil.fBytes("JVM Memory: XMX", xmx)).append(CrashReportingUtil.fBytes("JVM Memory: current", jvmTotal)).append(CrashReportingUtil.fBytes("JavaCPP Memory: Max Bytes", javacppMaxBytes)).append(CrashReportingUtil.fBytes("JavaCPP Memory: Max Physical", javacppMaxPhys)).append(CrashReportingUtil.fBytes("JavaCPP Memory: Current Bytes", javacppCurrBytes)).append(CrashReportingUtil.fBytes("JavaCPP Memory: Current Physical", javacppCurrPhys));
        boolean periodicGcEnabled = Nd4j.getMemoryManager().isPeriodicGcActive();
        long autoGcWindow = Nd4j.getMemoryManager().getAutoGcWindow();
        sb.append(CrashReportingUtil.f("Periodic GC Enabled", periodicGcEnabled));
        if (periodicGcEnabled) {
            sb.append(CrashReportingUtil.f("Periodic GC Frequency", autoGcWindow + " ms"));
        }
        return sb;
    }

    private static void appendLayerInformation(StringBuilder sb, Layer[] layers, int bytesPerElement) {
        HashMap<String, Integer> layerClasses = new HashMap<String, Integer>();
        for (Layer l : layers) {
            if (!layerClasses.containsKey(l.getClass().getSimpleName())) {
                layerClasses.put(l.getClass().getSimpleName(), 0);
            }
            layerClasses.put(l.getClass().getSimpleName(), (Integer)layerClasses.get(l.getClass().getSimpleName()) + 1);
        }
        ArrayList l = new ArrayList(layerClasses.keySet());
        Collections.sort(l);
        sb.append(CrashReportingUtil.f("Number of Layers", layers.length));
        sb.append("Layer Counts\n");
        for (String s : l) {
            sb.append("  ").append(CrashReportingUtil.f(s, layerClasses.get(s)));
        }
        sb.append("Layer Parameter Breakdown\n");
        String format = "  %-3s %-20s %-20s %-20s %-20s";
        sb.append(String.format(format, "Idx", "Name", "Layer Type", "Layer # Parameters", "Layer Parameter Memory")).append("\n");
        for (Layer layer : layers) {
            long numParams = layer.numParams();
            sb.append(String.format(format, layer.getIndex(), layer.conf().getLayer().getLayerName(), layer.getClass().getSimpleName(), String.valueOf(numParams), CrashReportingUtil.fBytes(numParams * (long)bytesPerElement))).append("\n");
        }
    }

    private static void appendHelperInformation(StringBuilder sb, Layer[] layers) {
        sb.append("\n----- Layer Helpers - Memory Use -----\n");
        int helperCount = 0;
        long helperWithMemCount = 0L;
        long totalHelperMem = 0L;
        String format = "%-3s %-20s %-25s %-30s %-12s %s";
        boolean header = false;
        for (Layer l : layers) {
            LayerHelper h = l.getHelper();
            if (h == null) continue;
            ++helperCount;
            Map<String, Long> mem = h.helperMemoryUse();
            if (mem == null || mem.isEmpty()) continue;
            ++helperWithMemCount;
            long layerTotal = 0L;
            for (Long m : mem.values()) {
                layerTotal += m.longValue();
            }
            int idx = l.getIndex();
            String layerName = l.conf().getLayer().getLayerName();
            if (layerName == null) {
                layerName = String.valueOf(idx);
            }
            if (!header) {
                sb.append(String.format(format, "#", "Layer Name", "Layer Class", "Helper Class", "Total Memory", "Memory Breakdown")).append("\n");
                header = true;
            }
            sb.append(String.format(format, idx, layerName, l.getClass().getSimpleName(), h.getClass().getSimpleName(), CrashReportingUtil.fBytes(layerTotal), mem.toString())).append("\n");
            totalHelperMem += layerTotal;
        }
        sb.append(CrashReportingUtil.f("Total Helper Count", helperCount));
        sb.append(CrashReportingUtil.f("Helper Count w/ Memory", helperWithMemCount));
        sb.append(CrashReportingUtil.fBytes("Total Helper Persistent Memory Use", totalHelperMem));
    }

    private static void appendActivationShapes(MultiLayerNetwork net, InputType inputType, int minibatch, StringBuilder sb, int bytesPerElement) {
        long[] inputShape;
        INDArray input = net.getInput();
        if (input == null && inputType == null) {
            return;
        }
        sb.append("\n----- Network Activations: Inferred Activation Shapes -----\n");
        if (inputType == null) {
            inputType = InputType.inferInputType(input);
            if (minibatch <= 0) {
                minibatch = (int)input.size(0);
            }
        }
        if (input != null) {
            inputShape = input.shape();
        } else {
            inputShape = inputType.getShape(true);
            inputShape[0] = minibatch;
        }
        sb.append(CrashReportingUtil.f("Current Minibatch Size", minibatch));
        sb.append(CrashReportingUtil.f("Input Shape", Arrays.toString(inputShape)));
        List<InputType> inputTypes = net.getLayerWiseConfigurations().getLayerActivationTypes(inputType);
        String format = "%-3s %-20s %-20s %-42s %-20s %-12s %-12s";
        sb.append(String.format(format, "Idx", "Name", "Layer Type", "Activations Type", "Activations Shape", "# Elements", "Memory")).append("\n");
        Layer[] layers = net.getLayers();
        long totalActivationBytes = 0L;
        long last = 0L;
        for (int i = 0; i < inputTypes.size(); ++i) {
            long[] shape = inputTypes.get(i).getShape(true);
            if (shape[0] <= 0L) {
                shape[0] = minibatch;
            }
            long numElements = ArrayUtil.prodLong((long[])shape);
            long bytes = numElements * (long)bytesPerElement;
            totalActivationBytes += bytes;
            sb.append(String.format(format, String.valueOf(i), layers[i].conf().getLayer().getLayerName(), layers[i].getClass().getSimpleName(), inputTypes.get(i), Arrays.toString(shape), String.valueOf(numElements), CrashReportingUtil.fBytes(bytes))).append("\n");
            last = bytes;
        }
        sb.append(CrashReportingUtil.fBytes("Total Activations Memory", totalActivationBytes));
        sb.append(CrashReportingUtil.fBytes("Total Activations Memory (per ex)", totalActivationBytes / (long)minibatch));
        long totalActivationGradMem = totalActivationBytes - last + ArrayUtil.prodLong((long[])inputShape) * (long)bytesPerElement;
        sb.append(CrashReportingUtil.fBytes("Total Activation Gradient Mem.", totalActivationGradMem));
        sb.append(CrashReportingUtil.fBytes("Total Activation Gradient Mem. (per ex)", totalActivationGradMem / (long)minibatch));
    }

    private static void appendActivationShapes(ComputationGraph net, StringBuilder sb, int bytesPerElement) {
        INDArray[] input = net.getInputs();
        if (input == null) {
            return;
        }
        for (int i = 0; i < input.length; ++i) {
            if (input[i] != null) continue;
            return;
        }
        sb.append("\n----- Network Activations: Inferred Activation Shapes -----\n");
        InputType[] inputType = InputType.inferInputTypes(input);
        sb.append(CrashReportingUtil.f("Current Minibatch Size", input[0].size(0)));
        for (int i = 0; i < input.length; ++i) {
            sb.append(CrashReportingUtil.f("Current Input Shape (Input " + i + ")", Arrays.toString(input[i].shape())));
        }
        Map<String, InputType> inputTypes = net.getConfiguration().getLayerActivationTypes(inputType);
        GraphIndices indices = net.calculateIndices();
        String format = "%-3s %-20s %-20s %-42s %-20s %-12s %-12s";
        sb.append(String.format(format, "Idx", "Name", "Layer Type", "Activations Type", "Activations Shape", "# Elements", "Memory")).append("\n");
        Layer[] layers = net.getLayers();
        long totalActivationBytes = 0L;
        long totalExOutput = 0L;
        int[] topo = indices.getTopologicalSortOrder();
        for (int i = 0; i < topo.length; ++i) {
            String layerName = indices.getIdxToName().get(i);
            GraphVertex gv = net.getVertex(layerName);
            InputType it = inputTypes.get(layerName);
            long[] shape = it.getShape(true);
            if (shape[0] <= 0L) {
                shape[0] = input[0].size(0);
            }
            long numElements = ArrayUtil.prodLong((long[])shape);
            long bytes = numElements * (long)bytesPerElement;
            totalActivationBytes += bytes;
            String className = gv instanceof LayerVertex ? gv.getLayer().getClass().getSimpleName() : gv.getClass().getSimpleName();
            sb.append(String.format(format, String.valueOf(i), layerName, className, it, Arrays.toString(shape), String.valueOf(numElements), CrashReportingUtil.fBytes(bytes))).append("\n");
            if (net.getConfiguration().getNetworkOutputs().contains(layerName)) continue;
            totalExOutput += bytes;
        }
        sb.append(CrashReportingUtil.fBytes("Total Activations Memory", totalActivationBytes));
        sb.append(CrashReportingUtil.fBytes("Total Activation Gradient Memory", totalExOutput));
    }

    public static Pair<String, String> inferVersion() {
        List vi = VersionCheck.getVersionInfos();
        String dl4jVersion = null;
        String dl4jCudaArtifact = null;
        for (VersionInfo v : vi) {
            if ("org.deeplearning4j".equals(v.getGroupId()) && "deeplearning4j-core".equals(v.getArtifactId())) {
                String version = v.getBuildVersion();
                if (version.contains("SNAPSHOT")) {
                    dl4jVersion = version + " (" + v.getCommitIdAbbrev() + ")";
                }
                dl4jVersion = version;
                continue;
            }
            if (!"org.deeplearning4j".equals(v.getGroupId()) || v.getArtifactId() == null || !v.getArtifactId().contains("deeplearning4j-cuda")) continue;
            dl4jCudaArtifact = v.getArtifactId();
        }
        return new Pair(dl4jVersion, dl4jCudaArtifact);
    }

    public static boolean isCrashDumpsEnabled() {
        return crashDumpsEnabled;
    }

    public static File getCrashDumpRootDirectory() {
        return crashDumpRootDirectory;
    }

    static {
        String s = System.getProperty("org.deeplearning4j.crash.reporting.enabled");
        if (s != null && !s.isEmpty()) {
            crashDumpsEnabled = Boolean.parseBoolean(s);
        }
        s = System.getProperty("org.deeplearning4j.crash.reporting.directory");
        boolean setDir = false;
        if (s != null && !s.isEmpty()) {
            try {
                File f = new File(s);
                CrashReportingUtil.crashDumpOutputDirectory(f);
                setDir = true;
                log.debug("Crash dump output directory set to: {}", (Object)f.getAbsolutePath());
            }
            catch (Exception e) {
                log.warn("Error setting crash dump output directory to value: {}", (Object)s, (Object)e);
            }
        }
        if (!setDir) {
            CrashReportingUtil.crashDumpOutputDirectory(null);
        }
    }
}

