/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.recurrent;

import java.util.Arrays;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseOutputLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.TimeSeriesUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.primitives.Pair;

public class RnnOutputLayer
extends BaseOutputLayer<org.deeplearning4j.nn.conf.layers.RnnOutputLayer> {
    public RnnOutputLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public RnnOutputLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        this.applyDropOutIfNecessary(true, workspaceMgr);
        if (this.input.rank() != 3) {
            throw new UnsupportedOperationException("Input is not rank 3. RnnOutputLayer expects rank 3 input with shape [minibatch, layerInSize, sequenceLength]. Got input with rank " + this.input.rank() + " and shape " + Arrays.toString(this.input.shape()) + " - " + this.layerId());
        }
        INDArray inputTemp = this.input;
        this.input = TimeSeriesUtils.reshape3dTo2d(this.input, workspaceMgr, ArrayType.BP_WORKING_MEM);
        Pair<Gradient, INDArray> gradAndEpsilonNext = super.backpropGradient(epsilon, workspaceMgr);
        this.input = inputTemp;
        INDArray epsilon2d = (INDArray)gradAndEpsilonNext.getSecond();
        INDArray epsilon3d = TimeSeriesUtils.reshape2dTo3d(epsilon2d, (int)this.input.size(0), workspaceMgr, ArrayType.ACTIVATION_GRAD);
        this.weightNoiseParams.clear();
        return new Pair(gradAndEpsilonNext.getFirst(), (Object)epsilon3d);
    }

    @Override
    public double f1Score(INDArray examples, INDArray labels) {
        if (examples.rank() == 3) {
            examples = TimeSeriesUtils.reshape3dTo2d(examples, LayerWorkspaceMgr.noWorkspaces(), ArrayType.ACTIVATIONS);
        }
        if (labels.rank() == 3) {
            labels = TimeSeriesUtils.reshape3dTo2d(labels, LayerWorkspaceMgr.noWorkspaces(), ArrayType.ACTIVATIONS);
        }
        return super.f1Score(examples, labels);
    }

    @Override
    public INDArray getInput() {
        return this.input;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.RECURRENT;
    }

    @Override
    protected INDArray preOutput2d(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        if (this.input.rank() == 3) {
            INDArray inputTemp = this.input;
            this.input = TimeSeriesUtils.reshape3dTo2d(this.input, workspaceMgr, ArrayType.FF_WORKING_MEM);
            INDArray out = super.preOutput(training, workspaceMgr);
            this.input = inputTemp;
            return out;
        }
        INDArray out = super.preOutput(training, workspaceMgr);
        return out;
    }

    @Override
    protected INDArray getLabels2d(LayerWorkspaceMgr workspaceMgr, ArrayType arrayType) {
        if (this.labels.rank() == 3) {
            return TimeSeriesUtils.reshape3dTo2d(this.labels, workspaceMgr, arrayType);
        }
        return this.labels;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        if (this.input.rank() != 3) {
            throw new UnsupportedOperationException("Input must be rank 3. Got input with rank " + this.input.rank() + " " + this.layerId());
        }
        INDArray b = this.getParamWithNoise("b", training, workspaceMgr);
        INDArray W = this.getParamWithNoise("W", training, workspaceMgr);
        this.applyDropOutIfNecessary(training, workspaceMgr);
        INDArray input2d = TimeSeriesUtils.reshape3dTo2d(this.input, LayerWorkspaceMgr.noWorkspaces(), ArrayType.FF_WORKING_MEM);
        INDArray act2d = ((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getActivationFn().getActivation(input2d.mmul(W).addiRowVector(b), training);
        if (this.maskArray != null) {
            if (!this.maskArray.isColumnVectorOrScalar() || Arrays.equals(this.maskArray.shape(), act2d.shape())) {
                act2d.muli(this.maskArray);
            } else {
                act2d.muliColumnVector(this.maskArray);
            }
        }
        return TimeSeriesUtils.reshape2dTo3d(act2d, (int)this.input.size(0), workspaceMgr, ArrayType.ACTIVATIONS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setMaskArray(INDArray maskArray) {
        if (maskArray != null) {
            if (maskArray.rank() == 2) {
                this.maskArray = TimeSeriesUtils.reshapeTimeSeriesMaskToVector(maskArray, LayerWorkspaceMgr.noWorkspacesImmutable(), ArrayType.INPUT);
                return;
            } else {
                if (maskArray.rank() != 3) throw new UnsupportedOperationException("Invalid mask array: must be rank 2 or 3 (got: rank " + maskArray.rank() + ", shape = " + Arrays.toString(maskArray.shape()) + ") " + this.layerId());
                this.maskArray = TimeSeriesUtils.reshape3dTo2d(maskArray, LayerWorkspaceMgr.noWorkspacesImmutable(), ArrayType.INPUT);
            }
            return;
        } else {
            this.maskArray = null;
        }
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        if (maskArray != null && currentMaskState == MaskState.Active) {
            this.inputMaskArray = TimeSeriesUtils.reshapeTimeSeriesMaskToVector(maskArray, LayerWorkspaceMgr.noWorkspacesImmutable(), ArrayType.INPUT);
            this.inputMaskArrayState = currentMaskState;
        } else {
            this.inputMaskArray = null;
            this.inputMaskArrayState = null;
        }
        return null;
    }

    @Override
    public INDArray computeScoreForExamples(double fullNetworkL1, double fullNetworkL2, LayerWorkspaceMgr workspaceMgr) {
        if (this.input == null || this.labels == null) {
            throw new IllegalStateException("Cannot calculate score without input and labels " + this.layerId());
        }
        INDArray preOut = this.preOutput2d(false, workspaceMgr);
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getLossFn();
        INDArray scoreArray = lossFunction.computeScoreArray(this.getLabels2d(workspaceMgr, ArrayType.FF_WORKING_MEM), preOut, ((org.deeplearning4j.nn.conf.layers.RnnOutputLayer)this.layerConf()).getActivationFn(), this.maskArray);
        INDArray scoreArrayTs = TimeSeriesUtils.reshapeVectorToTimeSeriesMask(scoreArray, (int)this.input.size(0));
        INDArray summedScores = scoreArrayTs.sum(new int[]{1});
        double l1l2 = fullNetworkL1 + fullNetworkL2;
        if (l1l2 != 0.0) {
            summedScores.addi((Number)l1l2);
        }
        return summedScores;
    }
}

