/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.Convolution1DUtils;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Convolution1DLayer
extends ConvolutionLayer {
    private Convolution1DLayer(Builder builder) {
        super(builder);
        this.initializeConstraints(builder);
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        LayerValidation.assertNInNOutSet("Convolution1DLayer", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        org.deeplearning4j.nn.layers.convolution.Convolution1DLayer ret = new org.deeplearning4j.nn.layers.convolution.Convolution1DLayer(conf);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.RNN) {
            throw new IllegalStateException("Invalid input for 1D CNN layer (layer index = " + layerIndex + ", layer name = \"" + this.getLayerName() + "\"): expect RNN input type with size > 0. Got: " + inputType);
        }
        InputType.InputTypeRecurrent it = (InputType.InputTypeRecurrent)inputType;
        long inputTsLength = it.getTimeSeriesLength();
        long outLength = inputTsLength < 0L ? -1L : (long)Convolution1DUtils.getOutputSize((int)inputTsLength, this.kernelSize[0], this.stride[0], this.padding[0], this.convolutionMode, this.dilation[0]);
        return InputType.recurrent(this.nOut, outLength);
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        if (inputType == null || inputType.getType() != InputType.Type.RNN) {
            throw new IllegalStateException("Invalid input for 1D CNN layer (layer name = \"" + this.getLayerName() + "\"): expect RNN input type with size > 0. Got: " + inputType);
        }
        if (this.nIn <= 0L || override) {
            InputType.InputTypeRecurrent r = (InputType.InputTypeRecurrent)inputType;
            this.nIn = r.getSize();
        }
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for Convolution1D layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreprocessorForInputTypeRnnLayers(inputType, this.getLayerName());
    }

    public Convolution1DLayer() {
    }

    @Override
    public String toString() {
        return "Convolution1DLayer(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Convolution1DLayer)) {
            return false;
        }
        Convolution1DLayer other = (Convolution1DLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Convolution1DLayer;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class Builder
    extends ConvolutionLayer.BaseConvBuilder<Builder> {
        public Builder() {
            this(0, 1, 0);
            this.kernelSize = null;
        }

        public Builder(int kernelSize, int stride) {
            this(kernelSize, stride, 0);
        }

        public Builder(int kernelSize) {
            this(kernelSize, 1, 0);
        }

        public Builder(int kernelSize, int stride, int padding) {
            this.kernelSize = new int[]{kernelSize, 1};
            this.stride = new int[]{stride, 1};
            this.padding = new int[]{padding, 0};
        }

        public Builder kernelSize(int kernelSize) {
            this.kernelSize = new int[]{kernelSize, 1};
            return this;
        }

        public Builder stride(int stride) {
            this.stride[0] = stride;
            return this;
        }

        public Builder padding(int padding) {
            this.padding[0] = padding;
            return this;
        }

        @Override
        public Convolution1DLayer build() {
            ConvolutionUtils.validateConvolutionModePadding(this.convolutionMode, this.padding);
            ConvolutionUtils.validateCnnKernelStridePadding(this.kernelSize, this.stride, this.padding);
            return new Convolution1DLayer(this);
        }
    }
}

