/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.nd4j.linalg.lossfunctions.LossFunctions;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(value={"pretrain"})
public abstract class BasePretrainNetwork
extends FeedForwardLayer {
    protected LossFunctions.LossFunction lossFunction;
    protected double visibleBiasInit;
    protected boolean pretrain;

    public BasePretrainNetwork(Builder builder) {
        super(builder);
        this.lossFunction = builder.lossFunction;
        this.visibleBiasInit = builder.visibleBiasInit;
    }

    @Override
    public double getL1ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l1;
            }
            case "b": {
                return this.l1Bias;
            }
            case "vb": {
                return this.l1Bias;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public double getL2ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l2;
            }
            case "b": {
                return this.l2Bias;
            }
            case "vb": {
                return this.l2Bias;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        return "vb".equals(paramName);
    }

    @Override
    public boolean isPretrain() {
        return this.pretrain;
    }

    @Override
    public void setPretrain(boolean pretrain) {
        this.pretrain = pretrain;
    }

    public LossFunctions.LossFunction getLossFunction() {
        return this.lossFunction;
    }

    public double getVisibleBiasInit() {
        return this.visibleBiasInit;
    }

    public void setLossFunction(LossFunctions.LossFunction lossFunction) {
        this.lossFunction = lossFunction;
    }

    public void setVisibleBiasInit(double visibleBiasInit) {
        this.visibleBiasInit = visibleBiasInit;
    }

    public BasePretrainNetwork() {
    }

    @Override
    public String toString() {
        return "BasePretrainNetwork(super=" + super.toString() + ", lossFunction=" + this.getLossFunction() + ", visibleBiasInit=" + this.getVisibleBiasInit() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasePretrainNetwork)) {
            return false;
        }
        BasePretrainNetwork other = (BasePretrainNetwork)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LossFunctions.LossFunction this$lossFunction = this.getLossFunction();
        LossFunctions.LossFunction other$lossFunction = other.getLossFunction();
        if (this$lossFunction == null ? other$lossFunction != null : !this$lossFunction.equals(other$lossFunction)) {
            return false;
        }
        return Double.compare(this.getVisibleBiasInit(), other.getVisibleBiasInit()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BasePretrainNetwork;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LossFunctions.LossFunction $lossFunction = this.getLossFunction();
        result = result * 59 + ($lossFunction == null ? 43 : $lossFunction.hashCode());
        long $visibleBiasInit = Double.doubleToLongBits(this.getVisibleBiasInit());
        result = result * 59 + (int)($visibleBiasInit >>> 32 ^ $visibleBiasInit);
        return result;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends FeedForwardLayer.Builder<T> {
        protected LossFunctions.LossFunction lossFunction = LossFunctions.LossFunction.RECONSTRUCTION_CROSSENTROPY;
        protected double visibleBiasInit = 0.0;

        public T lossFunction(LossFunctions.LossFunction lossFunction) {
            this.lossFunction = lossFunction;
            return (T)this;
        }

        public T visibleBiasInit(double visibleBiasInit) {
            this.visibleBiasInit = visibleBiasInit;
            return (T)this;
        }
    }
}

