/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph;

import java.util.Arrays;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class L2NormalizeVertex
extends GraphVertex {
    public static final double DEFAULT_EPS = 1.0E-8;
    protected int[] dimension;
    protected double eps;

    public L2NormalizeVertex() {
        this(null, 1.0E-8);
    }

    public L2NormalizeVertex(@JsonProperty(value="dimension") int[] dimension, @JsonProperty(value="eps") double eps) {
        this.dimension = dimension;
        this.eps = eps;
    }

    @Override
    public L2NormalizeVertex clone() {
        return new L2NormalizeVertex(this.dimension, this.eps);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof L2NormalizeVertex)) {
            return false;
        }
        return ((L2NormalizeVertex)o).dimension == this.dimension;
    }

    @Override
    public int hashCode() {
        return 123081189;
    }

    @Override
    public long numParams(boolean backprop) {
        return 0L;
    }

    @Override
    public int minVertexInputs() {
        return 1;
    }

    @Override
    public int maxVertexInputs() {
        return 1;
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.GraphVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView, boolean initializeParams) {
        return new org.deeplearning4j.nn.graph.vertex.impl.L2NormalizeVertex(graph, name, idx, this.dimension, this.eps);
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType ... vertexInputs) throws InvalidInputTypeException {
        if (vertexInputs.length == 1) {
            return vertexInputs[0];
        }
        InputType first = vertexInputs[0];
        return first;
    }

    @Override
    public MemoryReport getMemoryReport(InputType ... inputTypes) {
        InputType outputType = this.getOutputType(-1, inputTypes);
        long trainModePerEx = 3L + 2L * inputTypes[0].arrayElementsPerExample();
        return new LayerMemoryReport.Builder(null, L2NormalizeVertex.class, inputTypes[0], outputType).standardMemory(0L, 0L).workingMemory(0L, 1L, 0L, trainModePerEx).cacheMemory(0L, 0L).build();
    }

    public int[] getDimension() {
        return this.dimension;
    }

    public double getEps() {
        return this.eps;
    }

    public void setDimension(int[] dimension) {
        this.dimension = dimension;
    }

    public void setEps(double eps) {
        this.eps = eps;
    }

    public String toString() {
        return "L2NormalizeVertex(dimension=" + Arrays.toString(this.getDimension()) + ", eps=" + this.getEps() + ")";
    }
}

