/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import java.util.Arrays;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class CnnToFeedForwardPreProcessor
implements InputPreProcessor {
    protected long inputHeight;
    protected long inputWidth;
    protected long numChannels;

    @JsonCreator
    public CnnToFeedForwardPreProcessor(@JsonProperty(value="inputHeight") long inputHeight, @JsonProperty(value="inputWidth") long inputWidth, @JsonProperty(value="numChannels") long numChannels) {
        this.inputHeight = inputHeight;
        this.inputWidth = inputWidth;
        this.numChannels = numChannels;
    }

    public CnnToFeedForwardPreProcessor(long inputHeight, long inputWidth) {
        this.inputHeight = inputHeight;
        this.inputWidth = inputWidth;
        this.numChannels = 1L;
    }

    public CnnToFeedForwardPreProcessor() {
    }

    @Override
    public INDArray preProcess(INDArray input, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        if (input.rank() == 2) {
            return input;
        }
        if (input.size(1) != this.numChannels || input.size(2) != this.inputHeight || input.size(3) != this.inputWidth) {
            throw new IllegalStateException("Invalid input array: expected shape [minibatch, channels, height, width] = [minibatch, " + this.numChannels + ", " + this.inputHeight + ", " + this.inputWidth + "] - got " + Arrays.toString(input.shape()));
        }
        if (input.ordering() != 'c' || !Shape.hasDefaultStridesForShape((INDArray)input)) {
            input = workspaceMgr.dup(ArrayType.ACTIVATIONS, input, 'c');
        }
        long[] inShape = input.shape();
        long[] outShape = new long[]{inShape[0], inShape[1] * inShape[2] * inShape[3]};
        return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, input.reshape('c', outShape));
    }

    @Override
    public INDArray backprop(INDArray epsilons, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        if (epsilons.ordering() != 'c' || !Shape.strideDescendingCAscendingF((INDArray)epsilons)) {
            epsilons = workspaceMgr.dup(ArrayType.ACTIVATION_GRAD, epsilons, 'c');
        }
        if (epsilons.rank() == 4) {
            return workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, epsilons);
        }
        if ((long)epsilons.columns() != this.inputWidth * this.inputHeight * this.numChannels) {
            throw new IllegalArgumentException("Invalid input: expect output columns must be equal to rows " + this.inputHeight + " x columns " + this.inputWidth + " x channels " + this.numChannels + " but was instead " + Arrays.toString(epsilons.shape()));
        }
        INDArray ret = epsilons.reshape('c', new long[]{epsilons.size(0), this.numChannels, this.inputHeight, this.inputWidth});
        return workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, ret);
    }

    @Override
    public CnnToFeedForwardPreProcessor clone() {
        try {
            CnnToFeedForwardPreProcessor clone = (CnnToFeedForwardPreProcessor)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputType getOutputType(InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input type: Expected input of type CNN, got " + inputType);
        }
        InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
        long outSize = c.getChannels() * c.getHeight() * c.getWidth();
        return InputType.feedForward(outSize);
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        if (maskArray == null || maskArray.rank() == 2) {
            return new Pair((Object)maskArray, (Object)currentMaskState);
        }
        if (maskArray.rank() != 4 || maskArray.size(2) != 1L || maskArray.size(3) != 1L) {
            throw new UnsupportedOperationException("Expected rank 4 mask array for 2D CNN layer activations. Got rank " + maskArray.rank() + " mask array (shape " + Arrays.toString(maskArray.shape()) + ")  - when used in conjunction with input data of shape [batch,channels,h,w] 4d masks passing through CnnToFeedForwardPreProcessor should have shape [batchSize,1,1,1]");
        }
        return new Pair((Object)maskArray.reshape(maskArray.ordering(), new long[]{maskArray.size(0), maskArray.size(1)}), (Object)currentMaskState);
    }

    public long getInputHeight() {
        return this.inputHeight;
    }

    public long getInputWidth() {
        return this.inputWidth;
    }

    public long getNumChannels() {
        return this.numChannels;
    }

    public void setInputHeight(long inputHeight) {
        this.inputHeight = inputHeight;
    }

    public void setInputWidth(long inputWidth) {
        this.inputWidth = inputWidth;
    }

    public void setNumChannels(long numChannels) {
        this.numChannels = numChannels;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CnnToFeedForwardPreProcessor)) {
            return false;
        }
        CnnToFeedForwardPreProcessor other = (CnnToFeedForwardPreProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInputHeight() != other.getInputHeight()) {
            return false;
        }
        if (this.getInputWidth() != other.getInputWidth()) {
            return false;
        }
        return this.getNumChannels() == other.getNumChannels();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CnnToFeedForwardPreProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $inputHeight = this.getInputHeight();
        result = result * 59 + (int)($inputHeight >>> 32 ^ $inputHeight);
        long $inputWidth = this.getInputWidth();
        result = result * 59 + (int)($inputWidth >>> 32 ^ $inputWidth);
        long $numChannels = this.getNumChannels();
        result = result * 59 + (int)($numChannels >>> 32 ^ $numChannels);
        return result;
    }

    public String toString() {
        return "CnnToFeedForwardPreProcessor(inputHeight=" + this.getInputHeight() + ", inputWidth=" + this.getInputWidth() + ", numChannels=" + this.getNumChannels() + ")";
    }
}

