/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.variational;

import org.deeplearning4j.nn.conf.layers.variational.ReconstructionDistribution;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;

public class ExponentialReconstructionDistribution
implements ReconstructionDistribution {
    private final IActivation activationFn;

    public ExponentialReconstructionDistribution() {
        this("identity");
    }

    @Deprecated
    public ExponentialReconstructionDistribution(String activationFn) {
        this(Activation.fromString((String)activationFn).getActivationFunction());
    }

    public ExponentialReconstructionDistribution(Activation activation) {
        this(activation.getActivationFunction());
    }

    public ExponentialReconstructionDistribution(IActivation activationFn) {
        this.activationFn = activationFn;
    }

    @Override
    public boolean hasLossFunction() {
        return false;
    }

    @Override
    public int distributionInputSize(int dataSize) {
        return dataSize;
    }

    @Override
    public double negLogProbability(INDArray x, INDArray preOutDistributionParams, boolean average) {
        INDArray gamma = preOutDistributionParams.dup();
        this.activationFn.getActivation(gamma, false);
        INDArray lambda = Transforms.exp((INDArray)gamma, (boolean)true);
        double negLogProbSum = -lambda.muli(x).rsubi(gamma).sumNumber().doubleValue();
        if (average) {
            return negLogProbSum / (double)x.size(0);
        }
        return negLogProbSum;
    }

    @Override
    public INDArray exampleNegLogProbability(INDArray x, INDArray preOutDistributionParams) {
        INDArray gamma = preOutDistributionParams.dup();
        this.activationFn.getActivation(gamma, false);
        INDArray lambda = Transforms.exp((INDArray)gamma, (boolean)true);
        return lambda.muli(x).rsubi(gamma).sum(new int[]{1}).negi();
    }

    @Override
    public INDArray gradient(INDArray x, INDArray preOutDistributionParams) {
        INDArray gamma = this.activationFn.getActivation(preOutDistributionParams.dup(), true);
        INDArray lambda = Transforms.exp((INDArray)gamma, (boolean)true);
        INDArray dLdx = x.mul(lambda).subi((Number)1.0);
        return (INDArray)this.activationFn.backprop(preOutDistributionParams.dup(), dLdx).getFirst();
    }

    @Override
    public INDArray generateRandom(INDArray preOutDistributionParams) {
        INDArray gamma = this.activationFn.getActivation(preOutDistributionParams.dup(), false);
        INDArray lambda = Transforms.exp((INDArray)gamma, (boolean)true);
        INDArray u = Nd4j.rand((long[])preOutDistributionParams.shape());
        return Transforms.log((INDArray)u, (boolean)false).divi(lambda).negi();
    }

    @Override
    public INDArray generateAtMean(INDArray preOutDistributionParams) {
        INDArray gamma = this.activationFn.getActivation(preOutDistributionParams.dup(), false);
        INDArray lambda = Transforms.exp((INDArray)gamma, (boolean)true);
        return lambda.rdivi((Number)1.0);
    }

    public String toString() {
        return "ExponentialReconstructionDistribution(afn=" + this.activationFn + ")";
    }

    public IActivation getActivationFn() {
        return this.activationFn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExponentialReconstructionDistribution)) {
            return false;
        }
        ExponentialReconstructionDistribution other = (ExponentialReconstructionDistribution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IActivation this$activationFn = this.getActivationFn();
        IActivation other$activationFn = other.getActivationFn();
        return !(this$activationFn == null ? other$activationFn != null : !this$activationFn.equals(other$activationFn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExponentialReconstructionDistribution;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IActivation $activationFn = this.getActivationFn();
        result = result * 59 + ($activationFn == null ? 43 : $activationFn.hashCode());
        return result;
    }
}

