/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph;

import java.util.Arrays;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.ndarray.INDArray;

public class LayerVertex
extends GraphVertex {
    private NeuralNetConfiguration layerConf;
    private InputPreProcessor preProcessor;
    private boolean outputVertex;

    public LayerVertex(NeuralNetConfiguration layerConf, InputPreProcessor preProcessor) {
        this.layerConf = layerConf;
        this.preProcessor = preProcessor;
    }

    public InputPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    @Override
    public GraphVertex clone() {
        return new LayerVertex(this.layerConf.clone(), this.preProcessor != null ? this.preProcessor.clone() : null);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LayerVertex)) {
            return false;
        }
        LayerVertex lv = (LayerVertex)o;
        if (this.layerConf == null && lv.layerConf != null || this.layerConf != null && lv.layerConf == null) {
            return false;
        }
        if (this.layerConf != null && !this.layerConf.equals(lv.layerConf)) {
            return false;
        }
        if (this.preProcessor == null && lv.preProcessor != null || this.preProcessor != null && lv.preProcessor == null) {
            return false;
        }
        return this.preProcessor == null || this.preProcessor.equals(lv.preProcessor);
    }

    @Override
    public int hashCode() {
        return this.layerConf.hashCode() ^ (this.preProcessor != null ? this.preProcessor.hashCode() : 0);
    }

    @Override
    public int numParams(boolean backprop) {
        return (int)this.layerConf.getLayer().initializer().numParams(this.layerConf);
    }

    @Override
    public int minVertexInputs() {
        return 1;
    }

    @Override
    public int maxVertexInputs() {
        return 1;
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.GraphVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView, boolean initializeParams) {
        boolean isOutput = graph.getConfiguration().getNetworkOutputs().contains(name);
        Layer layer = this.layerConf.getLayer().instantiate(this.layerConf, null, idx, paramsView, initializeParams);
        if (layer == null) {
            throw new IllegalStateException("Encountered null layer during initialization for layer:" + this.layerConf.getLayer().getClass().getSimpleName() + " initialization returned null layer?");
        }
        return new org.deeplearning4j.nn.graph.vertex.impl.LayerVertex(graph, name, idx, layer, this.preProcessor, isOutput);
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType ... vertexInputs) throws InvalidInputTypeException {
        if (vertexInputs.length != 1) {
            throw new InvalidInputTypeException("LayerVertex expects exactly one input. Got: " + Arrays.toString(vertexInputs));
        }
        InputType afterPreprocessor = this.preProcessor == null ? vertexInputs[0] : this.preProcessor.getOutputType(vertexInputs[0]);
        return this.layerConf.getLayer().getOutputType(layerIndex, afterPreprocessor);
    }

    @Override
    public MemoryReport getMemoryReport(InputType ... inputTypes) {
        if (inputTypes.length != 1) {
            throw new IllegalArgumentException("Only one input supported for layer vertices: got " + Arrays.toString(inputTypes));
        }
        InputType it = this.preProcessor != null ? this.preProcessor.getOutputType(inputTypes[0]) : inputTypes[0];
        return this.layerConf.getLayer().getMemoryReport(it);
    }

    public LayerVertex() {
    }

    public NeuralNetConfiguration getLayerConf() {
        return this.layerConf;
    }

    public boolean isOutputVertex() {
        return this.outputVertex;
    }

    public void setLayerConf(NeuralNetConfiguration layerConf) {
        this.layerConf = layerConf;
    }

    public void setPreProcessor(InputPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public void setOutputVertex(boolean outputVertex) {
        this.outputVertex = outputVertex;
    }

    public String toString() {
        return "LayerVertex(layerConf=" + this.getLayerConf() + ", preProcessor=" + this.getPreProcessor() + ", outputVertex=" + this.isOutputVertex() + ")";
    }
}

