/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping.termination;

import java.util.concurrent.TimeUnit;
import org.deeplearning4j.earlystopping.termination.IterationTerminationCondition;

public class MaxTimeIterationTerminationCondition
implements IterationTerminationCondition {
    private long maxTimeAmount;
    private TimeUnit maxTimeUnit;
    private long initializationTime;
    private long endTime;

    public MaxTimeIterationTerminationCondition(long maxTimeAmount, TimeUnit maxTimeUnit) {
        if (maxTimeAmount <= 0L || maxTimeUnit == null) {
            throw new IllegalArgumentException("Invalid maximum training time: amount = " + maxTimeAmount + " unit = " + (Object)((Object)maxTimeUnit));
        }
        this.maxTimeAmount = maxTimeAmount;
        this.maxTimeUnit = maxTimeUnit;
    }

    @Override
    public void initialize() {
        this.initializationTime = System.currentTimeMillis();
        this.endTime = this.initializationTime + this.maxTimeUnit.toMillis(this.maxTimeAmount);
    }

    @Override
    public boolean terminate(double lastMiniBatchScore) {
        return System.currentTimeMillis() >= this.endTime;
    }

    public String toString() {
        return "MaxTimeIterationTerminationCondition(" + this.maxTimeAmount + ",unit=" + (Object)((Object)this.maxTimeUnit) + ")";
    }
}

