/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.distribution.Distributions;
import org.deeplearning4j.nn.conf.layers.Convolution3D;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.params.ConvolutionParamInitializer;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class Convolution3DParamInitializer
extends ConvolutionParamInitializer {
    private static final Convolution3DParamInitializer INSTANCE = new Convolution3DParamInitializer();
    public static final String WEIGHT_KEY = "W";
    public static final String BIAS_KEY = "b";

    public static Convolution3DParamInitializer getInstance() {
        return INSTANCE;
    }

    @Override
    public int numParams(NeuralNetConfiguration conf) {
        return this.numParams(conf.getLayer());
    }

    @Override
    public int numParams(Layer l) {
        Convolution3D layerConf = (Convolution3D)l;
        int[] kernel = layerConf.getKernelSize();
        int nIn = layerConf.getNIn();
        int nOut = layerConf.getNOut();
        return nIn * nOut * kernel[0] * kernel[1] * kernel[2] + (layerConf.hasBias() ? nOut : 0);
    }

    @Override
    public Map<String, INDArray> init(NeuralNetConfiguration conf, INDArray paramsView, boolean initializeParams) {
        Convolution3D layer = (Convolution3D)conf.getLayer();
        if (layer.getKernelSize().length != 3) {
            throw new IllegalArgumentException("Filter size must be == 3");
        }
        Map<String, INDArray> params = Collections.synchronizedMap(new LinkedHashMap());
        Convolution3D layerConf = (Convolution3D)conf.getLayer();
        int nOut = layerConf.getNOut();
        if (layer.hasBias()) {
            INDArray biasView = paramsView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)0, (int)nOut)});
            INDArray weightView = paramsView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)nOut, (int)this.numParams(conf))});
            params.put(BIAS_KEY, this.createBias(conf, biasView, initializeParams));
            params.put(WEIGHT_KEY, this.createWeightMatrix(conf, weightView, initializeParams));
            conf.addVariable(WEIGHT_KEY);
            conf.addVariable(BIAS_KEY);
        } else {
            INDArray weightView = paramsView;
            params.put(WEIGHT_KEY, this.createWeightMatrix(conf, weightView, initializeParams));
            conf.addVariable(WEIGHT_KEY);
        }
        return params;
    }

    @Override
    public Map<String, INDArray> getGradientsFromFlattened(NeuralNetConfiguration conf, INDArray gradientView) {
        Convolution3D layerConf = (Convolution3D)conf.getLayer();
        int[] kernel = layerConf.getKernelSize();
        int nIn = layerConf.getNIn();
        int nOut = layerConf.getNOut();
        LinkedHashMap<String, INDArray> out = new LinkedHashMap<String, INDArray>();
        if (layerConf.hasBias()) {
            INDArray biasGradientView = gradientView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)0, (int)nOut)});
            INDArray weightGradientView = gradientView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)nOut, (int)this.numParams(conf))}).reshape('c', new int[]{nOut, nIn, kernel[0], kernel[1], kernel[2]});
            out.put(BIAS_KEY, biasGradientView);
            out.put(WEIGHT_KEY, weightGradientView);
        } else {
            INDArray weightGradientView = gradientView.reshape('c', new int[]{nOut, nIn, kernel[0], kernel[1], kernel[2]});
            out.put(WEIGHT_KEY, weightGradientView);
        }
        return out;
    }

    @Override
    protected INDArray createWeightMatrix(NeuralNetConfiguration conf, INDArray weightView, boolean initializeParams) {
        Convolution3D layerConf = (Convolution3D)conf.getLayer();
        if (initializeParams) {
            Distribution dist = Distributions.createDistribution(layerConf.getDist());
            int[] kernel = layerConf.getKernelSize();
            int[] stride = layerConf.getStride();
            int inputDepth = layerConf.getNIn();
            int outputDepth = layerConf.getNOut();
            double fanIn = inputDepth * kernel[0] * kernel[1] * kernel[2];
            double fanOut = (double)(outputDepth * kernel[0] * kernel[1] * kernel[2]) / ((double)stride[0] * (double)stride[1] * (double)stride[2]);
            int[] weightsShape = new int[]{outputDepth, inputDepth, kernel[0], kernel[1], kernel[2]};
            return WeightInitUtil.initWeights(fanIn, fanOut, weightsShape, layerConf.getWeightInit(), dist, 'c', weightView);
        }
        int[] kernel = layerConf.getKernelSize();
        return WeightInitUtil.reshapeWeights(new int[]{layerConf.getNOut(), layerConf.getNIn(), kernel[0], kernel[1], kernel[2]}, weightView, 'c');
    }
}

