/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.recurrent;

import java.util.Arrays;
import lombok.NonNull;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.wrapper.BaseWrapperLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.TimeSeriesUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.primitives.Pair;

public class LastTimeStepLayer
extends BaseWrapperLayer {
    private int[] lastTimeStepIdxs;
    private int[] origOutputShape;

    public LastTimeStepLayer(@NonNull Layer underlying) {
        super(underlying);
        if (underlying == null) {
            throw new NullPointerException("underlying");
        }
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.FEED_FORWARD;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        INDArray newEps = Nd4j.create((int[])this.origOutputShape, (char)'f');
        if (this.lastTimeStepIdxs == null) {
            newEps.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.point((int)(this.origOutputShape[2] - 1))}, epsilon);
        } else {
            INDArrayIndex[] arr = new INDArrayIndex[]{null, NDArrayIndex.all(), null};
            for (int i = 0; i < this.lastTimeStepIdxs.length; ++i) {
                arr[0] = NDArrayIndex.point((int)i);
                arr[2] = NDArrayIndex.point((int)this.lastTimeStepIdxs[i]);
                newEps.put(arr, epsilon.getRow(i));
            }
        }
        return this.underlying.backpropGradient(newEps, workspaceMgr);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        return this.getLastStep(this.underlying.activate(training, workspaceMgr), workspaceMgr, ArrayType.ACTIVATIONS);
    }

    @Override
    public INDArray activate(INDArray input, boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray a = this.underlying.activate(input, training, workspaceMgr);
        return this.getLastStep(a, workspaceMgr, ArrayType.ACTIVATIONS);
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        this.underlying.feedForwardMaskArray(maskArray, currentMaskState, minibatchSize);
        return new Pair(null, (Object)currentMaskState);
    }

    private INDArray getLastStep(INDArray in, LayerWorkspaceMgr workspaceMgr, ArrayType arrayType) {
        if (in.rank() != 3) {
            throw new IllegalArgumentException("Expected rank 3 input with shape [minibatch, layerSize, tsLength]. Got rank " + in.rank() + " with shape " + Arrays.toString(in.shape()));
        }
        this.origOutputShape = in.shape();
        INDArray mask = this.underlying.getMaskArray();
        Pair<INDArray, int[]> p = TimeSeriesUtils.pullLastTimeSteps(in, mask, workspaceMgr, arrayType);
        this.lastTimeStepIdxs = (int[])p.getSecond();
        return (INDArray)p.getFirst();
    }
}

