/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.convolution.ConvolutionLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;

public class SeparableConvolution2DLayer
extends ConvolutionLayer {
    public SeparableConvolution2DLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public SeparableConvolution2DLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    void initializeHelper() {
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        DynamicCustomOp op;
        int[] pad;
        this.assertInputSet(true);
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to SubsamplingLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape [minibatchSize, channels, inputHeight, inputWidth]. " + this.layerId());
        }
        INDArray depthWiseWeights = this.getParamWithNoise("W", true, workspaceMgr);
        INDArray pointWiseWeights = this.getParamWithNoise("pW", true, workspaceMgr);
        int miniBatch = this.input.size(0);
        int inH = this.input.size(2);
        int inW = this.input.size(3);
        int inDepth = depthWiseWeights.size(1);
        int kH = depthWiseWeights.size(2);
        int kW = depthWiseWeights.size(3);
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getDilation();
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            int[] outSize = ConvolutionUtils.getOutputSize(this.input, kernel, strides, null, this.convolutionMode, dilation);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{inH, inW}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding();
            ConvolutionUtils.getOutputSize(this.input, kernel, strides, pad, this.convolutionMode, dilation);
        }
        INDArray biasGradView = (INDArray)this.gradientViews.get("b");
        INDArray depthWiseweightGradView = (INDArray)this.gradientViews.get("W");
        INDArray pointWiseweightGradView = (INDArray)this.gradientViews.get("pW");
        INDArray outEpsilon = workspaceMgr.create(ArrayType.ACTIVATION_GRAD, new int[]{miniBatch, inDepth, inH, inW}, 'c');
        Integer sameMode = this.convolutionMode == ConvolutionMode.Same ? 1 : 0;
        int[] args = new int[]{kH, kW, strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], sameMode};
        IActivation afn = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn();
        Pair<INDArray, INDArray> p = this.preOutput4d(true, true, workspaceMgr);
        INDArray delta = (INDArray)afn.backprop((INDArray)p.getFirst(), epsilon).getFirst();
        if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias()) {
            INDArray bias = this.getParamWithNoise("b", true, workspaceMgr);
            op = DynamicCustomOp.builder((String)"sconv2d_bp").addInputs(new INDArray[]{this.input, delta, depthWiseWeights, pointWiseWeights, bias}).addIntegerArguments(args).addOutputs(new INDArray[]{outEpsilon, depthWiseweightGradView, pointWiseweightGradView, biasGradView}).callInplace(false).build();
        } else {
            op = DynamicCustomOp.builder((String)"sconv2d_bp").addInputs(new INDArray[]{this.input, delta, depthWiseWeights, pointWiseWeights}).addIntegerArguments(args).addOutputs(new INDArray[]{outEpsilon, depthWiseweightGradView, pointWiseweightGradView}).callInplace(false).build();
        }
        Nd4j.getExecutioner().exec((CustomOp)op);
        DefaultGradient retGradient = new DefaultGradient();
        if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias()) {
            retGradient.setGradientFor("b", biasGradView);
        }
        retGradient.setGradientFor("W", depthWiseweightGradView, Character.valueOf('c'));
        retGradient.setGradientFor("pW", pointWiseweightGradView, Character.valueOf('c'));
        this.weightNoiseParams.clear();
        return new Pair((Object)retGradient, (Object)outEpsilon);
    }

    @Override
    protected Pair<INDArray, INDArray> preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        int[] pad;
        int[] outSize;
        this.assertInputSet(false);
        INDArray bias = this.getParamWithNoise("b", training, workspaceMgr);
        INDArray depthWiseWeights = this.getParamWithNoise("W", training, workspaceMgr);
        INDArray pointWiseWeights = this.getParamWithNoise("pW", training, workspaceMgr);
        if (this.input.rank() != 4) {
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to SeparableConvolution2D (layer name = " + layerName + ", layer index = " + this.index + ") with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape [minibatchSize, layerInputDepth, inputHeight, inputWidth]." + (this.input.rank() == 2 ? " (Wrong input type (see InputType.convolutionalFlat()) or wrong data type?)" : "") + " " + this.layerId());
        }
        int inDepth = depthWiseWeights.size(1);
        int outDepth = pointWiseWeights.size(0);
        if (this.input.size(1) != inDepth) {
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            throw new DL4JInvalidInputException("Cannot do forward pass in SeparableConvolution2D layer (layer name = " + layerName + ", layer index = " + this.index + "): input array channels does not match CNN layer configuration (data input channels = " + this.input.size(1) + ", [minibatch,inputDepth,height,width]=" + Arrays.toString(this.input.shape()) + "; expected input channels = " + inDepth + ") " + this.layerId());
        }
        int kH = depthWiseWeights.size(2);
        int kW = depthWiseWeights.size(3);
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getDilation();
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            outSize = ConvolutionUtils.getOutputSize(this.input, kernel, strides, null, this.convolutionMode, dilation);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{this.input.size(2), this.input.size(3)}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding();
            outSize = ConvolutionUtils.getOutputSize(this.input, kernel, strides, pad, this.convolutionMode, dilation);
        }
        int outH = outSize[0];
        int outW = outSize[1];
        int miniBatch = this.input.size(0);
        INDArray output = workspaceMgr.create(ArrayType.ACTIVATIONS, new int[]{miniBatch, outDepth, outH, outW}, 'c');
        Integer sameMode = this.convolutionMode == ConvolutionMode.Same ? 1 : 0;
        int[] args = new int[]{kH, kW, strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], sameMode};
        INDArray[] opInputs = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias() ? new INDArray[]{this.input, depthWiseWeights, pointWiseWeights, bias} : new INDArray[]{this.input, depthWiseWeights, pointWiseWeights};
        DynamicCustomOp op = DynamicCustomOp.builder((String)"sconv2d").addInputs(opInputs).addIntegerArguments(args).addOutputs(new INDArray[]{output}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        return new Pair((Object)output, null);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        if (this.cacheMode == null) {
            this.cacheMode = CacheMode.NONE;
        }
        this.applyDropOutIfNecessary(training, workspaceMgr);
        INDArray z = (INDArray)this.preOutput(training, false, workspaceMgr).getFirst();
        IActivation afn = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn();
        INDArray activation = afn.getActivation(z, training);
        return activation;
    }
}

