/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.convolution.ConvolutionLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.Pair;

public class Convolution1DLayer
extends ConvolutionLayer {
    public Convolution1DLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public Convolution1DLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        if (epsilon.rank() != 3) {
            throw new DL4JInvalidInputException("Got rank " + epsilon.rank() + " array as epsilon for Convolution1DLayer backprop with shape " + Arrays.toString(epsilon.shape()) + ". Expected rank 3 array with shape [minibatchSize, features, length]. " + this.layerId());
        }
        epsilon = epsilon.reshape(new int[]{epsilon.size(0), epsilon.size(1), epsilon.size(2), 1});
        INDArray origInput = this.input;
        this.input = this.input.reshape(new int[]{this.input.size(0), this.input.size(1), this.input.size(2), 1});
        Pair<Gradient, INDArray> gradientEpsNext = super.backpropGradient(epsilon, workspaceMgr);
        INDArray epsNext = (INDArray)gradientEpsNext.getSecond();
        epsNext = epsNext.reshape(new int[]{epsNext.size(0), epsNext.size(1), epsNext.size(2)});
        this.input = origInput;
        return new Pair(gradientEpsNext.getFirst(), (Object)epsNext);
    }

    @Override
    protected Pair<INDArray, INDArray> preOutput4d(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        Pair<INDArray, INDArray> preOutput = super.preOutput(true, forBackprop, workspaceMgr);
        INDArray p3d = (INDArray)preOutput.getFirst();
        INDArray p = ((INDArray)preOutput.getFirst()).reshape(new int[]{p3d.size(0), p3d.size(1), p3d.size(2), 1});
        preOutput.setFirst((Object)p);
        return preOutput;
    }

    @Override
    protected Pair<INDArray, INDArray> preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        INDArray origInput = this.input;
        this.input = this.input.reshape(new int[]{this.input.size(0), this.input.size(1), this.input.size(2), 1});
        Pair<INDArray, INDArray> preOutput = super.preOutput(training, forBackprop, workspaceMgr);
        this.input = origInput;
        INDArray p4d = (INDArray)preOutput.getFirst();
        INDArray p = ((INDArray)preOutput.getFirst()).reshape(new int[]{p4d.size(0), p4d.size(1), p4d.size(2)});
        preOutput.setFirst((Object)p);
        return preOutput;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray act4d = super.activate(training, workspaceMgr);
        INDArray act3d = act4d.reshape(new int[]{act4d.size(0), act4d.size(1), act4d.size(2)});
        return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, act3d);
    }
}

