/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.optimize.Solver;
import org.deeplearning4j.optimize.api.ConvexOptimizer;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.primitives.Pair;

public abstract class BaseLayer<LayerConfT extends org.deeplearning4j.nn.conf.layers.BaseLayer>
extends AbstractLayer<LayerConfT> {
    protected INDArray paramsFlattened;
    protected INDArray gradientsFlattened;
    protected Map<String, INDArray> params;
    protected transient Map<String, INDArray> gradientViews;
    protected double score = 0.0;
    protected ConvexOptimizer optimizer;
    protected Gradient gradient;
    protected Solver solver;
    protected Map<String, INDArray> weightNoiseParams = new HashMap<String, INDArray>();

    public BaseLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public BaseLayer(NeuralNetConfiguration conf, INDArray input) {
        this(conf);
        this.input = input;
    }

    @Override
    public LayerConfT layerConf() {
        return (LayerConfT)((org.deeplearning4j.nn.conf.layers.BaseLayer)this.conf.getLayer());
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        INDArray z = this.preOutput(true, workspaceMgr);
        INDArray delta = (INDArray)((org.deeplearning4j.nn.conf.layers.BaseLayer)this.layerConf()).getActivationFn().backprop(z, epsilon).getFirst();
        if (this.maskArray != null) {
            this.applyMask(delta);
        }
        DefaultGradient ret = new DefaultGradient();
        INDArray weightGrad = this.gradientViews.get("W");
        Nd4j.gemm((INDArray)this.input, (INDArray)delta, (INDArray)weightGrad, (boolean)true, (boolean)false, (double)1.0, (double)0.0);
        ret.gradientForVariable().put("W", weightGrad);
        if (this.hasBias()) {
            INDArray biasGrad = this.gradientViews.get("b");
            delta.sum(biasGrad, new int[]{0});
            ret.gradientForVariable().put("b", biasGrad);
        }
        INDArray W = this.getParamWithNoise("W", true, workspaceMgr);
        INDArray epsilonNext = workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, new int[]{W.size(0), delta.size(0)}, 'f');
        epsilonNext = W.mmuli(delta.transpose(), epsilonNext).transpose();
        this.weightNoiseParams.clear();
        return new Pair((Object)ret, (Object)epsilonNext);
    }

    @Override
    public void fit() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void computeGradientAndScore(LayerWorkspaceMgr workspaceMgr) {
        if (this.input == null) {
            return;
        }
        INDArray output = this.activate(true, workspaceMgr);
        this.setScoreWithZ(output);
    }

    protected void setScoreWithZ(INDArray z) {
    }

    @Override
    public double score() {
        return this.score;
    }

    @Override
    public Gradient gradient() {
        return this.gradient;
    }

    @Override
    public void update(Gradient gradient) {
        for (String paramType : gradient.gradientForVariable().keySet()) {
            this.update(gradient.getGradientFor(paramType), paramType);
        }
    }

    @Override
    public void update(INDArray gradient, String paramType) {
        this.setParam(paramType, this.getParam(paramType).addi(gradient));
    }

    @Override
    public ConvexOptimizer getOptimizer() {
        if (this.optimizer == null) {
            Solver solver = new Solver.Builder().model(this).configure(this.conf()).build();
            this.optimizer = solver.getOptimizer();
        }
        return this.optimizer;
    }

    @Override
    public INDArray params() {
        return this.paramsFlattened;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params.get(param);
    }

    @Override
    public void setParam(String key, INDArray val) {
        if (this.params.containsKey(key)) {
            this.params.get(key).assign(val);
        } else {
            this.params.put(key, val);
        }
    }

    @Override
    public void setParams(INDArray params) {
        if (params == this.paramsFlattened) {
            return;
        }
        this.setParams(params, 'f');
    }

    @Override
    protected void setParams(INDArray params, char order) {
        List<String> parameterList = this.conf.variables();
        int length = 0;
        for (String s : parameterList) {
            length += this.getParam(s).length();
        }
        if (params.length() != length) {
            throw new IllegalArgumentException("Unable to set parameters: must be of length " + length + ", got params of length " + params.length() + " - " + this.layerId());
        }
        int idx = 0;
        Set<String> paramKeySet = this.params.keySet();
        for (String s : paramKeySet) {
            INDArray param = this.getParam(s);
            INDArray get = params.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)idx, (int)(idx + param.length()))});
            if (param.length() != get.length()) {
                throw new IllegalStateException("Parameter " + s + " should have been of length " + param.length() + " but was " + get.length() + " - " + this.layerId());
            }
            param.assign(get.reshape(order, param.shape()));
            idx += param.length();
        }
    }

    @Override
    public void setParamsViewArray(INDArray params) {
        if (this.params != null && params.length() != this.numParams()) {
            throw new IllegalArgumentException("Invalid input: expect params of length " + this.numParams() + ", got params of length " + params.length() + " - " + this.layerId());
        }
        this.paramsFlattened = params;
    }

    @Override
    public INDArray getGradientsViewArray() {
        return this.gradientsFlattened;
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray gradients) {
        if (this.params != null && gradients.length() != this.numParams()) {
            throw new IllegalArgumentException("Invalid input: expect gradients array of length " + this.numParams(true) + ", got array of length " + gradients.length() + " - " + this.layerId());
        }
        this.gradientsFlattened = gradients;
        this.gradientViews = this.conf.getLayer().initializer().getGradientsFromFlattened(this.conf, gradients);
    }

    @Override
    public void setParamTable(Map<String, INDArray> paramTable) {
        this.params = paramTable;
    }

    @Override
    public void initParams() {
        throw new UnsupportedOperationException("Deprecated - no longer used - " + this.layerId());
    }

    @Override
    public Map<String, INDArray> paramTable() {
        return this.paramTable(false);
    }

    @Override
    public Map<String, INDArray> paramTable(boolean backpropParamsOnly) {
        return this.params;
    }

    protected INDArray getParamWithNoise(String param, boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray p;
        if (((org.deeplearning4j.nn.conf.layers.BaseLayer)this.layerConf()).getWeightNoise() != null) {
            if (training && this.weightNoiseParams.size() > 0 && this.weightNoiseParams.containsKey(param)) {
                return this.weightNoiseParams.get(param);
            }
            try (MemoryWorkspace ws = Nd4j.getMemoryManager().scopeOutOfWorkspaces();){
                p = ((org.deeplearning4j.nn.conf.layers.BaseLayer)this.layerConf()).getWeightNoise().getParameter(this, param, this.getIterationCount(), this.getEpochCount(), training, workspaceMgr);
            }
            if (training) {
                this.weightNoiseParams.put(param, p);
            }
        } else {
            return this.getParam(param);
        }
        return p;
    }

    protected INDArray preOutput(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        this.applyDropOutIfNecessary(training, workspaceMgr);
        INDArray W = this.getParamWithNoise("W", training, workspaceMgr);
        INDArray b = this.getParamWithNoise("b", training, workspaceMgr);
        if (this.input.rank() != 2 || this.input.columns() != W.rows()) {
            if (this.input.rank() != 2) {
                throw new DL4JInvalidInputException("Input that is not a matrix; expected matrix (rank 2), got rank " + this.input.rank() + " array with shape " + Arrays.toString(this.input.shape()) + ". Missing preprocessor or wrong input type? " + this.layerId());
            }
            throw new DL4JInvalidInputException("Input size (" + this.input.columns() + " columns; shape = " + Arrays.toString(this.input.shape()) + ") is invalid: does not match layer input size (layer # inputs = " + W.size(0) + ") " + this.layerId());
        }
        INDArray ret = workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, new int[]{this.input.size(0), W.size(1)});
        this.input.mmuli(W, ret);
        if (this.hasBias()) {
            ret.addiRowVector(b);
        }
        if (this.maskArray != null) {
            this.applyMask(ret);
        }
        return ret;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray z = this.preOutput(training, workspaceMgr);
        INDArray ret = ((org.deeplearning4j.nn.conf.layers.BaseLayer)this.layerConf()).getActivationFn().getActivation(z, training);
        if (this.maskArray != null) {
            this.applyMask(ret);
        }
        return ret;
    }

    @Override
    public double calcL2(boolean backpropParamsOnly) {
        double l2Sum = 0.0;
        for (Map.Entry<String, INDArray> entry : this.paramTable().entrySet()) {
            double l2 = this.conf.getL2ByParam(entry.getKey());
            if (!(l2 > 0.0)) continue;
            double norm2 = this.getParam(entry.getKey()).norm2Number().doubleValue();
            l2Sum += 0.5 * l2 * norm2 * norm2;
        }
        return l2Sum;
    }

    @Override
    public double calcL1(boolean backpropParamsOnly) {
        double l1Sum = 0.0;
        for (Map.Entry<String, INDArray> entry : this.paramTable().entrySet()) {
            double l1 = this.conf.getL1ByParam(entry.getKey());
            if (!(l1 > 0.0)) continue;
            double norm1 = this.getParam(entry.getKey()).norm1Number().doubleValue();
            l1Sum += l1 * norm1;
        }
        return l1Sum;
    }

    @Override
    public Layer clone() {
        Layer layer = null;
        try {
            Constructor<?> c = this.getClass().getConstructor(NeuralNetConfiguration.class);
            layer = (Layer)c.newInstance(this.conf);
            LinkedHashMap<String, INDArray> linkedTable = new LinkedHashMap<String, INDArray>();
            for (Map.Entry<String, INDArray> entry : this.params.entrySet()) {
                linkedTable.put(entry.getKey(), entry.getValue().dup());
            }
            layer.setParamTable(linkedTable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return layer;
    }

    @Override
    public int numParams() {
        int ret = 0;
        for (INDArray val : this.params.values()) {
            ret += val.length();
        }
        return ret;
    }

    @Override
    public void fit(INDArray input, LayerWorkspaceMgr workspaceMgr) {
        if (input != null) {
            this.setInput(input, workspaceMgr);
            this.applyDropOutIfNecessary(true, workspaceMgr);
        }
        if (this.solver == null) {
            this.solver = new Solver.Builder().model(this).configure(this.conf()).listeners(this.getListeners()).build();
        }
        this.optimizer = this.solver.getOptimizer();
        this.solver.optimize(workspaceMgr);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "{conf=" + this.conf + ", dropoutMask=" + this.dropoutMask + ", score=" + this.score + ", optimizer=" + this.optimizer + ", listeners=" + this.trainingListeners + '}';
    }

    @Override
    public Layer transpose() {
        Layer layer;
        if (!(this.conf.getLayer() instanceof FeedForwardLayer)) {
            throw new UnsupportedOperationException("Unsupported layer type: " + this.conf.getLayer().getClass().getName() + " - " + this.layerId());
        }
        INDArray w = this.getParam("W");
        INDArray b = this.getParam("b");
        INDArray vb = this.getParam("vb");
        try {
            INDArray newB;
            NeuralNetConfiguration clone = this.conf.clone();
            FeedForwardLayer clonedLayerConf = (FeedForwardLayer)clone.getLayer();
            int nIn = clonedLayerConf.getNOut();
            int nOut = clonedLayerConf.getNIn();
            clonedLayerConf.setNIn(nIn);
            clonedLayerConf.setNOut(nOut);
            INDArray newVB = null;
            int totalParams = w.length();
            if (vb != null) {
                newB = vb.dup();
                newVB = b.dup();
                totalParams += newB.length() + newVB.length();
            } else {
                newB = Nd4j.create((int)1, (int)nOut);
                totalParams += newB.length();
            }
            INDArray paramsView = Nd4j.create((int)1, (int)totalParams);
            layer = clone.getLayer().instantiate(clone, this.trainingListeners, this.index, paramsView, true);
            layer.setParam("W", w.transpose().dup());
            layer.setParam("b", newB);
            if (vb != null) {
                layer.setParam("vb", newVB);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to construct transposed layer: " + this.layerId(), e);
        }
        return layer;
    }

    @Override
    public void accumulateScore(double accum) {
        this.score += accum;
    }

    @Override
    public void clear() {
        super.clear();
        this.weightNoiseParams.clear();
    }

    @Override
    public void clearNoiseWeightParams() {
        this.weightNoiseParams.clear();
    }

    public boolean hasBias() {
        return true;
    }
}

