/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.weightnoise;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.weightnoise.IWeightNoise;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.ops.random.impl.DropOut;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class DropConnect
implements IWeightNoise {
    private double weightRetainProb;
    private ISchedule weightRetainProbSchedule;
    private boolean applyToBiases;

    public DropConnect(double weightRetainProbability) {
        this(weightRetainProbability, false);
    }

    public DropConnect(double weightRetainProbability, boolean applyToBiases) {
        this(weightRetainProbability, null, applyToBiases);
    }

    public DropConnect(ISchedule weightRetainProbSchedule) {
        this(Double.NaN, weightRetainProbSchedule, false);
    }

    public DropConnect(ISchedule weightRetainProbSchedule, boolean applyToBiases) {
        this(Double.NaN, weightRetainProbSchedule, applyToBiases);
    }

    private DropConnect(@JsonProperty(value="weightRetainProbability") double weightRetainProbability, @JsonProperty(value="weightRetainProbSchedule") ISchedule weightRetainProbSchedule, @JsonProperty(value="applyToBiases") boolean applyToBiases) {
        this.weightRetainProb = weightRetainProbability;
        this.weightRetainProbSchedule = weightRetainProbSchedule;
        this.applyToBiases = applyToBiases;
    }

    @Override
    public INDArray getParameter(Layer layer, String paramKey, int iteration, int epoch, boolean train, LayerWorkspaceMgr workspaceMgr) {
        ParamInitializer init = layer.conf().getLayer().initializer();
        INDArray param = layer.getParam(paramKey);
        double p = this.weightRetainProbSchedule == null ? this.weightRetainProb : this.weightRetainProbSchedule.valueAt(iteration, epoch);
        if (train && init.isWeightParam(layer.conf().getLayer(), paramKey) || this.applyToBiases && init.isBiasParam(layer.conf().getLayer(), paramKey)) {
            INDArray out = workspaceMgr.createUninitialized(ArrayType.INPUT, param.shape(), param.ordering());
            Nd4j.getExecutioner().exec((RandomOp)new DropOut(param, out, p));
            return out;
        }
        return param;
    }

    @Override
    public DropConnect clone() {
        return new DropConnect(this.weightRetainProb, this.weightRetainProbSchedule, this.applyToBiases);
    }

    public double getWeightRetainProb() {
        return this.weightRetainProb;
    }

    public ISchedule getWeightRetainProbSchedule() {
        return this.weightRetainProbSchedule;
    }

    public boolean isApplyToBiases() {
        return this.applyToBiases;
    }

    public void setWeightRetainProb(double weightRetainProb) {
        this.weightRetainProb = weightRetainProb;
    }

    public void setWeightRetainProbSchedule(ISchedule weightRetainProbSchedule) {
        this.weightRetainProbSchedule = weightRetainProbSchedule;
    }

    public void setApplyToBiases(boolean applyToBiases) {
        this.applyToBiases = applyToBiases;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DropConnect)) {
            return false;
        }
        DropConnect other = (DropConnect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getWeightRetainProb(), other.getWeightRetainProb()) != 0) {
            return false;
        }
        ISchedule this$weightRetainProbSchedule = this.getWeightRetainProbSchedule();
        ISchedule other$weightRetainProbSchedule = other.getWeightRetainProbSchedule();
        if (this$weightRetainProbSchedule == null ? other$weightRetainProbSchedule != null : !this$weightRetainProbSchedule.equals(other$weightRetainProbSchedule)) {
            return false;
        }
        return this.isApplyToBiases() == other.isApplyToBiases();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DropConnect;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $weightRetainProb = Double.doubleToLongBits(this.getWeightRetainProb());
        result = result * 59 + (int)($weightRetainProb >>> 32 ^ $weightRetainProb);
        ISchedule $weightRetainProbSchedule = this.getWeightRetainProbSchedule();
        result = result * 59 + ($weightRetainProbSchedule == null ? 43 : $weightRetainProbSchedule.hashCode());
        result = result * 59 + (this.isApplyToBiases() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "DropConnect(weightRetainProb=" + this.getWeightRetainProb() + ", weightRetainProbSchedule=" + this.getWeightRetainProbSchedule() + ", applyToBiases=" + this.isApplyToBiases() + ")";
    }
}

