/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.ocnn;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.BaseOutputLayer;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.layers.ocnn.OCNNParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationIdentity;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"lossFn"})
public class OCNNOutputLayer
extends BaseOutputLayer {
    private int hiddenSize;
    private double nu = 0.04;
    private IActivation activation;
    private int lastEpochSinceRUpdated = 0;

    public OCNNOutputLayer(Builder builder) {
        super(builder);
        this.hiddenSize = builder.hiddenLayerSize;
        this.nu = builder.nu;
        this.activation = builder.activation;
    }

    @JsonCreator
    public OCNNOutputLayer(@JsonProperty(value="hiddenSize") int hiddenSize, @JsonProperty(value="nu") double nu, @JsonProperty(value="activation") IActivation activation) {
        this.hiddenSize = hiddenSize;
        this.nu = nu;
        this.activation = activation;
    }

    @Override
    public ILossFunction getLossFn() {
        return this.lossFn;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        LayerValidation.assertNInNOutSet("OCNNOutputLayer", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        org.deeplearning4j.nn.layers.ocnn.OCNNOutputLayer ret = new org.deeplearning4j.nn.layers.ocnn.OCNNOutputLayer(conf);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        ret.setActivation(this.getActivation());
        return ret;
    }

    @Override
    public int getNOut() {
        return 1;
    }

    @Override
    public ParamInitializer initializer() {
        return OCNNParamInitializer.getInstance();
    }

    @Override
    public double getL1ByParam(String paramName) {
        return this.l1;
    }

    @Override
    public double getL2ByParam(String paramName) {
        return this.l2;
    }

    public int getHiddenSize() {
        return this.hiddenSize;
    }

    public double getNu() {
        return this.nu;
    }

    public IActivation getActivation() {
        return this.activation;
    }

    public int getLastEpochSinceRUpdated() {
        return this.lastEpochSinceRUpdated;
    }

    public void setHiddenSize(int hiddenSize) {
        this.hiddenSize = hiddenSize;
    }

    public void setNu(double nu) {
        this.nu = nu;
    }

    public void setActivation(IActivation activation) {
        this.activation = activation;
    }

    public void setLastEpochSinceRUpdated(int lastEpochSinceRUpdated) {
        this.lastEpochSinceRUpdated = lastEpochSinceRUpdated;
    }

    public OCNNOutputLayer() {
    }

    @Override
    public String toString() {
        return "OCNNOutputLayer(super=" + super.toString() + ", hiddenSize=" + this.getHiddenSize() + ", nu=" + this.getNu() + ", activation=" + this.getActivation() + ", lastEpochSinceRUpdated=" + this.getLastEpochSinceRUpdated() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OCNNOutputLayer)) {
            return false;
        }
        OCNNOutputLayer other = (OCNNOutputLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getHiddenSize() != other.getHiddenSize()) {
            return false;
        }
        if (Double.compare(this.getNu(), other.getNu()) != 0) {
            return false;
        }
        IActivation this$activation = this.getActivation();
        IActivation other$activation = other.getActivation();
        if (this$activation == null ? other$activation != null : !this$activation.equals(other$activation)) {
            return false;
        }
        return this.getLastEpochSinceRUpdated() == other.getLastEpochSinceRUpdated();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OCNNOutputLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getHiddenSize();
        long $nu = Double.doubleToLongBits(this.getNu());
        result = result * 59 + (int)($nu >>> 32 ^ $nu);
        IActivation $activation = this.getActivation();
        result = result * 59 + ($activation == null ? 43 : $activation.hashCode());
        result = result * 59 + this.getLastEpochSinceRUpdated();
        return result;
    }

    public static class Builder
    extends BaseOutputLayer.Builder<Builder> {
        protected int hiddenLayerSize;
        protected double nu = 0.04;
        protected IActivation activation = new ActivationIdentity();

        public Builder nu(double nu) {
            this.nu = nu;
            return this;
        }

        @Override
        public Builder activation(IActivation activation) {
            this.activation = activation;
            return this;
        }

        public Builder hiddenLayerSize(int hiddenLayerSize) {
            this.hiddenLayerSize = hiddenLayerSize;
            return this;
        }

        @Override
        public Builder nOut(int nOut) {
            throw new UnsupportedOperationException("Unable to specify number of outputs with ocnn. Outputs are fixed to 1.");
        }

        @Override
        public OCNNOutputLayer build() {
            return new OCNNOutputLayer(this);
        }
    }
}

